/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.awscredentials;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.cloudbees.jenkins.plugins.awscredentials.BaseAmazonWebServicesCredentials;
import com.cloudbees.jenkins.plugins.awscredentials.Messages;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;

public class AWSCredentialsImpl
extends BaseAmazonWebServicesCredentials {
    private static final long serialVersionUID = -3167989896315282034L;
    private static final Logger LOGGER = Logger.getLogger(BaseAmazonWebServicesCredentials.class.getName());
    public static final int STS_CREDENTIALS_DURATION_SECONDS = 3600;
    private final String accessKey;
    private final Secret secretKey;
    private final String iamRoleArn;
    private final String iamExternalId;
    private final String iamMfaSerialNumber;
    private volatile Integer stsTokenDuration;

    public AWSCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String accessKey, @CheckForNull String secretKey, @CheckForNull String description) {
        this(scope, id, accessKey, secretKey, description, null, null, null);
    }

    public AWSCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String accessKey, @CheckForNull String secretKey, @CheckForNull String description, @CheckForNull String iamRoleArn, @CheckForNull String iamMfaSerialNumber) {
        this(scope, id, accessKey, secretKey, description, iamRoleArn, iamMfaSerialNumber, null);
    }

    @DataBoundConstructor
    public AWSCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String accessKey, @CheckForNull String secretKey, @CheckForNull String description, @CheckForNull String iamRoleArn, @CheckForNull String iamMfaSerialNumber, String iamExternalId) {
        super(scope, id, description);
        this.accessKey = Util.fixNull((String)accessKey);
        this.secretKey = Secret.fromString((String)secretKey);
        this.iamRoleArn = Util.fixNull((String)iamRoleArn);
        this.iamExternalId = Util.fixNull((String)iamExternalId);
        this.iamMfaSerialNumber = Util.fixNull((String)iamMfaSerialNumber);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public Secret getSecretKey() {
        return this.secretKey;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public String getIamExternalId() {
        return this.iamExternalId;
    }

    public String getIamMfaSerialNumber() {
        return this.iamMfaSerialNumber;
    }

    @NonNull
    public Integer getStsTokenDuration() {
        return this.stsTokenDuration == null ? DescriptorImpl.DEFAULT_STS_TOKEN_DURATION : this.stsTokenDuration;
    }

    @DataBoundSetter
    public void setStsTokenDuration(Integer stsTokenDuration) {
        this.stsTokenDuration = stsTokenDuration == null || stsTokenDuration.equals(DescriptorImpl.DEFAULT_STS_TOKEN_DURATION) ? null : stsTokenDuration;
    }

    public boolean requiresToken() {
        return !StringUtils.isBlank((String)this.iamMfaSerialNumber);
    }

    public AwsCredentials resolveCredentials() {
        if (StringUtils.isBlank((String)this.iamRoleArn)) {
            if (StringUtils.isBlank((String)this.accessKey) && StringUtils.isBlank((String)this.secretKey.getPlainText())) {
                return null;
            }
            return AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey.getPlainText());
        }
        StaticCredentialsProvider baseProvider = StringUtils.isBlank((String)this.accessKey) && StringUtils.isBlank((String)this.secretKey.getPlainText()) ? null : StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey.getPlainText()));
        StsClient client = AWSCredentialsImpl.buildStsClient((AwsCredentialsProvider)baseProvider);
        AssumeRoleRequest.Builder assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(this.iamRoleArn, this.iamExternalId).durationSeconds(this.getStsTokenDuration());
        AssumeRoleResponse assumeResult = client.assumeRole((AssumeRoleRequest)assumeRequest.build());
        return AwsSessionCredentials.create((String)assumeResult.credentials().accessKeyId(), (String)assumeResult.credentials().secretAccessKey(), (String)assumeResult.credentials().sessionToken());
    }

    private static Region determineClientRegion() {
        DefaultAwsRegionProviderChain sdkRegionLookup = new DefaultAwsRegionProviderChain();
        try {
            return sdkRegionLookup.getRegion();
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Could not find default region using SDK lookup.", e);
            return Region.US_EAST_1;
        }
    }

    @Override
    public AwsCredentials resolveCredentials(String mfaToken) {
        AwsBasicCredentials initialCredentials = AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey.getPlainText());
        AssumeRoleRequest.Builder assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(this.iamRoleArn, this.iamExternalId).serialNumber(this.iamMfaSerialNumber).tokenCode(mfaToken).durationSeconds(this.getStsTokenDuration());
        StsClient stsClient = AWSCredentialsImpl.getStsClient((AwsCredentials)initialCredentials);
        AssumeRoleResponse assumeResult = stsClient.assumeRole((AssumeRoleRequest)assumeRequest.build());
        return AwsSessionCredentials.create((String)assumeResult.credentials().accessKeyId(), (String)assumeResult.credentials().secretAccessKey(), (String)assumeResult.credentials().sessionToken());
    }

    @Deprecated
    public AWSCredentials getCredentials() {
        AwsCredentials credentials = this.resolveCredentials();
        return credentials != null ? AWSCredentialsImpl.fromAwsCredentials(credentials) : null;
    }

    @Override
    @Deprecated
    public AWSCredentials getCredentials(String mfaToken) {
        return AWSCredentialsImpl.fromAwsCredentials(this.resolveCredentials(mfaToken));
    }

    private static AWSCredentials fromAwsCredentials(AwsCredentials awsCredentials) {
        Objects.requireNonNull(awsCredentials);
        if (awsCredentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials awsSessionCredentials = (AwsSessionCredentials)awsCredentials;
            return AWSCredentialsImpl.fromAwsSessionCredentials(awsSessionCredentials);
        }
        return new BasicAWSCredentials(awsCredentials.accessKeyId(), awsCredentials.secretAccessKey(), (String)awsCredentials.accountId().orElse(null), (String)awsCredentials.providerName().orElse(null));
    }

    private static AWSSessionCredentials fromAwsSessionCredentials(AwsSessionCredentials awsSessionCredentials) {
        Objects.requireNonNull(awsSessionCredentials);
        return new BasicSessionCredentials(awsSessionCredentials.accessKeyId(), awsSessionCredentials.secretAccessKey(), awsSessionCredentials.sessionToken(), (String)awsSessionCredentials.accountId().orElse(null), (String)awsSessionCredentials.providerName().orElse(null));
    }

    @Deprecated
    public void refresh() {
    }

    @Override
    public String getDisplayName() {
        if (StringUtils.isBlank((String)this.iamRoleArn)) {
            return this.accessKey;
        }
        return this.accessKey + ":" + this.iamRoleArn;
    }

    static StsClient buildStsClient(AwsCredentialsProvider provider) {
        Region clientRegion = AWSCredentialsImpl.determineClientRegion();
        StsClientBuilder builder = (StsClientBuilder)((StsClientBuilder)StsClient.builder().region(clientRegion)).httpClient(AWSCredentialsImpl.getHttpClient());
        if (provider != null) {
            builder = (StsClientBuilder)builder.credentialsProvider(provider);
        }
        return (StsClient)builder.build();
    }

    private static AssumeRoleRequest.Builder createAssumeRoleRequest(String iamRoleArn, String iamExternalId) {
        AssumeRoleRequest.Builder retval = AssumeRoleRequest.builder().roleArn(iamRoleArn).roleSessionName("Jenkins");
        if (iamExternalId != null && !iamExternalId.isEmpty()) {
            return retval.externalId(iamExternalId);
        }
        return retval;
    }

    private static StsClient getStsClient(AwsCredentials awsCredentials) {
        SdkHttpClient clientConfiguration = AWSCredentialsImpl.getHttpClient();
        Region clientRegion = AWSCredentialsImpl.determineClientRegion();
        return (StsClient)((StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(clientRegion)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials))).httpClient(clientConfiguration)).build();
    }

    private static SdkHttpClient getHttpClient() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        hudson.ProxyConfiguration proxy = instance != null ? instance.proxy : null;
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        if (proxy != null && proxy.name != null && !proxy.name.isEmpty()) {
            List patterns;
            ProxyConfiguration.Builder proxyConfiguration = ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxy.name, proxy.port)));
            if (proxy.getUserName() != null) {
                proxyConfiguration.username(proxy.getUserName());
                proxyConfiguration.password(Secret.toString((Secret)proxy.getSecretPassword()));
            }
            if ((patterns = proxy.getNoProxyHostPatterns()) != null && !patterns.isEmpty()) {
                patterns.stream().map(Pattern::pattern).forEach(arg_0 -> ((ProxyConfiguration.Builder)proxyConfiguration).addNonProxyHost(arg_0));
            }
            builder.proxyConfiguration((ProxyConfiguration)proxyConfiguration.build());
        }
        return builder.build();
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public static final Integer DEFAULT_STS_TOKEN_DURATION = 3600;

        public String getDisplayName() {
            return Messages.AWSCredentialsImpl_DisplayName();
        }

        @POST
        public FormValidation doCheckSecretKey(@QueryParameter(value="accessKey") String accessKey, @QueryParameter(value="iamRoleArn") String iamRoleArn, @QueryParameter(value="iamExternalId") String iamExternalId, @QueryParameter(value="iamMfaSerialNumber") String iamMfaSerialNumber, @QueryParameter(value="iamMfaToken") String iamMfaToken, @QueryParameter(value="stsTokenDuration") Integer stsTokenDuration, @QueryParameter String secretKey) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)accessKey) && StringUtils.isBlank((String)secretKey)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)accessKey)) {
                return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifyAccessKeyId());
            }
            if (StringUtils.isBlank((String)secretKey)) {
                return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifySecretAccessKey());
            }
            AwsBasicCredentials awsCredentials = AwsBasicCredentials.create((String)accessKey, (String)Secret.fromString((String)secretKey).getPlainText());
            if (!StringUtils.isBlank((String)iamRoleArn)) {
                AssumeRoleRequest.Builder assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(iamRoleArn, iamExternalId).durationSeconds(stsTokenDuration);
                if (!StringUtils.isBlank((String)iamMfaSerialNumber)) {
                    if (StringUtils.isBlank((String)iamMfaToken)) {
                        return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifyMFAToken());
                    }
                    assumeRequest = assumeRequest.serialNumber(iamMfaSerialNumber).tokenCode(iamMfaToken);
                }
                try {
                    StsClient stsClient = AWSCredentialsImpl.getStsClient((AwsCredentials)awsCredentials);
                    AssumeRoleResponse assumeResult = stsClient.assumeRole((AssumeRoleRequest)assumeRequest.build());
                    awsCredentials = AwsSessionCredentials.create((String)assumeResult.credentials().accessKeyId(), (String)assumeResult.credentials().secretAccessKey(), (String)assumeResult.credentials().sessionToken());
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Unable to assume role [" + iamRoleArn + "] with request [" + String.valueOf(assumeRequest) + "]", e);
                    return FormValidation.error((String)(Messages.AWSCredentialsImpl_NotAbleToAssumeRole() + " Check the Jenkins log for more details"));
                }
            }
            Region region = AWSCredentialsImpl.determineClientRegion();
            Ec2Client ec2 = (Ec2Client)((Ec2ClientBuilder)((Ec2ClientBuilder)((Ec2ClientBuilder)Ec2Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials))).httpClient(AWSCredentialsImpl.getHttpClient())).region(region)).build();
            try {
                DescribeAvailabilityZonesResponse zonesResult = ec2.describeAvailabilityZones();
                return FormValidation.ok((String)Messages.AWSCredentialsImpl_CredentialsValidWithAccessToNZones(zonesResult.availabilityZones().size()));
            }
            catch (AwsServiceException e) {
                if (401 == e.awsErrorDetails().sdkHttpResponse().statusCode()) {
                    return FormValidation.warning((String)Messages.AWSCredentialsImpl_CredentialsInValid(e.getMessage()));
                }
                if (403 == e.awsErrorDetails().sdkHttpResponse().statusCode()) {
                    return FormValidation.ok((String)Messages.AWSCredentialsImpl_CredentialsValidWithoutAccessToAwsServiceInZone(e.awsErrorDetails().serviceName(), region, e.awsErrorDetails().errorMessage() + " (" + e.awsErrorDetails().errorCode() + ")"));
                }
                return FormValidation.error((String)e.getMessage());
            }
            catch (SdkException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

