/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Queue;
import java.util.stream.Collectors;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectUtil;
import org.jenkinsci.plugins.authorizeproject.Messages;
import org.jenkinsci.plugins.authorizeproject.strategy.AnonymousAuthorizationStrategy;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class GlobalQueueItemAuthenticator
extends QueueItemAuthenticator {
    private final AuthorizeProjectStrategy strategy;

    @DataBoundConstructor
    public GlobalQueueItemAuthenticator(AuthorizeProjectStrategy strategy) {
        this.strategy = strategy;
    }

    public AuthorizeProjectStrategy getStrategy() {
        return this.strategy;
    }

    public Authentication authenticate2(Queue.Item item) {
        Authentication authentication;
        Queue.Task task;
        if (this.strategy != null && (task = item.task) instanceof Job) {
            Job j = (Job)task;
            authentication = this.strategy.authenticate(j, item);
        } else {
            authentication = null;
        }
        return authentication;
    }

    @Extension
    public static class DescriptorImpl
    extends QueueItemAuthenticatorDescriptor {
        public String getDisplayName() {
            return Messages.GlobalQueueItemAuthenticator_DisplayName();
        }

        public Iterable<Descriptor<AuthorizeProjectStrategy>> getStrategyDescriptors() {
            return AuthorizeProjectStrategy.all().stream().filter(d -> {
                if (!(d instanceof AuthorizeProjectStrategyDescriptor)) {
                    return true;
                }
                return ((AuthorizeProjectStrategyDescriptor)((Object)d)).isApplicableToGlobal();
            }).collect(Collectors.toList());
        }

        public AuthorizeProjectStrategy getDefaultStrategy() {
            return new AnonymousAuthorizationStrategy();
        }

        public GlobalQueueItemAuthenticator newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            if (formData == null || formData.isNullObject()) {
                return null;
            }
            AuthorizeProjectStrategy strategy = AuthorizeProjectUtil.bindJSONWithDescriptor(req, formData, "strategy", AuthorizeProjectStrategy.class);
            return new GlobalQueueItemAuthenticator(strategy);
        }
    }
}

