/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject.strategy;

import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.User;
import hudson.security.AccessControlled;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.strategy.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class TriggeringUsersAuthorizationStrategy
extends AuthorizeProjectStrategy {
    private static final Logger LOGGER = Logger.getLogger(TriggeringUsersAuthorizationStrategy.class.getName());

    @DataBoundConstructor
    public TriggeringUsersAuthorizationStrategy() {
    }

    @Override
    public Authentication authenticate(Job<?, ?> project, Queue.Item item) {
        Cause.UserIdCause cause = this.getRootUserIdCause(item);
        if (cause != null) {
            User u = User.get((String)cause.getUserId(), (boolean)false, Map.of());
            if (u == null) {
                return Jenkins.ANONYMOUS2;
            }
            try {
                return u.impersonate2();
            }
            catch (UsernameNotFoundException e) {
                LOGGER.log(Level.WARNING, "Invalid User %s. Falls back to anonymous.".formatted(cause.getUserId()), e);
                return Jenkins.ANONYMOUS2;
            }
        }
        return null;
    }

    private Cause.UserIdCause getRootUserIdCause(Queue.Item item) {
        Run upstream = null;
        for (Cause c : item.getCauses()) {
            if (c instanceof Cause.UserIdCause) {
                Cause.UserIdCause cause = (Cause.UserIdCause)c;
                return cause;
            }
            if (!(c instanceof Cause.UpstreamCause)) continue;
            Cause.UpstreamCause cause = (Cause.UpstreamCause)c;
            upstream = cause.getUpstreamRun();
        }
        while (upstream != null) {
            Cause.UserIdCause cause = (Cause.UserIdCause)upstream.getCause(Cause.UserIdCause.class);
            if (cause != null) {
                return cause;
            }
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)upstream.getCause(Cause.UpstreamCause.class);
            upstream = upstreamCause != null ? upstreamCause.getUpstreamRun() : null;
        }
        return null;
    }

    @Override
    public boolean hasJobConfigurePermission(AccessControlled context) {
        return context.hasPermission(Item.BUILD);
    }

    @Extension
    public static class DescriptorImpl
    extends AuthorizeProjectStrategyDescriptor {
        public String getDisplayName() {
            return Messages.TriggeringUsersAuthorizationStrategy_DisplayName();
        }
    }
}

