/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Job;
import hudson.model.Queue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectProperty;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class ProjectQueueItemAuthenticator
extends QueueItemAuthenticator {
    private final Set<String> enabledStrategies;
    private final Set<String> disabledStrategies;
    @Deprecated
    private transient Map<String, Boolean> strategyEnabledMap;

    @Deprecated
    public ProjectQueueItemAuthenticator() {
        this(Set.of(), Set.of());
    }

    @Deprecated
    public ProjectQueueItemAuthenticator(Map<String, Boolean> strategyEnabledMap) {
        this(strategyEnabledMap.entrySet().stream().filter(e -> ((Boolean)e.getValue()).equals(true)).map(Map.Entry::getKey).collect(Collectors.toSet()), strategyEnabledMap.entrySet().stream().filter(e -> ((Boolean)e.getValue()).equals(false)).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    @DataBoundConstructor
    public ProjectQueueItemAuthenticator(Set<String> enabledStrategies, Set<String> disabledStrategies) {
        this.enabledStrategies = enabledStrategies;
        this.disabledStrategies = disabledStrategies;
    }

    protected Object readResolve() {
        if (this.strategyEnabledMap != null) {
            return new ProjectQueueItemAuthenticator(this.strategyEnabledMap);
        }
        return this;
    }

    @CheckForNull
    public Authentication authenticate2(Queue.Item item) {
        AuthorizeProjectProperty prop;
        if (!(item.task instanceof Job)) {
            return null;
        }
        Job project = (Job)item.task;
        if (project instanceof AbstractProject) {
            AbstractProject abstractProject = (AbstractProject)project;
            project = abstractProject.getRootProject();
        }
        if ((prop = (AuthorizeProjectProperty)project.getProperty(AuthorizeProjectProperty.class)) == null) {
            return null;
        }
        return prop.authenticate(item);
    }

    @Deprecated
    public Map<String, Boolean> getStrategyEnabledMap() {
        HashMap<String, Boolean> strategyEnabledMap = new HashMap<String, Boolean>();
        for (String strategy : this.enabledStrategies) {
            strategyEnabledMap.put(strategy, true);
        }
        for (String strategy : this.disabledStrategies) {
            strategyEnabledMap.put(strategy, false);
        }
        return strategyEnabledMap;
    }

    public Set<String> getEnabledStrategies() {
        return this.enabledStrategies;
    }

    public Set<String> getDisabledStrategies() {
        return this.disabledStrategies;
    }

    public boolean isStrategyEnabled(Descriptor<?> d) {
        if (this.enabledStrategies.contains(d.getId())) {
            return true;
        }
        if (this.disabledStrategies.contains(d.getId())) {
            return false;
        }
        if (d instanceof AuthorizeProjectStrategyDescriptor) {
            AuthorizeProjectStrategyDescriptor descriptor = (AuthorizeProjectStrategyDescriptor)d;
            return descriptor.isEnabledByDefault();
        }
        return true;
    }

    public static ProjectQueueItemAuthenticator getConfigured() {
        for (QueueItemAuthenticator authenticator : QueueItemAuthenticatorConfiguration.get().getAuthenticators()) {
            if (!(authenticator instanceof ProjectQueueItemAuthenticator)) continue;
            ProjectQueueItemAuthenticator itemAuthenticator = (ProjectQueueItemAuthenticator)authenticator;
            return itemAuthenticator;
        }
        return null;
    }

    public static boolean isConfigured() {
        return ProjectQueueItemAuthenticator.getConfigured() != null;
    }

    @Extension
    public static class DescriptorVisibilityFilterImpl
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            if (!(context instanceof ProjectQueueItemAuthenticator)) {
                return true;
            }
            return ((ProjectQueueItemAuthenticator)((Object)context)).isStrategyEnabled(descriptor);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends QueueItemAuthenticatorDescriptor {
        public String getDisplayName() {
            return Messages.ProjectQueueItemAuthenticator_DisplayName();
        }

        @Deprecated
        public List<AuthorizeProjectStrategyDescriptor> getDescriptorsForGlobalSecurityConfigPage() {
            return AuthorizeProjectStrategyDescriptor.getDescriptorsForGlobalSecurityConfigPage();
        }

        public List<Descriptor<AuthorizeProjectStrategy>> getAvailableDescriptorList() {
            return AuthorizeProjectStrategy.all();
        }

        public ProjectQueueItemAuthenticator newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            HashSet<String> enabledStrategies = new HashSet<String>();
            HashSet<String> disabledStrategies = new HashSet<String>();
            for (Descriptor<AuthorizeProjectStrategy> d : this.getAvailableDescriptorList()) {
                String name = d.getJsonSafeClassName();
                if (formData.has(name)) {
                    AuthorizeProjectStrategyDescriptor descriptor;
                    enabledStrategies.add(d.getId());
                    if (!(d instanceof AuthorizeProjectStrategyDescriptor) || (descriptor = (AuthorizeProjectStrategyDescriptor)d).getGlobalSecurityConfigPage() == null) continue;
                    descriptor.configureFromGlobalSecurity(req, formData.getJSONObject(name));
                    continue;
                }
                disabledStrategies.add(d.getId());
            }
            return new ProjectQueueItemAuthenticator(enabledStrategies, disabledStrategies);
        }
    }
}

