/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.Messages;
import org.jenkinsci.plugins.authorizeproject.ProjectQueueItemAuthenticator;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;

public abstract class AuthorizeProjectStrategy
extends AbstractDescribableImpl<AuthorizeProjectStrategy>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(AuthorizeProjectStrategy.class.getName());

    public static DescriptorExtensionList<AuthorizeProjectStrategy, Descriptor<AuthorizeProjectStrategy>> all() {
        return Jenkins.get().getDescriptorList(AuthorizeProjectStrategy.class);
    }

    public abstract Authentication authenticate(Job<?, ?> var1, Queue.Item var2);

    public AuthorizeProjectStrategyDescriptor getDescriptor() {
        return (AuthorizeProjectStrategyDescriptor)super.getDescriptor();
    }

    public final void checkJobConfigurePermission(AccessControlled context) {
        if (!this.hasJobConfigurePermission(context)) {
            throw new AccessDeniedException(Messages.AuthorizeProjectStrategy_UserNotAuthorizedForJob(Jenkins.getAuthentication2().getName()));
        }
    }

    public boolean hasJobConfigurePermission(AccessControlled context) {
        return true;
    }

    public final void checkAuthorizationConfigurePermission(AccessControlled context) {
        if (!this.hasAuthorizationConfigurePermission(context)) {
            throw new AccessDeniedException(Messages.AuthorizeProjectStrategy_UserNotAuthorized(Jenkins.getAuthentication2().getName()));
        }
    }

    public boolean hasAuthorizationConfigurePermission(AccessControlled context) {
        return true;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.checkUnsecuredConfiguration();
        return this;
    }

    private void checkUnsecuredConfiguration() throws ObjectStreamException {
        AccessControlled context;
        Authentication authentication = Jenkins.getAuthentication2();
        if (authentication == ACL.SYSTEM2) {
            return;
        }
        if (!ProjectQueueItemAuthenticator.isConfigured()) {
            return;
        }
        if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return;
        }
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        AccessControlled accessControlled = context = request != null ? (AccessControlled)request.findAncestorObject(AccessControlled.class) : null;
        if (context == null) {
            context = Jenkins.get();
        }
        if (!this.hasJobConfigurePermission(context)) {
            String name = Jenkins.getAuthentication2().getName();
            String userNotAuthorizedForJob = Messages.AuthorizeProjectStrategy_UserNotAuthorizedForJob(name);
            throw new InvalidObjectException(userNotAuthorizedForJob);
        }
        if (!this.hasAuthorizationConfigurePermission(context)) {
            String name = Jenkins.getAuthentication2().getName();
            String userNotAuthorized = Messages.AuthorizeProjectStrategy_UserNotAuthorized(name);
            throw new InvalidObjectException(userNotAuthorized);
        }
    }
}

