/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Queue;
import hudson.util.FormApply;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.Messages;
import org.jenkinsci.plugins.authorizeproject.ProjectQueueItemAuthenticator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

public class AuthorizeProjectProperty
extends JobProperty<Job<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(AuthorizeProjectProperty.class.getName());
    private AuthorizeProjectStrategy strategy;

    public AuthorizeProjectStrategy getStrategy() {
        return this.strategy;
    }

    @DataBoundConstructor
    public AuthorizeProjectProperty(AuthorizeProjectStrategy strategy) {
        this.strategy = strategy;
    }

    @CheckForNull
    public AuthorizeProjectStrategy getEnabledStrategy() {
        AuthorizeProjectStrategy strategy = this.getStrategy();
        if (strategy == null) {
            return null;
        }
        if (DescriptorVisibilityFilter.apply((Object)((Object)ProjectQueueItemAuthenticator.getConfigured()), List.of(strategy.getDescriptor())).isEmpty()) {
            LOGGER.log(Level.WARNING, "{0} is configured but disabled in the global-security configuration.", strategy.getDescriptor().getDisplayName());
            return null;
        }
        return strategy;
    }

    public Authentication authenticate(Queue.Item item) {
        AuthorizeProjectStrategy strategy = this.getEnabledStrategy();
        if (strategy == null) {
            return null;
        }
        return strategy.authenticate(this.owner, item);
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void setStrategyCritical() {
        Items.XSTREAM2.addCriticalField(AuthorizeProjectProperty.class, "strategy");
    }

    public JobProperty<?> reconfigure(StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        return this.strategy != null && ProjectQueueItemAuthenticator.isConfigured() ? this : null;
    }

    @Extension(ordinal=8.988465674311579E307)
    public static class TransientActionFactoryImpl
    extends TransientActionFactory<Job> {
        public Class<Job> type() {
            return Job.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull Job target) {
            return List.of(new AuthorizationAction(target));
        }
    }

    public static class AuthorizationAction
    implements Action,
    IconSpec {
        @NonNull
        private final Job<?, ?> job;

        public AuthorizationAction(@NonNull Job<?, ?> job) {
            this.job = job;
        }

        @Restricted(value={NoExternalUse.class})
        public AuthorizeProjectProperty getProperty() {
            return (AuthorizeProjectProperty)this.job.getProperty(AuthorizeProjectProperty.class);
        }

        public DescriptorImpl getPropertyDescriptor() {
            return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        }

        @NonNull
        public Job<?, ?> getJob() {
            return this.job;
        }

        public String getIconFileName() {
            return ProjectQueueItemAuthenticator.isConfigured() ? "symbol-lock-closed" : null;
        }

        public String getDisplayName() {
            return Messages.AuthorizationAction_DisplayName();
        }

        public String getUrlName() {
            return "authorization";
        }

        public String getIconClassName() {
            return ProjectQueueItemAuthenticator.isConfigured() ? "symbol-lock-closed" : null;
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        @NonNull
        public synchronized HttpResponse doAuthorize(@NonNull StaplerRequest2 req) throws IOException, ServletException {
            this.job.checkPermission(Job.CONFIGURE);
            JSONObject json = req.getSubmittedForm();
            JSONObject o = json.optJSONObject(this.getPropertyDescriptor().getJsonSafeClassName());
            AuthorizeProjectProperty submitted = o != null ? (AuthorizeProjectProperty)((Object)req.bindJSON(AuthorizeProjectProperty.class, o)) : null;
            BulkChange bc = new BulkChange(this.job);
            try {
                AuthorizeProjectProperty existing = this.getProperty();
                if (existing != null) {
                    this.job.removeProperty((JobProperty)existing);
                }
                if (submitted != null) {
                    this.job.addProperty((JobProperty)submitted);
                }
                this.job.save();
                bc.commit();
                return FormApply.success((String)"../");
            }
            catch (IOException e) {
                bc.abort();
                throw e;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.AuthorizeProjectProperty_DisplayName();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return ProjectQueueItemAuthenticator.isConfigured();
        }

        @Deprecated
        public DescriptorExtensionList<AuthorizeProjectStrategy, Descriptor<AuthorizeProjectStrategy>> getStrategyList() {
            return AuthorizeProjectStrategy.all();
        }

        public List<Descriptor<AuthorizeProjectStrategy>> getEnabledAuthorizeProjectStrategyDescriptorList() {
            ProjectQueueItemAuthenticator authenticator = ProjectQueueItemAuthenticator.getConfigured();
            if (authenticator == null) {
                return List.of();
            }
            return DescriptorVisibilityFilter.apply((Object)((Object)authenticator), AuthorizeProjectStrategy.all());
        }
    }
}

