// CHECKSTYLE:OFF

package org.jenkinsci.plugins.authorizeproject.strategy;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SystemAuthorizationStrategy.administersOnly}: {@code Only
     * Administrators can configure the Run as SYSTEM strategy}.
     * 
     * @return
     *     {@code Only Administrators can configure the Run as SYSTEM strategy}
     */
    public static String SystemAuthorizationStrategy_administersOnly() {
        return holder.format("SystemAuthorizationStrategy.administersOnly");
    }

    /**
     * Key {@code SystemAuthorizationStrategy.administersOnly}: {@code Only
     * Administrators can configure the Run as SYSTEM strategy}.
     * 
     * @return
     *     {@code Only Administrators can configure the Run as SYSTEM strategy}
     */
    public static Localizable _SystemAuthorizationStrategy_administersOnly() {
        return new Localizable(holder, "SystemAuthorizationStrategy.administersOnly");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.password.required}:
     * {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static String SpecificUsersAuthorizationStrategy_password_required() {
        return holder.format("SpecificUsersAuthorizationStrategy.password.required");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.password.required}:
     * {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static Localizable _SpecificUsersAuthorizationStrategy_password_required() {
        return new Localizable(holder, "SpecificUsersAuthorizationStrategy.password.required");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.userid.builtin}: {@code
     * You cannot specify a built-in user with this strategy}.
     * 
     * @return
     *     {@code You cannot specify a built-in user with this strategy}
     */
    public static String SpecificUsersAuthorizationStrategy_userid_builtin() {
        return holder.format("SpecificUsersAuthorizationStrategy.userid.builtin");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.userid.builtin}: {@code
     * You cannot specify a built-in user with this strategy}.
     * 
     * @return
     *     {@code You cannot specify a built-in user with this strategy}
     */
    public static Localizable _SpecificUsersAuthorizationStrategy_userid_builtin() {
        return new Localizable(holder, "SpecificUsersAuthorizationStrategy.userid.builtin");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.DisplayName}: {@code Run
     * as Specific User}.
     * 
     * @return
     *     {@code Run as Specific User}
     */
    public static String SpecificUsersAuthorizationStrategy_DisplayName() {
        return holder.format("SpecificUsersAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.DisplayName}: {@code Run
     * as Specific User}.
     * 
     * @return
     *     {@code Run as Specific User}
     */
    public static Localizable _SpecificUsersAuthorizationStrategy_DisplayName() {
        return new Localizable(holder, "SpecificUsersAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.userid.authenticate}:
     * {@code Failed to authenticate the user specified to run builds with
     * its authorization. Please check User ID and Password is valid.}.
     * 
     * @return
     *     {@code Failed to authenticate the user specified to run builds with
     *     its authorization. Please check User ID and Password is valid.}
     */
    public static String SpecificUsersAuthorizationStrategy_userid_authenticate() {
        return holder.format("SpecificUsersAuthorizationStrategy.userid.authenticate");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.userid.authenticate}:
     * {@code Failed to authenticate the user specified to run builds with
     * its authorization. Please check User ID and Password is valid.}.
     * 
     * @return
     *     {@code Failed to authenticate the user specified to run builds with
     *     its authorization. Please check User ID and Password is valid.}
     */
    public static Localizable _SpecificUsersAuthorizationStrategy_userid_authenticate() {
        return new Localizable(holder, "SpecificUsersAuthorizationStrategy.userid.authenticate");
    }

    /**
     * Key {@code SystemAuthorizationStrategy.DisplayName}: {@code Run as
     * SYSTEM}.
     * 
     * @return
     *     {@code Run as SYSTEM}
     */
    public static String SystemAuthorizationStrategy_DisplayName() {
        return holder.format("SystemAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code SystemAuthorizationStrategy.DisplayName}: {@code Run as
     * SYSTEM}.
     * 
     * @return
     *     {@code Run as SYSTEM}
     */
    public static Localizable _SystemAuthorizationStrategy_DisplayName() {
        return new Localizable(holder, "SystemAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code SystemAuthorizationStrategy.userConfigurable}: {@code
     * Non-administrators will be able to re-purpose jobs configured with
     * this strategy}.
     * 
     * @return
     *     {@code Non-administrators will be able to re-purpose jobs configured
     *     with this strategy}
     */
    public static String SystemAuthorizationStrategy_userConfigurable() {
        return holder.format("SystemAuthorizationStrategy.userConfigurable");
    }

    /**
     * Key {@code SystemAuthorizationStrategy.userConfigurable}: {@code
     * Non-administrators will be able to re-purpose jobs configured with
     * this strategy}.
     * 
     * @return
     *     {@code Non-administrators will be able to re-purpose jobs configured
     *     with this strategy}
     */
    public static Localizable _SystemAuthorizationStrategy_userConfigurable() {
        return new Localizable(holder, "SystemAuthorizationStrategy.userConfigurable");
    }

    /**
     * Key {@code
     * SpecificUsersAuthorizationStrategy.dontRestrictJobConfiguration.usage}:
     * {@code This feature can cause a security problem. Please check the
     * CONFIGURE permission of this job is granted only to appropriate
     * users.}.
     * 
     * @return
     *     {@code This feature can cause a security problem. Please check the
     *     CONFIGURE permission of this job is granted only to appropriate
     *     users.}
     */
    public static String SpecificUsersAuthorizationStrategy_dontRestrictJobConfiguration_usage() {
        return holder.format("SpecificUsersAuthorizationStrategy.dontRestrictJobConfiguration.usage");
    }

    /**
     * Key {@code
     * SpecificUsersAuthorizationStrategy.dontRestrictJobConfiguration.usage}:
     * {@code This feature can cause a security problem. Please check the
     * CONFIGURE permission of this job is granted only to appropriate
     * users.}.
     * 
     * @return
     *     {@code This feature can cause a security problem. Please check the
     *     CONFIGURE permission of this job is granted only to appropriate
     *     users.}
     */
    public static Localizable _SpecificUsersAuthorizationStrategy_dontRestrictJobConfiguration_usage() {
        return new Localizable(holder, "SpecificUsersAuthorizationStrategy.dontRestrictJobConfiguration.usage");
    }

    /**
     * Key {@code TriggeringUsersAuthorizationStrategy.DisplayName}: {@code
     * Run as User who Triggered Build}.
     * 
     * @return
     *     {@code Run as User who Triggered Build}
     */
    public static String TriggeringUsersAuthorizationStrategy_DisplayName() {
        return holder.format("TriggeringUsersAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code TriggeringUsersAuthorizationStrategy.DisplayName}: {@code
     * Run as User who Triggered Build}.
     * 
     * @return
     *     {@code Run as User who Triggered Build}
     */
    public static Localizable _TriggeringUsersAuthorizationStrategy_DisplayName() {
        return new Localizable(holder, "TriggeringUsersAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code AnonymousAuthorizationStrategy.DisplayName}: {@code Run as
     * anonymous}.
     * 
     * @return
     *     {@code Run as anonymous}
     */
    public static String AnonymousAuthorizationStrategy_DisplayName() {
        return holder.format("AnonymousAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code AnonymousAuthorizationStrategy.DisplayName}: {@code Run as
     * anonymous}.
     * 
     * @return
     *     {@code Run as anonymous}
     */
    public static Localizable _AnonymousAuthorizationStrategy_DisplayName() {
        return new Localizable(holder, "AnonymousAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.userid.required}: {@code
     * Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static String SpecificUsersAuthorizationStrategy_userid_required() {
        return holder.format("SpecificUsersAuthorizationStrategy.userid.required");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.userid.required}: {@code
     * Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static Localizable _SpecificUsersAuthorizationStrategy_userid_required() {
        return new Localizable(holder, "SpecificUsersAuthorizationStrategy.userid.required");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.password.invalid}:
     * {@code Failed to authenticate}.
     * 
     * @return
     *     {@code Failed to authenticate}
     */
    public static String SpecificUsersAuthorizationStrategy_password_invalid() {
        return holder.format("SpecificUsersAuthorizationStrategy.password.invalid");
    }

    /**
     * Key {@code SpecificUsersAuthorizationStrategy.password.invalid}:
     * {@code Failed to authenticate}.
     * 
     * @return
     *     {@code Failed to authenticate}
     */
    public static Localizable _SpecificUsersAuthorizationStrategy_password_invalid() {
        return new Localizable(holder, "SpecificUsersAuthorizationStrategy.password.invalid");
    }

}
