// CHECKSTYLE:OFF

package org.jenkinsci.plugins.authorizeproject;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ProjectQueueItemAuthenticator.DisplayName}: {@code
     * Per-project configurable Build Authorization}.
     * 
     * @return
     *     {@code Per-project configurable Build Authorization}
     */
    public static String ProjectQueueItemAuthenticator_DisplayName() {
        return holder.format("ProjectQueueItemAuthenticator.DisplayName");
    }

    /**
     * Key {@code ProjectQueueItemAuthenticator.DisplayName}: {@code
     * Per-project configurable Build Authorization}.
     * 
     * @return
     *     {@code Per-project configurable Build Authorization}
     */
    public static Localizable _ProjectQueueItemAuthenticator_DisplayName() {
        return new Localizable(holder, "ProjectQueueItemAuthenticator.DisplayName");
    }

    /**
     * Key {@code AuthorizationAction.DisplayName}: {@code Authorization}.
     * 
     * @return
     *     {@code Authorization}
     */
    public static String AuthorizationAction_DisplayName() {
        return holder.format("AuthorizationAction.DisplayName");
    }

    /**
     * Key {@code AuthorizationAction.DisplayName}: {@code Authorization}.
     * 
     * @return
     *     {@code Authorization}
     */
    public static Localizable _AuthorizationAction_DisplayName() {
        return new Localizable(holder, "AuthorizationAction.DisplayName");
    }

    /**
     * Key {@code AuthorizeProjectStrategy.UserNotAuthorized}: {@code Failed
     * to authenticate to run builds as authorization {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to authenticate to run builds as authorization {0}.}
     */
    public static String AuthorizeProjectStrategy_UserNotAuthorized(Object arg0) {
        return holder.format("AuthorizeProjectStrategy.UserNotAuthorized", arg0);
    }

    /**
     * Key {@code AuthorizeProjectStrategy.UserNotAuthorized}: {@code Failed
     * to authenticate to run builds as authorization {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to authenticate to run builds as authorization {0}.}
     */
    public static Localizable _AuthorizeProjectStrategy_UserNotAuthorized(Object arg0) {
        return new Localizable(holder, "AuthorizeProjectStrategy.UserNotAuthorized", arg0);
    }

    /**
     * Key {@code AuthorizeProjectStrategy.UserNotAuthorizedForJob}: {@code
     * This job''s current authorization strategy does not permit {0} to
     * modify the job configuration}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code This job''s current authorization strategy does not permit {0}
     *     to modify the job configuration}
     */
    public static String AuthorizeProjectStrategy_UserNotAuthorizedForJob(Object arg0) {
        return holder.format("AuthorizeProjectStrategy.UserNotAuthorizedForJob", arg0);
    }

    /**
     * Key {@code AuthorizeProjectStrategy.UserNotAuthorizedForJob}: {@code
     * This job''s current authorization strategy does not permit {0} to
     * modify the job configuration}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code This job''s current authorization strategy does not permit {0}
     *     to modify the job configuration}
     */
    public static Localizable _AuthorizeProjectStrategy_UserNotAuthorizedForJob(Object arg0) {
        return new Localizable(holder, "AuthorizeProjectStrategy.UserNotAuthorizedForJob", arg0);
    }

    /**
     * Key {@code AuthorizeProjectProperty.DisplayName}: {@code Configure
     * Build Authorization}.
     * 
     * @return
     *     {@code Configure Build Authorization}
     */
    public static String AuthorizeProjectProperty_DisplayName() {
        return holder.format("AuthorizeProjectProperty.DisplayName");
    }

    /**
     * Key {@code AuthorizeProjectProperty.DisplayName}: {@code Configure
     * Build Authorization}.
     * 
     * @return
     *     {@code Configure Build Authorization}
     */
    public static Localizable _AuthorizeProjectProperty_DisplayName() {
        return new Localizable(holder, "AuthorizeProjectProperty.DisplayName");
    }

    /**
     * Key {@code GlobalQueueItemAuthenticator.DisplayName}: {@code Project
     * default Build Authorization}.
     * 
     * @return
     *     {@code Project default Build Authorization}
     */
    public static String GlobalQueueItemAuthenticator_DisplayName() {
        return holder.format("GlobalQueueItemAuthenticator.DisplayName");
    }

    /**
     * Key {@code GlobalQueueItemAuthenticator.DisplayName}: {@code Project
     * default Build Authorization}.
     * 
     * @return
     *     {@code Project default Build Authorization}
     */
    public static Localizable _GlobalQueueItemAuthenticator_DisplayName() {
        return new Localizable(holder, "GlobalQueueItemAuthenticator.DisplayName");
    }

}
