/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject.strategy;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectProperty;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.strategy.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class SystemAuthorizationStrategy
extends AuthorizeProjectStrategy {
    @DataBoundConstructor
    public SystemAuthorizationStrategy() {
        this.checkAuthorizationConfigurePermission((AccessControlled)Jenkins.get());
    }

    @Override
    public Authentication authenticate(Job<?, ?> job, Queue.Item item) {
        return ACL.SYSTEM2;
    }

    protected static SystemAuthorizationStrategy getCurrentStrategy(Job<?, ?> job) {
        if (job == null) {
            return null;
        }
        AuthorizeProjectProperty prop = (AuthorizeProjectProperty)job.getProperty(AuthorizeProjectProperty.class);
        if (prop == null) {
            return null;
        }
        AuthorizeProjectStrategy strategy = prop.getStrategy();
        if (!(strategy instanceof SystemAuthorizationStrategy)) {
            return null;
        }
        return (SystemAuthorizationStrategy)strategy;
    }

    @Override
    public boolean hasJobConfigurePermission(AccessControlled context) {
        return context.hasPermission(Jenkins.ADMINISTER) || this.getDescriptor().isPermitReconfiguration();
    }

    @Override
    public boolean hasAuthorizationConfigurePermission(AccessControlled context) {
        return context.hasPermission(Jenkins.RUN_SCRIPTS);
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension(ordinal=-100.0)
    public static class DescriptorImpl
    extends AuthorizeProjectStrategyDescriptor {
        private boolean permitReconfiguration;

        public String getDisplayName() {
            return Messages.SystemAuthorizationStrategy_DisplayName();
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        public boolean isPermitReconfiguration() {
            return this.permitReconfiguration;
        }

        public void setPermitReconfiguration(boolean permitReconfiguration) {
            if (permitReconfiguration != this.permitReconfiguration) {
                this.permitReconfiguration = permitReconfiguration;
                this.save();
            }
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isJob(Object it) {
            return it instanceof Job;
        }

        @Override
        public void configureFromGlobalSecurity(StaplerRequest2 req, JSONObject js) throws Descriptor.FormException {
            this.setPermitReconfiguration(js.getBoolean("permitReconfiguration"));
        }

        public SystemAuthorizationStrategy newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            Job job;
            SystemAuthorizationStrategy result = (SystemAuthorizationStrategy)super.newInstance(req, formData);
            Jenkins instance = Jenkins.get();
            if (!(instance.hasPermission(Jenkins.RUN_SCRIPTS) || (job = (Job)req.findAncestorObject(Job.class)) == null || this.permitReconfiguration && SystemAuthorizationStrategy.getCurrentStrategy(job) != null)) {
                throw new Descriptor.FormException(Messages.SystemAuthorizationStrategy_administersOnly(), "strategy");
            }
            return result;
        }

        public FormValidation doCheckPermitReconfiguration(@QueryParameter boolean value) {
            if (!value) {
                return FormValidation.warning((String)Messages.SystemAuthorizationStrategy_administersOnly());
            }
            return FormValidation.warning((String)Messages.SystemAuthorizationStrategy_userConfigurable());
        }
    }
}

