/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.artifactdeployer.service;

import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerVO;
import org.jenkinsci.plugins.artifactdeployer.service.LocalCopy;
import org.jenkinsci.remoting.RoleChecker;

public class ArtifactDeployerCopy
implements FilePath.FileCallable<List<ArtifactDeployerVO>> {
    private BuildListener listener;
    private String includes;
    private String excludes;
    private boolean flatten;
    private FilePath outputFilePath;
    private int numberOfCurrentDeployedArtifacts;

    public ArtifactDeployerCopy(BuildListener listener, String includes, String excludes, boolean flatten, FilePath outputFilePath, int numberOfCurrentDeployedArtifacts) {
        this.listener = listener;
        this.includes = includes;
        this.excludes = excludes;
        this.flatten = flatten;
        this.outputFilePath = outputFilePath;
        this.numberOfCurrentDeployedArtifacts = numberOfCurrentDeployedArtifacts;
    }

    public List<ArtifactDeployerVO> invoke(File localBasedir, VirtualChannel channel) throws IOException, InterruptedException {
        LocalCopy localCopy;
        List<File> outputFilesList;
        String remote = this.outputFilePath.getRemote();
        FileSet fileSet = Util.createFileSet((File)localBasedir, (String)this.includes, (String)this.excludes);
        int inputFiles = fileSet.size();
        if (inputFiles != (outputFilesList = (localCopy = new LocalCopy()).copyAndGetNumbers(fileSet, this.flatten, new File(remote))).size()) {
            this.listener.getLogger().println(String.format("[ArtifactDeployer] - All the files have not been deployed. There were %d input files but only %d were copied. Maybe you need to use the 'Delete content of remote directory' feature for deleting the remote directory before deploying.", inputFiles, outputFilesList.size()));
        } else {
            this.listener.getLogger().println(String.format("[ArtifactDeployer] - %d file(s) have been copied from the '%s' to '%s'.", outputFilesList.size(), localBasedir.getPath(), this.outputFilePath));
        }
        LinkedList<ArtifactDeployerVO> deployedArtifactsResultList = new LinkedList<ArtifactDeployerVO>();
        for (File renoteFile : outputFilesList) {
            ArtifactDeployerVO deploymentResultEntry = new ArtifactDeployerVO();
            deploymentResultEntry.setId(++this.numberOfCurrentDeployedArtifacts);
            deploymentResultEntry.setDeployed(true);
            deploymentResultEntry.setFileName(renoteFile.getName());
            deploymentResultEntry.setRemotePath(renoteFile.getPath());
            deployedArtifactsResultList.add(deploymentResultEntry);
        }
        return deployedArtifactsResultList;
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }
}

