/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.artifactdeployer;

import hudson.model.AbstractBuild;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerBuildAction;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerVO;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class DeployedArtifactsResult {
    private ArtifactDeployerBuildAction artifactDeployerBuildAction;

    public DeployedArtifactsResult(ArtifactDeployerBuildAction artifactDeployerBuildAction) {
        this.artifactDeployerBuildAction = artifactDeployerBuildAction;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.artifactDeployerBuildAction.getOwner();
    }

    public Collection<ArtifactDeployerVO> getAllArtifacts() {
        Map<Integer, List<ArtifactDeployerVO>> deployedArtifactsInfo = this.artifactDeployerBuildAction.getDeployedArtifactsInfo();
        Comparator<ArtifactDeployerVO> comparator = new Comparator<ArtifactDeployerVO>(){

            @Override
            public int compare(ArtifactDeployerVO artifactDeployer1, ArtifactDeployerVO artifactDeployer2) {
                if (artifactDeployer1 == null || artifactDeployer2 == null) {
                    return 0;
                }
                String remotePath1 = artifactDeployer1.getRemotePath();
                String remotePath2 = artifactDeployer2.getRemotePath();
                if (remotePath1 == null || remotePath2 == null) {
                    return 0;
                }
                return remotePath1.compareTo(remotePath2);
            }
        };
        TreeSet<ArtifactDeployerVO> result = new TreeSet<ArtifactDeployerVO>(comparator);
        if (deployedArtifactsInfo != null) {
            for (List<ArtifactDeployerVO> list : deployedArtifactsInfo.values()) {
                result.addAll(list);
            }
        }
        return result;
    }

    public void doDownload(StaplerRequest2 request, StaplerResponse2 response) throws IOException, ServletException {
        int id;
        ArtifactDeployerVO selectedArtifact;
        String restOfPath = request.getRestOfPath();
        if (restOfPath == null) {
            return;
        }
        String artifactPattenLink = "/artifact.";
        if (restOfPath.startsWith("/artifact.") && (selectedArtifact = this.getArtifactDeployerVO(id = Integer.parseInt(restOfPath.split("/artifact.")[1]))) != null) {
            response.setHeader("Content-Disposition", "attachment;filename=\"" + selectedArtifact.getFileName() + "\"");
            response.serveFile(request, new File(selectedArtifact.getRemotePath()).toURI().toURL());
        }
    }

    private ArtifactDeployerVO getArtifactDeployerVO(int id) {
        Map<Integer, List<ArtifactDeployerVO>> deployedArtifactsInfo = this.artifactDeployerBuildAction.getDeployedArtifactsInfo();
        for (List<ArtifactDeployerVO> entryList : deployedArtifactsInfo.values()) {
            for (ArtifactDeployerVO entry : entryList) {
                if (entry.getId() != id) continue;
                return entry;
            }
        }
        return null;
    }
}

