/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.artifactdeployer;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerBuildAction;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerEntry;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerException;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerProjectAction;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerVO;
import org.jenkinsci.plugins.artifactdeployer.Messages;
import org.jenkinsci.plugins.artifactdeployer.service.ArtifactDeployerCopy;
import org.jenkinsci.plugins.artifactdeployer.service.ArtifactDeployerManager;
import org.jenkinsci.plugins.artifactdeployer.service.DeployedArtifactsActionManager;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ArtifactDeployerPublisher
extends Recorder
implements MatrixAggregatable,
Serializable {
    private List<ArtifactDeployerEntry> entries = Collections.emptyList();
    private boolean deployEvenBuildFail;

    @DataBoundConstructor
    public ArtifactDeployerPublisher(List<ArtifactDeployerEntry> deployedArtifact, boolean deployEvenBuildFail) {
        this.entries = deployedArtifact;
        this.deployEvenBuildFail = deployEvenBuildFail;
        if (this.entries == null) {
            this.entries = Collections.emptyList();
        }
    }

    public Object readResolve() {
        if (this.entries == null) {
            this.entries = Collections.emptyList();
        }
        return this;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Arrays.asList(new ArtifactDeployerProjectAction(project));
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endRun(MatrixRun run) throws InterruptedException, IOException {
                boolean result = ArtifactDeployerPublisher.this._perform((AbstractBuild<?, ?>)run, this.launcher, this.listener);
                run.save();
                return result;
            }
        };
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!(build.getProject() instanceof MatrixConfiguration)) {
            return this._perform(build, launcher, listener);
        }
        return true;
    }

    private boolean isPerformDeployment(AbstractBuild build) {
        Result result = build.getResult();
        if (this.deployEvenBuildFail) {
            return true;
        }
        if (result == null) {
            return true;
        }
        return result.isBetterOrEqualTo(Result.UNSTABLE);
    }

    private boolean _perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.isPerformDeployment(build)) {
            Map<Integer, List<ArtifactDeployerVO>> deployedArtifacts;
            listener.getLogger().println("[ArtifactDeployer] - Starting deployment from the post-action ...");
            DeployedArtifactsActionManager deployedArtifactsService = DeployedArtifactsActionManager.getInstance();
            ArtifactDeployerBuildAction artifactDeployerBuildActionAction = deployedArtifactsService.getOrCreateAction(build);
            try {
                int currentTotalDeployedCounter = artifactDeployerBuildActionAction.getDeployedArtifactsInfo().size();
                deployedArtifacts = this.processDeployment(build, listener, currentTotalDeployedCounter);
            }
            catch (ArtifactDeployerException ae) {
                listener.getLogger().println("[ArtifactDeployer] - [ERROR] - Failed to deploy. " + ae.getMessage());
                if (ae.getCause() != null) {
                    listener.getLogger().println("[ArtifactDeployer] - [ERROR] - " + ae.getCause().getMessage());
                }
                build.setResult(Result.FAILURE);
                return false;
            }
            artifactDeployerBuildActionAction.setArtifactsInfo(build, deployedArtifacts);
            listener.getLogger().println("[ArtifactDeployer] - Stopping deployment from the post-action...");
        }
        return true;
    }

    private Map<Integer, List<ArtifactDeployerVO>> processDeployment(AbstractBuild<?, ?> build, BuildListener listener, int currentNbDeployedArtifacts) throws ArtifactDeployerException {
        HashMap<Integer, List<ArtifactDeployerVO>> deployedArtifacts = new HashMap<Integer, List<ArtifactDeployerVO>>();
        FilePath workspace = build.getWorkspace();
        int numberOfCurrentDeployedArtifacts = currentNbDeployedArtifacts;
        for (ArtifactDeployerEntry entry : this.entries) {
            List results;
            String outputPath;
            String basedir;
            String excludes;
            String includes;
            if (entry.getRemote() == null) {
                throw new ArtifactDeployerException("All remote directories must be set.");
            }
            try {
                includes = build.getEnvironment((TaskListener)listener).expand(entry.getIncludes());
                excludes = build.getEnvironment((TaskListener)listener).expand(entry.getExcludes());
                basedir = build.getEnvironment((TaskListener)listener).expand(entry.getBasedir());
                outputPath = build.getEnvironment((TaskListener)listener).expand(entry.getRemote());
            }
            catch (IOException ioe) {
                throw new ArtifactDeployerException(ioe);
            }
            catch (InterruptedException ie) {
                throw new ArtifactDeployerException(ie);
            }
            boolean flatten = entry.isFlatten();
            FilePath outputFilePath = new FilePath(workspace.getChannel(), outputPath);
            try {
                outputFilePath.mkdirs();
            }
            catch (IOException ioe) {
                throw new ArtifactDeployerException(String.format("Can't create the directory '%s'", outputPath), ioe);
            }
            catch (InterruptedException ie) {
                throw new ArtifactDeployerException(String.format("Can't create the directory '%s'", outputPath), ie);
            }
            boolean deletedPreviously = entry.isDeleteRemote();
            if (deletedPreviously) {
                try {
                    outputFilePath.deleteContents();
                }
                catch (IOException ioe) {
                    throw new ArtifactDeployerException(String.format("Can't delete contents of '%s'", outputPath), ioe);
                }
                catch (InterruptedException ie) {
                    throw new ArtifactDeployerException(String.format("Can't delete contents of '%s'", outputPath), ie);
                }
            }
            ArtifactDeployerCopy deployerCopy = new ArtifactDeployerCopy(listener, includes, excludes, flatten, outputFilePath, numberOfCurrentDeployedArtifacts);
            ArtifactDeployerManager deployerManager = new ArtifactDeployerManager();
            FilePath basedirFilPath = deployerManager.getBasedirFilePath(workspace, basedir);
            try {
                results = (List)basedirFilPath.act((FilePath.FileCallable)deployerCopy);
            }
            catch (IOException ioe) {
                throw new ArtifactDeployerException(ioe);
            }
            catch (InterruptedException ie) {
                throw new ArtifactDeployerException(ie);
            }
            if (this.isFailNoFilesDeploy(results, entry)) {
                throw new ArtifactDeployerException("Can't find any artifacts to deploy with the following configuration :" + this.printConfiguration(includes, excludes, basedirFilPath.getRemote(), outputPath));
            }
            numberOfCurrentDeployedArtifacts += results.size();
            deployedArtifacts.put(entry.getUniqueId(), results);
        }
        return deployedArtifacts;
    }

    private boolean isFailNoFilesDeploy(List<ArtifactDeployerVO> results, ArtifactDeployerEntry entry) {
        return (results == null || results.size() == 0) && entry.isFailNoFilesDeploy();
    }

    private String printConfiguration(String includes, String excludes, String basedir, String outputPath) {
        StringBuffer sb = new StringBuffer();
        if (includes != null) {
            sb.append(",includes:").append(includes);
        }
        if (excludes != null) {
            sb.append(",excludes:").append(excludes);
        }
        sb.append(",basedir:").append(basedir);
        sb.append(",outPath:").append(outputPath);
        sb.append("]");
        sb = sb.replace(0, 1, "[");
        return sb.toString();
    }

    public List<ArtifactDeployerEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ArtifactDeployerEntry> entries) {
        this.entries = entries;
    }

    public boolean isDeployEvenBuildFail() {
        return this.deployEvenBuildFail;
    }

    public void setDeployEvenBuildFail(boolean deployEvenBuildFail) {
        this.deployEvenBuildFail = deployEvenBuildFail;
    }

    @Extension
    public static final class ArtifactDeployerDescriptor
    extends BuildStepDescriptor<Publisher> {
        public static final String DISPLAY_NAME = Messages.depployerartifact_displayName();

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public FormValidation doCheckIncludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public FormValidation doCheckExcludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (value == null || value.trim().length() == 0) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public FormValidation doCheckRemote(@QueryParameter String value) throws IOException {
            if (value == null || value.trim().length() == 0) {
                return FormValidation.error((String)"Remote directory is mandatory.");
            }
            return FormValidation.ok();
        }
    }

    @Extension
    public static final class DeleteRemoteArtifact
    extends RunListener<AbstractBuild> {
        private final Logger logger = Logger.getLogger(DeleteRemoteArtifact.class.getName());

        public void onDeleted(AbstractBuild build) {
            Map<Integer, List<ArtifactDeployerVO>> info;
            ArtifactDeployerBuildAction artifactDeployerBuildAction;
            DescribableList projectPublishers = build.getProject().getPublishersList();
            Iterator it = projectPublishers.iterator();
            ArtifactDeployerPublisher artifactDeployerPublisher = null;
            while (it.hasNext()) {
                Publisher publisher = (Publisher)it.next();
                Descriptor publisherDescriptor = publisher.getDescriptor();
                if (publisherDescriptor == null || !ArtifactDeployerDescriptor.DISPLAY_NAME.equals(publisherDescriptor.getDisplayName())) continue;
                artifactDeployerPublisher = (ArtifactDeployerPublisher)publisher;
            }
            if (artifactDeployerPublisher != null && (artifactDeployerBuildAction = (ArtifactDeployerBuildAction)build.getAction(ArtifactDeployerBuildAction.class)) != null && (info = artifactDeployerBuildAction.getDeployedArtifactsInfo()) != null) {
                for (ArtifactDeployerEntry entry : artifactDeployerPublisher.getEntries()) {
                    List<ArtifactDeployerVO> listArtifacts;
                    if (!entry.isDeleteRemoteArtifacts() || (listArtifacts = info.get(entry.getUniqueId())) == null) continue;
                    for (ArtifactDeployerVO vo : listArtifacts) {
                        FilePath workspace = build.getWorkspace();
                        if (workspace == null) continue;
                        FilePath remoteArtifactPath = new FilePath(workspace.getChannel(), vo.getRemotePath());
                        try {
                            boolean rest;
                            if (remoteArtifactPath != null && remoteArtifactPath.exists()) {
                                remoteArtifactPath.deleteRecursive();
                            }
                            FilePath parent = remoteArtifactPath.getParent();
                            do {
                                boolean bl = rest = parent.exists() && parent.list().size() == 0;
                                if (rest) {
                                    parent.delete();
                                }
                                parent = parent.getParent();
                            } while (rest);
                        }
                        catch (IOException ioe) {
                            this.logger.log(Level.SEVERE, "Error when deleting artifacts.", ioe);
                        }
                        catch (InterruptedException ie) {
                            this.logger.log(Level.SEVERE, "Error when deleting artifacts.", ie);
                        }
                    }
                }
            }
        }
    }
}

