/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.artifactdeployer;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerBuildAction;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerEntry;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerException;
import org.jenkinsci.plugins.artifactdeployer.ArtifactDeployerVO;
import org.jenkinsci.plugins.artifactdeployer.Messages;
import org.jenkinsci.plugins.artifactdeployer.service.ArtifactDeployerCopy;
import org.jenkinsci.plugins.artifactdeployer.service.ArtifactDeployerManager;
import org.jenkinsci.plugins.artifactdeployer.service.DeployedArtifactsActionManager;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ArtifactDeployerBuilder
extends Builder
implements Serializable {
    ArtifactDeployerEntry entry;

    @DataBoundConstructor
    public ArtifactDeployerBuilder(String includes, String basedir, String excludes, String remote, boolean flatten, boolean deleteRemote, boolean deleteRemoteArtifacts, boolean failNoFilesDeploy) {
        this.entry = new ArtifactDeployerEntry(includes, basedir, excludes, remote, flatten, deleteRemote, deleteRemoteArtifacts, failNoFilesDeploy);
    }

    public ArtifactDeployerBuilder() {
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Map<Integer, List<ArtifactDeployerVO>> deployedArtifacts;
        listener.getLogger().println("[ArtifactDeployer] - Starting deployment from the build step ...");
        DeployedArtifactsActionManager deployedArtifactsService = DeployedArtifactsActionManager.getInstance();
        ArtifactDeployerBuildAction artifactDeployerBuildActionAction = deployedArtifactsService.getOrCreateAction(build);
        FilePath workspace = build.getWorkspace();
        try {
            deployedArtifacts = this.processDeployment(build, listener, workspace);
        }
        catch (ArtifactDeployerException ae) {
            listener.getLogger().println("[ArtifactDeployer] - [ERROR] -  Failed to deploy. " + ae.getMessage());
            if (ae.getCause() != null) {
                listener.getLogger().println("[ArtifactDeployer] - [ERROR] - " + ae.getCause().getMessage());
            }
            build.setResult(Result.FAILURE);
            return false;
        }
        artifactDeployerBuildActionAction.setArtifactsInfo(build, deployedArtifacts);
        listener.getLogger().println("[ArtifactDeployer] - Stopping deployment from the build step ...");
        return true;
    }

    private Map<Integer, List<ArtifactDeployerVO>> processDeployment(AbstractBuild<?, ?> build, BuildListener listener, FilePath workspace) throws IOException, InterruptedException {
        if (this.entry.getRemote() == null) {
            throw new ArtifactDeployerException("A remote directory must be set.");
        }
        HashMap<Integer, List<ArtifactDeployerVO>> deployedArtifacts = new HashMap<Integer, List<ArtifactDeployerVO>>();
        String includes = build.getEnvironment((TaskListener)listener).expand(this.entry.getIncludes());
        String excludes = build.getEnvironment((TaskListener)listener).expand(this.entry.getExcludes());
        String basedir = build.getEnvironment((TaskListener)listener).expand(this.entry.getBasedir());
        String outputPath = build.getEnvironment((TaskListener)listener).expand(this.entry.getRemote());
        boolean flatten = this.entry.isFlatten();
        FilePath outputFilePath = new FilePath(workspace.getChannel(), outputPath);
        try {
            outputFilePath.mkdirs();
        }
        catch (IOException ioe) {
            throw new ArtifactDeployerException(String.format("Can't create the directory '%s'", outputPath), ioe);
        }
        boolean deletedPreviously = this.entry.isDeleteRemote();
        if (deletedPreviously) {
            try {
                outputFilePath.deleteContents();
            }
            catch (IOException ioe) {
                throw new ArtifactDeployerException(String.format("Can't delete contents of '%s'", outputPath), ioe);
            }
        }
        DeployedArtifactsActionManager deployedArtifactsService = DeployedArtifactsActionManager.getInstance();
        ArtifactDeployerBuildAction artifactDeployerBuildActionAction = deployedArtifactsService.getOrCreateAction(build);
        int numberOfCurrentDeployedArtifacts = artifactDeployerBuildActionAction.getDeployedArtifactsCount();
        ArtifactDeployerCopy deployerCopy = new ArtifactDeployerCopy(listener, includes, excludes, flatten, outputFilePath, numberOfCurrentDeployedArtifacts);
        ArtifactDeployerManager deployerManager = new ArtifactDeployerManager();
        FilePath basedirFilePath = deployerManager.getBasedirFilePath(workspace, basedir);
        List results = (List)basedirFilePath.act((FilePath.FileCallable)deployerCopy);
        deployedArtifacts.put(this.entry.getUniqueId(), results);
        return deployedArtifacts;
    }

    public ArtifactDeployerEntry getEntry() {
        return this.entry;
    }

    private void setEntry(ArtifactDeployerEntry entry) {
        this.entry = entry;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String DISPLAY_NAME = Messages.depployerartifact_displayName();

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public FormValidation doCheckIncludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public FormValidation doCheckExcludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (value == null || value.trim().length() == 0) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public FormValidation doCheckRemote(@QueryParameter String value) throws IOException {
            if (value == null || value.trim().length() == 0) {
                throw FormValidation.error((String)"Remote directory is mandatory.");
            }
            return FormValidation.ok();
        }
    }

    @Extension
    public static final class DeleteRemoteArtifactFromBuilder
    extends RunListener<AbstractBuild> {
        private final Logger logger = Logger.getLogger(DeleteRemoteArtifactFromBuilder.class.getName());

        public void onDeleted(AbstractBuild build) {
            if (!(build.getProject() instanceof FreeStyleProject)) {
                return;
            }
            FreeStyleProject freeStyleProject = (FreeStyleProject)build.getProject();
            DescribableList projectBuilders = freeStyleProject.getBuildersList();
            Iterator it = projectBuilders.iterator();
            ArrayList<ArtifactDeployerBuilder> artifactDeployerBuilders = new ArrayList<ArtifactDeployerBuilder>();
            while (it.hasNext()) {
                Builder builder = (Builder)it.next();
                if (!DescriptorImpl.DISPLAY_NAME.equals(builder.getDescriptor().getDisplayName())) continue;
                ArtifactDeployerBuilder instance = (ArtifactDeployerBuilder)builder;
                artifactDeployerBuilders.add(instance);
            }
            for (ArtifactDeployerBuilder artifactDeployerBuilder : artifactDeployerBuilders) {
                FilePath workspace;
                List<ArtifactDeployerVO> listArtifacts;
                ArtifactDeployerEntry entry;
                Map<Integer, List<ArtifactDeployerVO>> info;
                ArtifactDeployerBuildAction artifactDeployerBuildAction = (ArtifactDeployerBuildAction)build.getAction(ArtifactDeployerBuildAction.class);
                if (artifactDeployerBuildAction == null || (info = artifactDeployerBuildAction.getDeployedArtifactsInfo()) == null || !(entry = artifactDeployerBuilder.getEntry()).isDeleteRemoteArtifacts() || (listArtifacts = info.get(entry.getUniqueId())) == null || (workspace = build.getWorkspace()) == null) continue;
                for (ArtifactDeployerVO vo : listArtifacts) {
                    FilePath remoteArtifactPath = new FilePath(workspace.getChannel(), vo.getRemotePath());
                    try {
                        if (remoteArtifactPath.exists()) {
                            remoteArtifactPath.deleteRecursive();
                        }
                        if (!remoteArtifactPath.getParent().exists() || remoteArtifactPath.getParent().list().size() != 0) continue;
                        remoteArtifactPath.getParent().delete();
                    }
                    catch (IOException ioe) {
                        this.logger.log(Level.SEVERE, "Error when deleting artifacts.", ioe);
                    }
                    catch (InterruptedException ie) {
                        this.logger.log(Level.SEVERE, "Error when deleting artifacts.", ie);
                    }
                }
            }
        }
    }
}

