/*
 * Decompiled with CFR 0.152.
 */
package hudson.markup;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.markup.BasicPolicy;
import hudson.markup.MarkupFormatter;
import hudson.markup.MarkupFormatterDescriptor;
import java.io.IOException;
import java.io.Writer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.owasp.html.Handler;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;

public class RawHtmlMarkupFormatter
extends MarkupFormatter {
    public static final MarkupFormatter INSTANCE = new RawHtmlMarkupFormatter(false);
    private final boolean disableSyntaxHighlighting;

    @DataBoundConstructor
    public RawHtmlMarkupFormatter(boolean disableSyntaxHighlighting) {
        this.disableSyntaxHighlighting = disableSyntaxHighlighting;
    }

    public boolean isDisableSyntaxHighlighting() {
        return this.disableSyntaxHighlighting;
    }

    public void translate(String markup, @NonNull Writer output) throws IOException {
        HtmlStreamRenderer renderer = HtmlStreamRenderer.create((Appendable)output, (Handler)Handler.PROPAGATE, x -> {
            throw new Error((String)x);
        });
        HtmlSanitizer.sanitize((String)markup, (HtmlSanitizer.Policy)BasicPolicy.POLICY_DEFINITION.apply((HtmlStreamEventReceiver)renderer));
    }

    public String getCodeMirrorMode() {
        return this.disableSyntaxHighlighting ? null : "htmlmixed";
    }

    public String getCodeMirrorConfig() {
        return "\"mode\":\"text/html\"";
    }

    @Extension
    public static class DescriptorImpl
    extends MarkupFormatterDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Safe HTML";
        }
    }
}

