// CHECKSTYLE:OFF

package hudson.plugins.antexec;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code AntExec.AntHomeEnvVarNotFound}: {@code Usable ANT_HOME has

     * not been found in environment variables.}.
     * 
     * @return
     *     {@code Usable ANT_HOME has not been found in environment variables.}
     */
    public static String AntExec_AntHomeEnvVarNotFound() {
        return holder.format("AntExec.AntHomeEnvVarNotFound");
    }

    /**
     * Key {@code AntExec.AntHomeEnvVarNotFound}: {@code Usable ANT_HOME has

     * not been found in environment variables.}.
     * 
     * @return
     *     {@code Usable ANT_HOME has not been found in environment variables.}
     */
    public static Localizable _AntExec_AntHomeEnvVarNotFound() {
        return new Localizable(holder, "AntExec.AntHomeEnvVarNotFound");
    }

    /**
     * Key {@code AntExec.SetAntHome}: {@code If you use "(Default)" Ant

     * installation, please set Ant home directory!}.
     * 
     * @return
     *     {@code If you use "(Default)" Ant installation, please set Ant home

     *     directory!}
     */
    public static String AntExec_SetAntHome() {
        return holder.format("AntExec.SetAntHome");
    }

    /**
     * Key {@code AntExec.SetAntHome}: {@code If you use "(Default)" Ant

     * installation, please set Ant home directory!}.
     * 
     * @return
     *     {@code If you use "(Default)" Ant installation, please set Ant home

     *     directory!}
     */
    public static Localizable _AntExec_SetAntHome() {
        return new Localizable(holder, "AntExec.SetAntHome");
    }

    /**
     * Key {@code AntExec.AntHomeReplacing}: {@code You have specified

     * ANT_HOME in setup of build step. Forcing it to "{1}" from "{0}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have specified ANT_HOME in setup of build step. Forcing it

     *     to "{1}" from "{0}"}
     */
    public static String AntExec_AntHomeReplacing(Object arg0, Object arg1) {
        return holder.format("AntExec.AntHomeReplacing", arg0, arg1);
    }

    /**
     * Key {@code AntExec.AntHomeReplacing}: {@code You have specified

     * ANT_HOME in setup of build step. Forcing it to "{1}" from "{0}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have specified ANT_HOME in setup of build step. Forcing it

     *     to "{1}" from "{0}"}
     */
    public static Localizable _AntExec_AntHomeReplacing(Object arg0, Object arg1) {
        return new Localizable(holder, "AntExec.AntHomeReplacing", arg0, arg1);
    }

    /**
     * Key {@code AntExec.DebugPropertiesFieldBegin}: {@code Content of

     * properties text area --- begin ---}.
     * 
     * @return
     *     {@code Content of properties text area --- begin ---}
     */
    public static String AntExec_DebugPropertiesFieldBegin() {
        return holder.format("AntExec.DebugPropertiesFieldBegin");
    }

    /**
     * Key {@code AntExec.DebugPropertiesFieldBegin}: {@code Content of

     * properties text area --- begin ---}.
     * 
     * @return
     *     {@code Content of properties text area --- begin ---}
     */
    public static Localizable _AntExec_DebugPropertiesFieldBegin() {
        return new Localizable(holder, "AntExec.DebugPropertiesFieldBegin");
    }

    /**
     * Key {@code AntExec.NotAntDirectory}: {@code {0} doesn''t look like an

     * Ant directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} doesn''t look like an Ant directory}
     */
    public static String AntExec_NotAntDirectory(Object arg0) {
        return holder.format("AntExec.NotAntDirectory", arg0);
    }

    /**
     * Key {@code AntExec.NotAntDirectory}: {@code {0} doesn''t look like an

     * Ant directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} doesn''t look like an Ant directory}
     */
    public static Localizable _AntExec_NotAntDirectory(Object arg0) {
        return new Localizable(holder, "AntExec.NotAntDirectory", arg0);
    }

    /**
     * Key {@code AntExec.EnvironmentChanged}: {@code WARNING: Environment

     * variable {0} has been changed to: "{1}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code WARNING: Environment variable {0} has been changed to: "{1}"}
     */
    public static String AntExec_EnvironmentChanged(Object arg0, Object arg1) {
        return holder.format("AntExec.EnvironmentChanged", arg0, arg1);
    }

    /**
     * Key {@code AntExec.EnvironmentChanged}: {@code WARNING: Environment

     * variable {0} has been changed to: "{1}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code WARNING: Environment variable {0} has been changed to: "{1}"}
     */
    public static Localizable _AntExec_EnvironmentChanged(Object arg0, Object arg1) {
        return new Localizable(holder, "AntExec.EnvironmentChanged", arg0, arg1);
    }

    /**
     * Key {@code AntExec.DebugScriptSourceFieldEnd}: {@code Content of

     * scriptSource text area ---- end ----}.
     * 
     * @return
     *     {@code Content of scriptSource text area ---- end ----}
     */
    public static String AntExec_DebugScriptSourceFieldEnd() {
        return holder.format("AntExec.DebugScriptSourceFieldEnd");
    }

    /**
     * Key {@code AntExec.DebugScriptSourceFieldEnd}: {@code Content of

     * scriptSource text area ---- end ----}.
     * 
     * @return
     *     {@code Content of scriptSource text area ---- end ----}
     */
    public static Localizable _AntExec_DebugScriptSourceFieldEnd() {
        return new Localizable(holder, "AntExec.DebugScriptSourceFieldEnd");
    }

    /**
     * Key {@code AntExec.UseAntContribTasks}: {@code You can use core Apache

     * Ant and Ant-contrib tasks! Ant-contrib is enabled in global

     * settings.}.
     * 
     * @return
     *     {@code You can use core Apache Ant and Ant-contrib tasks! Ant-contrib

     *     is enabled in global settings.}
     */
    public static String AntExec_UseAntContribTasks() {
        return holder.format("AntExec.UseAntContribTasks");
    }

    /**
     * Key {@code AntExec.UseAntContribTasks}: {@code You can use core Apache

     * Ant and Ant-contrib tasks! Ant-contrib is enabled in global

     * settings.}.
     * 
     * @return
     *     {@code You can use core Apache Ant and Ant-contrib tasks! Ant-contrib

     *     is enabled in global settings.}
     */
    public static Localizable _AntExec_UseAntContribTasks() {
        return new Localizable(holder, "AntExec.UseAntContribTasks");
    }

    /**
     * Key {@code AntExec.DebugScriptSourceFieldBegin}: {@code Content of

     * scriptSource text area --- begin ---}.
     * 
     * @return
     *     {@code Content of scriptSource text area --- begin ---}
     */
    public static String AntExec_DebugScriptSourceFieldBegin() {
        return holder.format("AntExec.DebugScriptSourceFieldBegin");
    }

    /**
     * Key {@code AntExec.DebugScriptSourceFieldBegin}: {@code Content of

     * scriptSource text area --- begin ---}.
     * 
     * @return
     *     {@code Content of scriptSource text area --- begin ---}
     */
    public static Localizable _AntExec_DebugScriptSourceFieldBegin() {
        return new Localizable(holder, "AntExec.DebugScriptSourceFieldBegin");
    }

    /**
     * Key {@code AntExec.AntHomeEnvVarFound}: {@code Found usable ANT_HOME

     * in environment: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Found usable ANT_HOME in environment: "{0}"}
     */
    public static String AntExec_AntHomeEnvVarFound(Object arg0) {
        return holder.format("AntExec.AntHomeEnvVarFound", arg0);
    }

    /**
     * Key {@code AntExec.AntHomeEnvVarFound}: {@code Found usable ANT_HOME

     * in environment: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Found usable ANT_HOME in environment: "{0}"}
     */
    public static Localizable _AntExec_AntHomeEnvVarFound(Object arg0) {
        return new Localizable(holder, "AntExec.AntHomeEnvVarFound", arg0);
    }

    /**
     * Key {@code AntExec.EnvironmentAdded}: {@code WARNING: Environment

     * variable {0} has been extended with "{1}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code WARNING: Environment variable {0} has been extended with "{1}"}
     */
    public static String AntExec_EnvironmentAdded(Object arg0, Object arg1) {
        return holder.format("AntExec.EnvironmentAdded", arg0, arg1);
    }

    /**
     * Key {@code AntExec.EnvironmentAdded}: {@code WARNING: Environment

     * variable {0} has been extended with "{1}"}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code WARNING: Environment variable {0} has been extended with "{1}"}
     */
    public static Localizable _AntExec_EnvironmentAdded(Object arg0, Object arg1) {
        return new Localizable(holder, "AntExec.EnvironmentAdded", arg0, arg1);
    }

    /**
     * Key {@code AntExec.DebugPropertiesFieldEnd}: {@code Content of

     * properties text area ---- end ----}.
     * 
     * @return
     *     {@code Content of properties text area ---- end ----}
     */
    public static String AntExec_DebugPropertiesFieldEnd() {
        return holder.format("AntExec.DebugPropertiesFieldEnd");
    }

    /**
     * Key {@code AntExec.DebugPropertiesFieldEnd}: {@code Content of

     * properties text area ---- end ----}.
     * 
     * @return
     *     {@code Content of properties text area ---- end ----}
     */
    public static Localizable _AntExec_DebugPropertiesFieldEnd() {
        return new Localizable(holder, "AntExec.DebugPropertiesFieldEnd");
    }

    /**
     * Key {@code AntExec.ProjectConfigNeeded}: {@code Maybe you need to set

     * environment variable ANT_HOME, or set its correct value in job

     * configuration.}.
     * 
     * @return
     *     {@code Maybe you need to set environment variable ANT_HOME, or set its

     *     correct value in job configuration.}
     */
    public static String AntExec_ProjectConfigNeeded() {
        return holder.format("AntExec.ProjectConfigNeeded");
    }

    /**
     * Key {@code AntExec.ProjectConfigNeeded}: {@code Maybe you need to set

     * environment variable ANT_HOME, or set its correct value in job

     * configuration.}.
     * 
     * @return
     *     {@code Maybe you need to set environment variable ANT_HOME, or set its

     *     correct value in job configuration.}
     */
    public static Localizable _AntExec_ProjectConfigNeeded() {
        return new Localizable(holder, "AntExec.ProjectConfigNeeded");
    }

    /**
     * Key {@code AntExec.AntInstallationDefault}: {@code Ant Installation is

     * "(Default)", so Ant installation is not set!}.
     * 
     * @return
     *     {@code Ant Installation is "(Default)", so Ant installation is not

     *     set!}
     */
    public static String AntExec_AntInstallationDefault() {
        return holder.format("AntExec.AntInstallationDefault");
    }

    /**
     * Key {@code AntExec.AntInstallationDefault}: {@code Ant Installation is

     * "(Default)", so Ant installation is not set!}.
     * 
     * @return
     *     {@code Ant Installation is "(Default)", so Ant installation is not

     *     set!}
     */
    public static Localizable _AntExec_AntInstallationDefault() {
        return new Localizable(holder, "AntExec.AntInstallationDefault");
    }

    /**
     * Key {@code AntExec.AntHomeValidation}: {@code Please set ANT_HOME

     * directory!}.
     * 
     * @return
     *     {@code Please set ANT_HOME directory!}
     */
    public static String AntExec_AntHomeValidation() {
        return holder.format("AntExec.AntHomeValidation");
    }

    /**
     * Key {@code AntExec.AntHomeValidation}: {@code Please set ANT_HOME

     * directory!}.
     * 
     * @return
     *     {@code Please set ANT_HOME directory!}
     */
    public static Localizable _AntExec_AntHomeValidation() {
        return new Localizable(holder, "AntExec.AntHomeValidation");
    }

    /**
     * Key {@code AntExec.DisplayName}: {@code Execute Apache Ant}.
     * 
     * @return
     *     {@code Execute Apache Ant}
     */
    public static String AntExec_DisplayName() {
        return holder.format("AntExec.DisplayName");
    }

    /**
     * Key {@code AntExec.DisplayName}: {@code Execute Apache Ant}.
     * 
     * @return
     *     {@code Execute Apache Ant}
     */
    public static Localizable _AntExec_DisplayName() {
        return new Localizable(holder, "AntExec.DisplayName");
    }

    /**
     * Key {@code AntExec.ExecFailed}: {@code command execution failed.}.
     * 
     * @return
     *     {@code command execution failed.}
     */
    public static String AntExec_ExecFailed() {
        return holder.format("AntExec.ExecFailed");
    }

    /**
     * Key {@code AntExec.ExecFailed}: {@code command execution failed.}.
     * 
     * @return
     *     {@code command execution failed.}
     */
    public static Localizable _AntExec_ExecFailed() {
        return new Localizable(holder, "AntExec.ExecFailed");
    }

    /**
     * Key {@code AntExec.ExecutableNotFound}: {@code Cannot find executable

     * from the choosen Ant installation "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find executable from the choosen Ant installation "{0}"}
     */
    public static String AntExec_ExecutableNotFound(Object arg0) {
        return holder.format("AntExec.ExecutableNotFound", arg0);
    }

    /**
     * Key {@code AntExec.ExecutableNotFound}: {@code Cannot find executable

     * from the choosen Ant installation "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find executable from the choosen Ant installation "{0}"}
     */
    public static Localizable _AntExec_ExecutableNotFound(Object arg0) {
        return new Localizable(holder, "AntExec.ExecutableNotFound", arg0);
    }

    /**
     * Key {@code AntExec.NotADirectory}: {@code {0} is not a directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not a directory}
     */
    public static String AntExec_NotADirectory(Object arg0) {
        return holder.format("AntExec.NotADirectory", arg0);
    }

    /**
     * Key {@code AntExec.NotADirectory}: {@code {0} is not a directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not a directory}
     */
    public static Localizable _AntExec_NotADirectory(Object arg0) {
        return new Localizable(holder, "AntExec.NotADirectory", arg0);
    }

    /**
     * Key {@code AntExec.UseAntCoreTasksOnly}: {@code Please use only the

     * core Apache Ant tasks! Ant-contrib is not enabled in global

     * settings.}.
     * 
     * @return
     *     {@code Please use only the core Apache Ant tasks! Ant-contrib is not

     *     enabled in global settings.}
     */
    public static String AntExec_UseAntCoreTasksOnly() {
        return holder.format("AntExec.UseAntCoreTasksOnly");
    }

    /**
     * Key {@code AntExec.UseAntCoreTasksOnly}: {@code Please use only the

     * core Apache Ant tasks! Ant-contrib is not enabled in global

     * settings.}.
     * 
     * @return
     *     {@code Please use only the core Apache Ant tasks! Ant-contrib is not

     *     enabled in global settings.}
     */
    public static Localizable _AntExec_UseAntCoreTasksOnly() {
        return new Localizable(holder, "AntExec.UseAntCoreTasksOnly");
    }

}
