/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tasks.Ant;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks._ant.AntConsoleAnnotator;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AntWrapper
extends SimpleBuildWrapper {
    private String installation;
    private String jdk;

    @DataBoundConstructor
    public AntWrapper() {
    }

    public String getInstallation() {
        return this.installation;
    }

    @DataBoundSetter
    public void setInstallation(String installation) {
        this.installation = Util.fixEmpty((String)installation);
    }

    public String getJdk() {
        return this.jdk;
    }

    @DataBoundSetter
    public void setJdk(String jdk) {
        this.jdk = Util.fixEmpty((String)jdk);
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        if (this.installation != null) {
            AntWrapper.toolEnv(context, this.installation, ((Ant.DescriptorImpl)Jenkins.get().getDescriptorByType(Ant.DescriptorImpl.class)).getInstallations(), workspace, listener, initialEnvironment);
        }
        if (this.jdk != null) {
            AntWrapper.toolEnv(context, this.jdk, (ToolInstallation[])((JDK.DescriptorImpl)Jenkins.get().getDescriptorByType(JDK.DescriptorImpl.class)).getInstallations(), workspace, listener, initialEnvironment);
        }
    }

    private static void toolEnv(SimpleBuildWrapper.Context context, @NonNull String tool, ToolInstallation[] tools, FilePath workspace, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        Node node;
        Computer computer;
        ToolInstallation inst = null;
        for (ToolInstallation _inst : tools) {
            if (!_inst.getName().equals(tool)) continue;
            inst = _inst;
            break;
        }
        if (inst == null) {
            throw new AbortException("no such tool \u2018" + tool + "\u2019");
        }
        if (inst instanceof NodeSpecific && (computer = workspace.toComputer()) != null && (node = computer.getNode()) != null) {
            inst = (ToolInstallation)((NodeSpecific)inst).forNode(node, listener);
        }
        if (inst instanceof EnvironmentSpecific) {
            inst = (ToolInstallation)((EnvironmentSpecific)inst).forEnvironment(initialEnvironment);
        }
        EnvVars modified = new EnvVars();
        inst.buildEnvVars(modified);
        for (Map.Entry entry : modified.entrySet()) {
            context.env((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public ConsoleLogFilter createLoggerDecorator(Run<?, ?> build) {
        return AntConsoleAnnotator.asConsoleLogFilter();
    }

    @Extension
    @Symbol(value={"withAnt"})
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "With Ant";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

