/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks._ant;

import com.google.common.base.Charsets;
import hudson.console.ConsoleLogFilter;
import hudson.console.LineTransformationOutputStream;
import hudson.model.Run;
import hudson.tasks._ant.AntOutcomeNote;
import hudson.tasks._ant.AntTargetNote;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jenkins.util.JenkinsJVM;

public class AntConsoleAnnotator
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;
    private final byte[][] antNotes;
    private boolean seenEmptyLine;

    public AntConsoleAnnotator(OutputStream out, Charset charset) {
        this(out, charset, AntConsoleAnnotator.createAntNotes());
    }

    private AntConsoleAnnotator(OutputStream out, Charset charset, byte[][] antNotes) {
        this.out = out;
        this.charset = charset;
        this.antNotes = antNotes;
    }

    private static byte[][] createAntNotes() {
        JenkinsJVM.checkJenkinsJVM();
        try {
            ByteArrayOutputStream targetNote = new ByteArrayOutputStream();
            new AntTargetNote().encodeTo(targetNote);
            ByteArrayOutputStream outcomeNote = new ByteArrayOutputStream();
            new AntOutcomeNote().encodeTo(outcomeNote);
            return new byte[][]{targetNote.toByteArray(), outcomeNote.toByteArray()};
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        line = this.trimEOL(line);
        if (this.seenEmptyLine && this.endsWith(line, ':') && line.indexOf(32) < 0) {
            this.out.write(this.antNotes[0]);
        }
        if (line.equals("BUILD SUCCESSFUL") || line.equals("BUILD FAILED")) {
            this.out.write(this.antNotes[1]);
        }
        this.seenEmptyLine = line.length() == 0;
        this.out.write(b, 0, len);
    }

    private boolean endsWith(String line, char c) {
        int len = line.length();
        return len > 0 && line.charAt(len - 1) == c;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }

    public static ConsoleLogFilter asConsoleLogFilter() {
        return new ConsoleLogFilterImpl();
    }

    private static class ConsoleLogFilterImpl
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private byte[][] antNotes = AntConsoleAnnotator.createAntNotes();

        private ConsoleLogFilterImpl() {
        }

        private Object readResolve() {
            if (this.antNotes == null) {
                this.antNotes = AntConsoleAnnotator.createAntNotes();
            }
            return this;
        }

        public OutputStream decorateLogger(Run build, OutputStream logger) throws IOException, InterruptedException {
            return new AntConsoleAnnotator(logger, Charsets.UTF_8, this.antNotes);
        }
    }
}

