// CHECKSTYLE:OFF

package hudson.tasks._ant;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Ant.ProjectConfigNeeded}: {@code Maybe you need to
     * configure the job to choose one of your Ant installations?}.
     * 
     * @return
     *     {@code Maybe you need to configure the job to choose one of your Ant
     *     installations?}
     */
    public static String Ant_ProjectConfigNeeded() {
        return holder.format("Ant.ProjectConfigNeeded");
    }

    /**
     * Key {@code Ant.ProjectConfigNeeded}: {@code Maybe you need to
     * configure the job to choose one of your Ant installations?}.
     * 
     * @return
     *     {@code Maybe you need to configure the job to choose one of your Ant
     *     installations?}
     */
    public static Localizable _Ant_ProjectConfigNeeded() {
        return new Localizable(holder, "Ant.ProjectConfigNeeded");
    }

    /**
     * Key {@code Ant.DisplayName}: {@code Invoke Ant}.
     * 
     * @return
     *     {@code Invoke Ant}
     */
    public static String Ant_DisplayName() {
        return holder.format("Ant.DisplayName");
    }

    /**
     * Key {@code Ant.DisplayName}: {@code Invoke Ant}.
     * 
     * @return
     *     {@code Invoke Ant}
     */
    public static Localizable _Ant_DisplayName() {
        return new Localizable(holder, "Ant.DisplayName");
    }

    /**
     * Key {@code Ant.NotADirectory}: {@code {0} is not a directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not a directory}
     */
    public static String Ant_NotADirectory(Object arg0) {
        return holder.format("Ant.NotADirectory", arg0);
    }

    /**
     * Key {@code Ant.NotADirectory}: {@code {0} is not a directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not a directory}
     */
    public static Localizable _Ant_NotADirectory(Object arg0) {
        return new Localizable(holder, "Ant.NotADirectory", arg0);
    }

    /**
     * Key {@code Ant.NodeOffline}: {@code Cannot get installation for node,
     * since it is not online}.
     * 
     * @return
     *     {@code Cannot get installation for node, since it is not online}
     */
    public static String Ant_NodeOffline() {
        return holder.format("Ant.NodeOffline");
    }

    /**
     * Key {@code Ant.NodeOffline}: {@code Cannot get installation for node,
     * since it is not online}.
     * 
     * @return
     *     {@code Cannot get installation for node, since it is not online}
     */
    public static Localizable _Ant_NodeOffline() {
        return new Localizable(holder, "Ant.NodeOffline");
    }

    /**
     * Key {@code Ant.InstallFromApache}: {@code Install from Apache}.
     * 
     * @return
     *     {@code Install from Apache}
     */
    public static String Ant_InstallFromApache() {
        return holder.format("Ant.InstallFromApache");
    }

    /**
     * Key {@code Ant.InstallFromApache}: {@code Install from Apache}.
     * 
     * @return
     *     {@code Install from Apache}
     */
    public static Localizable _Ant_InstallFromApache() {
        return new Localizable(holder, "Ant.InstallFromApache");
    }

    /**
     * Key {@code Ant.ExecFailed}: {@code command execution failed.}.
     * 
     * @return
     *     {@code command execution failed.}
     */
    public static String Ant_ExecFailed() {
        return holder.format("Ant.ExecFailed");
    }

    /**
     * Key {@code Ant.ExecFailed}: {@code command execution failed.}.
     * 
     * @return
     *     {@code command execution failed.}
     */
    public static Localizable _Ant_ExecFailed() {
        return new Localizable(holder, "Ant.ExecFailed");
    }

    /**
     * Key {@code Ant.ExecutableNotFound}: {@code Cannot find executable from
     * the chosen Ant installation "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find executable from the chosen Ant installation "{0}"}
     */
    public static String Ant_ExecutableNotFound(Object arg0) {
        return holder.format("Ant.ExecutableNotFound", arg0);
    }

    /**
     * Key {@code Ant.ExecutableNotFound}: {@code Cannot find executable from
     * the chosen Ant installation "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find executable from the chosen Ant installation "{0}"}
     */
    public static Localizable _Ant_ExecutableNotFound(Object arg0) {
        return new Localizable(holder, "Ant.ExecutableNotFound", arg0);
    }

    /**
     * Key {@code Ant.GlobalConfigNeeded}: {@code Maybe you need to configure
     * where your Ant installations are?}.
     * 
     * @return
     *     {@code Maybe you need to configure where your Ant installations are?}
     */
    public static String Ant_GlobalConfigNeeded() {
        return holder.format("Ant.GlobalConfigNeeded");
    }

    /**
     * Key {@code Ant.GlobalConfigNeeded}: {@code Maybe you need to configure
     * where your Ant installations are?}.
     * 
     * @return
     *     {@code Maybe you need to configure where your Ant installations are?}
     */
    public static Localizable _Ant_GlobalConfigNeeded() {
        return new Localizable(holder, "Ant.GlobalConfigNeeded");
    }

    /**
     * Key {@code Ant.NotAntDirectory}: {@code {0} doesn''t look like an Ant
     * directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} doesn''t look like an Ant directory}
     */
    public static String Ant_NotAntDirectory(Object arg0) {
        return holder.format("Ant.NotAntDirectory", arg0);
    }

    /**
     * Key {@code Ant.NotAntDirectory}: {@code {0} doesn''t look like an Ant
     * directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} doesn''t look like an Ant directory}
     */
    public static Localizable _Ant_NotAntDirectory(Object arg0) {
        return new Localizable(holder, "Ant.NotAntDirectory", arg0);
    }

}
