/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

class Utils {
    Utils() {
    }

    static FilePath createSshKeyFile(FilePath key, FilePath tmpPath, SSHUserPrivateKey credentials, boolean inThisDir) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        List privateKeys = credentials.getPrivateKeys();
        for (String s : privateKeys) {
            sb.append(s);
        }
        key = tmpPath.createTextTempFile("ssh", ".key", sb.toString(), inThisDir);
        key.chmod(256);
        return key;
    }

    static FilePath createSshAskPassFile(FilePath script, FilePath tmpPath, SSHUserPrivateKey credentials, boolean inThisDir) throws IOException, InterruptedException {
        tmpPath.mkdirs();
        StringBuilder sb = new StringBuilder();
        sb.append("#! /bin/sh\n").append("/bin/echo \"" + Secret.toString((Secret)credentials.getPassphrase()) + "\"");
        script = tmpPath.createTextTempFile("ssh", ".sh", sb.toString(), inThisDir);
        script.chmod(448);
        return script;
    }

    static FilePath createVaultPasswordFile(FilePath key, FilePath tmpPath, FileCredentials credentials) throws IOException, InterruptedException {
        try (InputStream content = credentials.getContent();){
            tmpPath.mkdirs();
            key = tmpPath.createTempFile("vault", ".password");
            key.copyFrom(content);
            key.chmod(256);
        }
        return key;
    }

    static FilePath createVaultPasswordFile(FilePath key, FilePath tmpPath, StringCredentials credentials) throws IOException, InterruptedException {
        tmpPath.mkdirs();
        key = tmpPath.createTextTempFile("vault", ".password", credentials.getSecret().getPlainText(), true);
        key.chmod(256);
        return key;
    }

    static void deleteTempFile(FilePath tempFile, TaskListener listener) throws IOException, InterruptedException {
        block3: {
            if (tempFile != null) {
                try {
                    tempFile.delete();
                }
                catch (IOException ioe) {
                    if (!tempFile.exists()) break block3;
                    listener.getLogger().println("[WARNING] temp file " + String.valueOf(tempFile) + " not deleted");
                }
            }
        }
    }
}

