/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import org.jenkinsci.plugins.ansible.AbstractAnsibleInvocation;
import org.jenkinsci.plugins.ansible.AnsibleInvocationException;

public class AnsibleAdHocCommandInvocation
extends AbstractAnsibleInvocation<AnsibleAdHocCommandInvocation> {
    private String module;
    private String hostPattern;
    private String command;

    protected AnsibleAdHocCommandInvocation(String exe, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException, AnsibleInvocationException {
        super(exe, (Run<?, ?>)build, build.getWorkspace(), (TaskListener)listener, build.getEnvironment((TaskListener)listener));
    }

    public AnsibleAdHocCommandInvocation(String exe, Run<?, ?> build, FilePath ws, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, AnsibleInvocationException {
        super(exe, build, ws, listener, envVars);
    }

    public AnsibleAdHocCommandInvocation setHostPattern(String hostPattern) {
        this.hostPattern = hostPattern;
        return this;
    }

    private ArgumentListBuilder appendHostPattern(ArgumentListBuilder args) {
        args.add(this.envVars.expand(this.hostPattern));
        return args;
    }

    public AnsibleAdHocCommandInvocation setModule(String module) {
        this.module = module;
        return this;
    }

    private ArgumentListBuilder appendModule(ArgumentListBuilder args) {
        this.addOptionAndValue(args, "-m", this.module);
        return args;
    }

    public AnsibleAdHocCommandInvocation setModuleCommand(String command) {
        this.command = command;
        return this;
    }

    public ArgumentListBuilder appendModuleCommand(ArgumentListBuilder args) {
        this.addOptionAndValue(args, "-a", this.command);
        return args;
    }

    @Override
    protected ArgumentListBuilder buildCommandLine() throws InterruptedException, AnsibleInvocationException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        this.prependPasswordCredentials(args);
        this.appendExecutable(args);
        this.appendHostPattern(args);
        this.appendInventory(args);
        this.appendModule(args);
        this.appendModuleCommand(args);
        this.appendBecome(args);
        this.appendSudo(args);
        this.appendForks(args);
        this.appendCredentials(args);
        this.appendVaultPasswordFile(args);
        this.appendExtraVars(args);
        this.appendAdditionalParameters(args);
        return args;
    }
}

