/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.ansible.AnsibleCommand;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class AnsibleInstallation
extends ToolInstallation
implements EnvironmentSpecific<AnsibleInstallation>,
NodeSpecific<AnsibleInstallation>,
Serializable {
    @DataBoundConstructor
    public AnsibleInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public AnsibleInstallation forEnvironment(EnvVars environment) {
        return new AnsibleInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public AnsibleInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new AnsibleInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public static String getExecutable(String name, AnsibleCommand command, Node node, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        Jenkins j;
        if (name != null && (j = Jenkins.getInstance()) != null) {
            for (AnsibleInstallation tool : (AnsibleInstallation[])((DescriptorImpl)j.getDescriptorByType(DescriptorImpl.class)).getInstallations()) {
                FilePath homePath;
                String home;
                if (!tool.getName().equals(name)) continue;
                if (node != null) {
                    tool = tool.forNode(node, listener);
                }
                if (env != null) {
                    tool = tool.forEnvironment(env);
                }
                if ((home = Util.fixEmpty((String)tool.getHome())) == null) continue;
                if (node != null && (homePath = node.createPath(home)) != null) {
                    return homePath.child(command.getName()).getRemote();
                }
                return home + "/" + command.getName();
            }
        }
        return command.getName();
    }

    public static AnsibleInstallation[] allInstallations() {
        DescriptorImpl ansibleDescriptor = (DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(DescriptorImpl.class);
        return (AnsibleInstallation[])ansibleDescriptor.getInstallations();
    }

    public static AnsibleInstallation getInstallation(String ansibleInstallation) throws IOException {
        AnsibleInstallation[] installations = AnsibleInstallation.allInstallations();
        if (ansibleInstallation == null) {
            if (installations.length == 0) {
                throw new IOException("Ansible not found");
            }
            return installations[0];
        }
        for (AnsibleInstallation installation : installations) {
            if (!ansibleInstallation.equals(installation.getName())) continue;
            return installation;
        }
        throw new IOException("Ansible not found");
    }

    public void buildEnvVars(EnvVars env) {
        String home = Util.fixEmpty((String)this.getHome());
        if (home != null) {
            env.put("PATH+ANSIBLE", home);
        }
    }

    @Extension
    @Symbol(value={"ansible"})
    public static class DescriptorImpl
    extends ToolDescriptor<AnsibleInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            super.configure(req, json);
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "Ansible";
        }
    }
}

