/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible.workflow;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.inject.Inject;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ansible.AnsibleInstallation;
import org.jenkinsci.plugins.ansible.AnsibleVaultBuilder;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AnsibleVaultStep
extends AbstractStepImpl {
    private String installation;
    private String action;
    private String vaultCredentialsId;
    private String vaultTmpPath;
    private String newVaultCredentialsId;
    private String content = null;
    private String input = null;
    private String output = null;

    @DataBoundConstructor
    public AnsibleVaultStep() {
    }

    @DataBoundSetter
    public void setAction(String action) {
        this.action = action;
    }

    @DataBoundSetter
    public void setVaultCredentialsId(String vaultCredentialsId) {
        this.vaultCredentialsId = Util.fixEmptyAndTrim((String)vaultCredentialsId);
    }

    @DataBoundSetter
    public void setNewVaultCredentialsId(String newVaultCredentialsId) {
        this.newVaultCredentialsId = Util.fixEmptyAndTrim((String)newVaultCredentialsId);
    }

    @DataBoundSetter
    public void setVaultTmpPath(String vaultTmpPath) {
        this.vaultTmpPath = vaultTmpPath;
    }

    @DataBoundSetter
    public void setContent(String content) {
        this.content = content;
    }

    @DataBoundSetter
    public void setInput(String input) {
        this.input = input;
    }

    @DataBoundSetter
    public void setOutput(String output) {
        this.output = output;
    }

    @DataBoundSetter
    public void setInstallation(String installation) {
        this.installation = Util.fixEmptyAndTrim((String)installation);
    }

    public String getInstallation() {
        return this.installation;
    }

    public String getAction() {
        return this.action;
    }

    public String getVaultCredentialsId() {
        return this.vaultCredentialsId;
    }

    public String getNewVaultCredentialsId() {
        return this.newVaultCredentialsId;
    }

    public String getVaultTmpPath() {
        return this.vaultTmpPath;
    }

    public String getContent() {
        return this.content;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public static final class AnsibleVaultExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient AnsibleVaultStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient Computer computer;

        protected Void run() throws Exception {
            Node node;
            AnsibleVaultBuilder builder = new AnsibleVaultBuilder();
            builder.setAnsibleName(this.step.getInstallation());
            builder.setAction(this.step.getAction());
            builder.setVaultCredentialsId(this.step.getVaultCredentialsId());
            builder.setNewVaultCredentialsId(this.step.getNewVaultCredentialsId());
            builder.setVaultTmpPath(this.step.getVaultTmpPath());
            builder.setContent(this.step.getContent());
            builder.setInput(this.step.getInput());
            builder.setOutput(this.step.getOutput());
            if (this.computer == null || (node = this.computer.getNode()) == null) {
                throw new AbortException("The ansible vault build step requires to be launched on a node");
            }
            builder.perform(this.run, node, this.ws, this.launcher, this.listener, this.envVars);
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(AnsibleVaultExecution.class);
        }

        public String getFunctionName() {
            return "ansibleVault";
        }

        public String getDisplayName() {
            return "Invoke ansible vault";
        }

        public ListBoxModel doFillVaultCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String vaultCredentialsId) {
            return this.fillVaultCredentials(item, vaultCredentialsId);
        }

        public ListBoxModel doFillNewVaultCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String newVaultCredentialsId) {
            return this.fillVaultCredentials(item, newVaultCredentialsId);
        }

        public ListBoxModel doFillInstallationItems() {
            ListBoxModel model = new ListBoxModel();
            for (AnsibleInstallation tool : AnsibleInstallation.allInstallations()) {
                model.add(tool.getName());
            }
            return model;
        }

        private ListBoxModel fillVaultCredentials(Item item, String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(FileCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)item)).includeCurrentValue(credentialsId);
        }
    }
}

