/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import org.jenkinsci.plugins.ansible.AbstractAnsibleInvocation;
import org.jenkinsci.plugins.ansible.AnsibleInvocationException;

public class AnsiblePlaybookInvocation
extends AbstractAnsibleInvocation<AnsiblePlaybookInvocation> {
    private String playbook;
    private String limit;
    private String tags;
    private String skippedTags;
    private String startAtTask;
    private boolean checkMode;

    protected AnsiblePlaybookInvocation(String exe, AbstractBuild<?, ?> build, BuildListener listener, EnvVars envVars) throws IOException, InterruptedException, AnsibleInvocationException {
        this(exe, (Run<?, ?>)build, build.getWorkspace(), (TaskListener)listener, envVars);
    }

    public AnsiblePlaybookInvocation(String exe, Run<?, ?> build, FilePath ws, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, AnsibleInvocationException {
        super(exe, build, ws, listener, envVars);
    }

    public AnsiblePlaybookInvocation setPlaybook(String playbook) {
        this.playbook = playbook;
        return this;
    }

    public AnsiblePlaybookInvocation setCheckMode(boolean checkMode) {
        this.checkMode = checkMode;
        return this;
    }

    private ArgumentListBuilder appendPlaybook(ArgumentListBuilder args) {
        args.add(this.envVars.expand(this.playbook));
        return args;
    }

    public AnsiblePlaybookInvocation setLimit(String limit) {
        this.limit = limit;
        return this;
    }

    private ArgumentListBuilder appendLimit(ArgumentListBuilder args) {
        this.addOptionAndValue(args, "-l", this.limit);
        return args;
    }

    public AnsiblePlaybookInvocation setTags(String tags) {
        this.tags = tags;
        return this;
    }

    private ArgumentListBuilder appendTags(ArgumentListBuilder args) {
        this.addOptionAndValue(args, "-t", this.tags);
        return args;
    }

    public AnsiblePlaybookInvocation setSkippedTags(String skippedTags) {
        this.skippedTags = skippedTags;
        return this;
    }

    private ArgumentListBuilder appendSkippedTags(ArgumentListBuilder args) {
        this.addKeyValuePair(args, "--skip-tags", this.skippedTags);
        return args;
    }

    public AnsiblePlaybookInvocation setStartTask(String startAtTask) {
        this.startAtTask = startAtTask;
        return this;
    }

    private ArgumentListBuilder appendStartTask(ArgumentListBuilder args) {
        this.addKeyValuePair(args, "--start-at-task", this.startAtTask);
        return args;
    }

    protected ArgumentListBuilder appendCheckMode(ArgumentListBuilder args) {
        if (this.checkMode) {
            args.add("--check");
        }
        return args;
    }

    @Override
    protected ArgumentListBuilder buildCommandLine() throws InterruptedException, AnsibleInvocationException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        this.prependPasswordCredentials(args);
        this.appendExecutable(args);
        this.appendPlaybook(args);
        this.appendInventory(args);
        this.appendLimit(args);
        this.appendTags(args);
        this.appendSkippedTags(args);
        this.appendStartTask(args);
        this.appendBecome(args);
        this.appendCheckMode(args);
        this.appendSudo(args);
        this.appendForks(args);
        this.appendCredentials(args);
        this.appendVaultPasswordFile(args);
        this.appendExtraVars(args);
        this.appendAdditionalParameters(args);
        return args;
    }
}

