/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import com.android.apksig.ApkSigner;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.BuildListenerAdapter;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.androidsigning.Apk;
import org.jenkinsci.plugins.androidsigning.Messages;
import org.jenkinsci.plugins.androidsigning.SignedApkMappingStrategy;
import org.jenkinsci.plugins.androidsigning.SigningComponents;
import org.jenkinsci.plugins.androidsigning.ZipalignTool;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SignApksBuilder
extends Builder
implements SimpleBuildStep {
    static final List<DomainRequirement> NO_REQUIREMENTS = Collections.emptyList();
    static final String BUILDER_DIR = SignApksBuilder.class.getSimpleName() + "-out";
    private String androidHome;
    private String zipalignPath;
    private String keyStoreId;
    private String keyAlias;
    private String apksToSign;
    private SignedApkMappingStrategy signedApkMapping = new SignedApkMappingStrategy.UnsignedApkSiblingMapping();
    private boolean archiveSignedApks = true;
    private boolean archiveUnsignedApks = false;
    private boolean skipZipalign = false;
    private transient List<Apk> entries;

    static List<SignApksBuilder> singleEntryBuildersFromEntriesOfBuilder(SignApksBuilder oldBuilder) {
        ArrayList<SignApksBuilder> signers = new ArrayList<SignApksBuilder>(oldBuilder.getEntries().size());
        for (Apk apk : oldBuilder.getEntries()) {
            SignApksBuilder b = new SignApksBuilder();
            b.setPropertiesFromOldSigningEntry(apk);
            b.setAndroidHome(oldBuilder.getAndroidHome());
            b.setZipalignPath(oldBuilder.getZipalignPath());
            signers.add(b);
        }
        return signers;
    }

    private static String[] getSelectionGlobs(String apksToSignValue) {
        String[] globs = apksToSignValue.split("\\s*,\\s*");
        ArrayList<String> cleanGlobs = new ArrayList<String>(globs.length);
        for (String glob : globs) {
            if ((glob = glob.trim()).length() <= 0) continue;
            cleanGlobs.add(glob);
        }
        return cleanGlobs.toArray(new String[cleanGlobs.size()]);
    }

    @Deprecated
    public SignApksBuilder(List<Apk> entries) {
        this();
        if (entries.size() == 1) {
            this.setPropertiesFromOldSigningEntry(entries.get(0));
        } else if (entries.size() > 1) {
            throw new UnsupportedOperationException("this constructor is deprecated; use multiple build steps instead of multiple signing entries");
        }
    }

    @DataBoundConstructor
    public SignApksBuilder() {
    }

    protected Object readResolve() {
        if (this.signedApkMapping == null) {
            this.signedApkMapping = new SignedApkMappingStrategy.UnsignedApkBuilderDirMapping();
        }
        return this;
    }

    private void setPropertiesFromOldSigningEntry(Apk entry) {
        this.setKeyStoreId(entry.getKeyStore());
        this.setKeyAlias(entry.getAlias());
        this.setApksToSign(entry.getApksToSign());
        this.setSignedApkMapping(new SignedApkMappingStrategy.UnsignedApkBuilderDirMapping());
        this.setArchiveSignedApks(entry.getArchiveSignedApks());
        this.setArchiveUnsignedApks(entry.getArchiveUnsignedApks());
    }

    private boolean isIntermediateFailure(Run build) {
        Result result = build.getResult();
        return result != null && result.isWorseThan(Result.UNSTABLE);
    }

    boolean isMigrated() {
        return this.entries == null || this.entries.isEmpty();
    }

    @Deprecated
    public List<Apk> getEntries() {
        return this.entries;
    }

    @DataBoundSetter
    public void setAndroidHome(String x) {
        this.androidHome = StringUtils.stripToNull((String)x);
    }

    public String getAndroidHome() {
        return this.androidHome;
    }

    @DataBoundSetter
    public void setZipalignPath(String x) {
        this.zipalignPath = StringUtils.stripToNull((String)x);
    }

    public String getZipalignPath() {
        return this.zipalignPath;
    }

    @DataBoundSetter
    public void setKeyStoreId(String x) {
        this.keyStoreId = x;
    }

    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    @DataBoundSetter
    public void setKeyAlias(String x) {
        this.keyAlias = x;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    @DataBoundSetter
    public void setApksToSign(String x) {
        this.apksToSign = x;
    }

    public String getApksToSign() {
        return this.apksToSign;
    }

    @DataBoundSetter
    public void setSignedApkMapping(SignedApkMappingStrategy x) {
        this.signedApkMapping = x;
    }

    public SignedApkMappingStrategy getSignedApkMapping() {
        return this.signedApkMapping;
    }

    @DataBoundSetter
    public void setSkipZipalign(boolean x) {
        this.skipZipalign = x;
    }

    public boolean getSkipZipalign() {
        return this.skipZipalign;
    }

    @DataBoundSetter
    public void setArchiveSignedApks(boolean x) {
        this.archiveSignedApks = x;
    }

    public boolean getArchiveSignedApks() {
        return this.archiveSignedApks;
    }

    @DataBoundSetter
    public void setArchiveUnsignedApks(boolean x) {
        this.archiveUnsignedApks = x;
    }

    public boolean getArchiveUnsignedApks() {
        return this.archiveUnsignedApks;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        String[] globs;
        SigningComponents signingParams;
        if (this.isIntermediateFailure(run)) {
            listener.getLogger().println("[SignApksBuilder] skipping Sign APKs step because a previous step failed");
            return;
        }
        if (this.getEntries() != null && !this.getEntries().isEmpty()) {
            List<SignApksBuilder> newModelBuilders = SignApksBuilder.singleEntryBuildersFromEntriesOfBuilder(this);
            for (SignApksBuilder builder : newModelBuilders) {
                builder.perform(run, workspace, launcher, listener);
            }
            return;
        }
        ArgumentListBuilder command = new ArgumentListBuilder().add("echo").addQuoted("resolving effective environment");
        command.toWindowsCommand();
        if (!launcher.isUnix()) {
            command = command.toWindowsCommand();
        }
        Launcher.ProcStarter getEffectiveEnv = launcher.launch().pwd(workspace).cmds(command);
        try {
            getEffectiveEnv.join();
        }
        catch (Exception e) {
            listener.getLogger().println("[SignApksBuilder] error resolving effective script environment, but this does not necessarily fail your build:");
            e.printStackTrace(listener.getLogger());
        }
        String[] envLines = getEffectiveEnv.envs();
        EnvVars shellEnv = new EnvVars();
        for (String envVar : envLines) {
            shellEnv.addLine(envVar);
        }
        EnvVars env = new EnvVars();
        if (run instanceof AbstractBuild) {
            EnvVars runEnv = run.getEnvironment(listener);
            env.overrideExpandingAll((Map)runEnv);
            env.overrideExpandingAll(((AbstractBuild)run).getBuildVariables());
        }
        env.overrideAll((Map)shellEnv);
        FilePath builderDir = workspace.child(BUILDER_DIR);
        FilePath zipalignDir = builderDir.child("zipalign");
        zipalignDir.mkdirs();
        ZipalignTool zipalign = new ZipalignTool(env, workspace, listener.getLogger(), this.androidHome, this.zipalignPath);
        LinkedHashMap<CallSite, String> apksToArchive = new LinkedHashMap<CallSite, String>();
        StandardCertificateCredentials keyStoreCredential = this.getKeystore(this.getKeyStoreId(), (Item)run.getParent());
        try {
            signingParams = SigningComponents.fromCredentials(keyStoreCredential, this.getKeyAlias());
        }
        catch (GeneralSecurityException e) {
            String message = "Error reading signing key from key store credential " + keyStoreCredential.getId() + ": " + e.getMessage();
            listener.fatalError(message);
            e.printStackTrace(listener.getLogger());
            throw new AbortException(message);
        }
        TreeSet<FilePath> matchedApks = new TreeSet<FilePath>(Comparator.comparing(FilePath::getRemote));
        for (String glob : globs = SignApksBuilder.getSelectionGlobs(this.getApksToSign())) {
            FilePath[] globMatch = workspace.list(glob, builderDir.getName() + "/**");
            if (globMatch.length == 0) {
                throw new AbortException("No APKs in workspace matching " + glob);
            }
            matchedApks.addAll(Arrays.asList(globMatch));
        }
        String archivePrefix = BUILDER_DIR + "/" + this.getKeyStoreId() + "/" + this.getKeyAlias() + "/";
        if (this.signedApkMapping == null) {
            this.signedApkMapping = new SignedApkMappingStrategy.UnsignedApkSiblingMapping();
        }
        for (FilePath unsignedApk : matchedApks) {
            unsignedApk = unsignedApk.absolutize();
            FilePath alignedApk = zipalignDir.createTempFile("aligned-" + unsignedApk.getBaseName() + "-", ".apk");
            FilePath signedApk = this.signedApkMapping.destinationForUnsignedApk(unsignedApk, workspace);
            if (this.skipZipalign) {
                listener.getLogger().printf("[SignApksBuilder] skipping zipalign for unsigned apk %s", unsignedApk);
                alignedApk = unsignedApk;
            } else {
                ArgumentListBuilder zipalignCommand = zipalign.commandFor(unsignedApk.getRemote(), alignedApk.getRemote());
                listener.getLogger().printf("[SignApksBuilder] %s%n", zipalignCommand);
                int zipalignResult = launcher.launch().cmds(zipalignCommand).pwd(workspace).stdout(listener).stderr((OutputStream)listener.getLogger()).join();
                if (zipalignResult != 0) {
                    listener.fatalError("[SignApksBuilder] zipalign failed: exit code %d", new Object[]{zipalignResult});
                    throw new AbortException(String.format("zipalign failed on APK %s: exit code %d", unsignedApk, zipalignResult));
                }
            }
            String alignedRelName = this.relativeToWorkspace(workspace, alignedApk);
            String signedRelName = this.relativeToWorkspace(workspace, signedApk);
            if (!alignedApk.exists()) {
                throw new AbortException(String.format("aligned APK does not exist: %s", alignedRelName));
            }
            listener.getLogger().printf("[SignApksBuilder] signing APK %s%n", alignedRelName);
            FilePath signedParent = signedApk.getParent();
            if (signedParent == null) continue;
            if (!signedParent.exists()) {
                signedParent.mkdirs();
            }
            SignApkCallable signApk = new SignApkCallable(signingParams.key, signingParams.certChain, signingParams.v1SigName, signedApk.getRemote(), listener);
            alignedApk.act((FilePath.FileCallable)signApk);
            listener.getLogger().printf("[SignApksBuilder] signed APK %s%n", signedRelName);
            if (this.getArchiveUnsignedApks()) {
                listener.getLogger().printf("[SignApksBuilder] archiving unsigned APK %s%n", unsignedApk);
                apksToArchive.put((CallSite)((Object)(archivePrefix + unsignedApk.getName() + "/" + unsignedApk.getName())), this.relativeToWorkspace(workspace, unsignedApk));
            }
            if (!this.getArchiveSignedApks()) continue;
            listener.getLogger().printf("[SignApksBuilder] archiving signed APK %s%n", signedRelName);
            apksToArchive.put((CallSite)((Object)(archivePrefix + unsignedApk.getName() + "/" + signedApk.getName())), signedRelName);
        }
        listener.getLogger().println("[SignApksBuilder] finished signing APKs");
        if (apksToArchive.size() > 0) {
            run.pickArtifactManager().archive(workspace, launcher, BuildListenerAdapter.wrap((TaskListener)listener), apksToArchive);
        }
    }

    private String relativeToWorkspace(FilePath ws, FilePath path) throws IOException, InterruptedException {
        URI relUri = ws.toURI().relativize(path.toURI());
        return relUri.getPath().replaceFirst("/$", "");
    }

    private StandardCertificateCredentials getKeystore(String keyStoreName, Item item) {
        List creds = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, NO_REQUIREMENTS);
        return (StandardCertificateCredentials)CredentialsMatchers.firstOrNull((Iterable)creds, (CredentialsMatcher)CredentialsMatchers.withId((String)keyStoreName));
    }

    static class SignApkCallable
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final PrivateKey key;
        private final Certificate[] certChain;
        private final String v1SigName;
        private final String outputApk;
        private final TaskListener listener;

        SignApkCallable(PrivateKey key, Certificate[] certChain, String v1SigName, String outputApk, TaskListener listener) {
            this.key = key;
            this.certChain = certChain;
            this.v1SigName = v1SigName;
            this.outputApk = outputApk;
            this.listener = listener;
        }

        public Void invoke(File inputApkFile, VirtualChannel channel) throws IOException, InterruptedException {
            File outputApkFile = new File(this.outputApk);
            if (outputApkFile.isFile()) {
                this.listener.getLogger().printf("[SignApksBuilder] deleting previous signed APK %s%n", this.outputApk);
                if (!outputApkFile.delete()) {
                    throw new AbortException("failed to delete previous signed APK " + this.outputApk);
                }
            }
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(this.certChain.length);
            for (Certificate cert : this.certChain) {
                certs.add((X509Certificate)cert);
            }
            ApkSigner.SignerConfig signerConfig = new ApkSigner.SignerConfig.Builder(this.v1SigName, this.key, certs).build();
            List<ApkSigner.SignerConfig> signerConfigs = Collections.singletonList(signerConfig);
            ApkSigner.Builder signerBuilder = new ApkSigner.Builder(signerConfigs).setInputApk(inputApkFile).setOutputApk(outputApkFile).setOtherSignersSignaturesPreserved(false).setV1SigningEnabled(true).setV2SigningEnabled(true).setV3SigningEnabled(true);
            ApkSigner signer = signerBuilder.build();
            try {
                signer.sign();
            }
            catch (Exception e) {
                PrintWriter details = this.listener.fatalError("[SignApksBuilder] error signing APK %s", new Object[]{inputApkFile.getAbsolutePath()});
                e.printStackTrace(details);
                throw new AbortException("failed to sign APK " + inputApkFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
            }
            return null;
        }
    }

    @Extension
    @Symbol(value={"signAndroidApks"})
    public static final class SignApksDescriptor
    extends BuildStepDescriptor<Builder> {
        static final String DISPLAY_NAME = Messages.builderDisplayName();

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public SignApksDescriptor() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public ListBoxModel doFillKeyStoreIdItems(@AncestorInPath ItemGroup<?> parent) {
            if (parent == null) {
                parent = Jenkins.getInstance();
            }
            ListBoxModel items = new ListBoxModel();
            List keys = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (ItemGroup)parent, (Authentication)ACL.SYSTEM, NO_REQUIREMENTS);
            for (StandardCertificateCredentials key : keys) {
                String id = key.getId();
                String label = key.getDescription();
                if (StringUtils.isEmpty((String)label)) {
                    label = id;
                }
                items.add(label, id);
            }
            return items;
        }

        public FormValidation doCheckAlias(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckApksToSign(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            String[] globs;
            if (project == null) {
                return FormValidation.warning((String)Messages.validation_noProject());
            }
            project.checkPermission(Item.WORKSPACE);
            FilePath someWorkspace = project.getSomeWorkspace();
            if (someWorkspace == null) {
                return FormValidation.warning((String)Messages.validation_noWorkspace());
            }
            for (String glob : globs = SignApksBuilder.getSelectionGlobs(value)) {
                String msg;
                try {
                    msg = someWorkspace.validateAntFileMask(value, FilePath.VALIDATE_ANT_FILE_MASK_BOUND);
                }
                catch (InterruptedException e) {
                    msg = Messages.validation_globSearchLimitReached(FilePath.VALIDATE_ANT_FILE_MASK_BOUND);
                }
                if (msg == null) continue;
                return FormValidation.warning((String)msg);
            }
            return FormValidation.ok();
        }
    }
}

