// CHECKSTYLE:OFF

package jenkins.plugin.android.emulator;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code DefaultHomeLocationLocator.displayName}: {@code Default
     * (~/.android or %HOME%\.android)}.
     * 
     * @return
     *     {@code Default (~/.android or %HOME%\.android)}
     */
    public static String DefaultHomeLocationLocator_displayName() {
        return holder.format("DefaultHomeLocationLocator.displayName");
    }

    /**
     * Key {@code DefaultHomeLocationLocator.displayName}: {@code Default
     * (~/.android or %HOME%\.android)}.
     * 
     * @return
     *     {@code Default (~/.android or %HOME%\.android)}
     */
    public static Localizable _DefaultHomeLocationLocator_displayName() {
        return new Localizable(holder, "DefaultHomeLocationLocator.displayName");
    }

    /**
     * Key {@code noExecutableFound}: {@code Couldn''t find executable
     * "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Couldn''t find executable "{0}"}
     */
    public static String noExecutableFound(Object arg0) {
        return holder.format("noExecutableFound", arg0);
    }

    /**
     * Key {@code noExecutableFound}: {@code Couldn''t find executable
     * "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Couldn''t find executable "{0}"}
     */
    public static Localizable _noExecutableFound(Object arg0) {
        return new Localizable(holder, "noExecutableFound", arg0);
    }

    /**
     * Key {@code AndroidEmulatorBuild.wrongLocale}: {@code Locale is
     * incorrect}.
     * 
     * @return
     *     {@code Locale is incorrect}
     */
    public static String AndroidEmulatorBuild_wrongLocale() {
        return holder.format("AndroidEmulatorBuild.wrongLocale");
    }

    /**
     * Key {@code AndroidEmulatorBuild.wrongLocale}: {@code Locale is
     * incorrect}.
     * 
     * @return
     *     {@code Locale is incorrect}
     */
    public static Localizable _AndroidEmulatorBuild_wrongLocale() {
        return new Localizable(holder, "AndroidEmulatorBuild.wrongLocale");
    }

    /**
     * Key {@code noInstallationFound}: {@code No installation {0} found.
     * Please define one in manager Jenkins.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No installation {0} found. Please define one in manager
     *     Jenkins.}
     */
    public static String noInstallationFound(Object arg0) {
        return holder.format("noInstallationFound", arg0);
    }

    /**
     * Key {@code noInstallationFound}: {@code No installation {0} found.
     * Please define one in manager Jenkins.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No installation {0} found. Please define one in manager
     *     Jenkins.}
     */
    public static Localizable _noInstallationFound(Object arg0) {
        return new Localizable(holder, "noInstallationFound", arg0);
    }

    /**
     * Key {@code SystemTools.unsupported32bitArchitecture}: {@code NodeJS
     * does not have a 32bit package available for the current node}.
     * 
     * @return
     *     {@code NodeJS does not have a 32bit package available for the current
     *     node}
     */
    public static String SystemTools_unsupported32bitArchitecture() {
        return holder.format("SystemTools.unsupported32bitArchitecture");
    }

    /**
     * Key {@code SystemTools.unsupported32bitArchitecture}: {@code NodeJS
     * does not have a 32bit package available for the current node}.
     * 
     * @return
     *     {@code NodeJS does not have a 32bit package available for the current
     *     node}
     */
    public static Localizable _SystemTools_unsupported32bitArchitecture() {
        return new Localizable(holder, "SystemTools.unsupported32bitArchitecture");
    }

    /**
     * Key {@code AndroidEmulatorBuild.defaultLocale}: {@code Locale will
     * default to ''{0}'' if not specified}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Locale will default to ''{0}'' if not specified}
     */
    public static String AndroidEmulatorBuild_defaultLocale(Object arg0) {
        return holder.format("AndroidEmulatorBuild.defaultLocale", arg0);
    }

    /**
     * Key {@code AndroidEmulatorBuild.defaultLocale}: {@code Locale will
     * default to ''{0}'' if not specified}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Locale will default to ''{0}'' if not specified}
     */
    public static Localizable _AndroidEmulatorBuild_defaultLocale(Object arg0) {
        return new Localizable(holder, "AndroidEmulatorBuild.defaultLocale", arg0);
    }

    /**
     * Key {@code ExecutorHomeLocationLocator.displayName}: {@code Local to
     * the executor}.
     * 
     * @return
     *     {@code Local to the executor}
     */
    public static String ExecutorHomeLocationLocator_displayName() {
        return holder.format("ExecutorHomeLocationLocator.displayName");
    }

    /**
     * Key {@code ExecutorHomeLocationLocator.displayName}: {@code Local to
     * the executor}.
     * 
     * @return
     *     {@code Local to the executor}
     */
    public static Localizable _ExecutorHomeLocationLocator_displayName() {
        return new Localizable(holder, "ExecutorHomeLocationLocator.displayName");
    }

    /**
     * Key {@code AndroidEmulatorBuild.displayName}: {@code Run an Android
     * emulator during build}.
     * 
     * @return
     *     {@code Run an Android emulator during build}
     */
    public static String AndroidEmulatorBuild_displayName() {
        return holder.format("AndroidEmulatorBuild.displayName");
    }

    /**
     * Key {@code AndroidEmulatorBuild.displayName}: {@code Run an Android
     * emulator during build}.
     * 
     * @return
     *     {@code Run an Android emulator during build}
     */
    public static Localizable _AndroidEmulatorBuild_displayName() {
        return new Localizable(holder, "AndroidEmulatorBuild.displayName");
    }

    /**
     * Key {@code required}: {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static String required() {
        return holder.format("required");
    }

    /**
     * Key {@code required}: {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static Localizable _required() {
        return new Localizable(holder, "required");
    }

    /**
     * Key {@code nodeNotAvailable}: {@code Cannot get installation for node,
     * since it count be not online}.
     * 
     * @return
     *     {@code Cannot get installation for node, since it count be not online}
     */
    public static String nodeNotAvailable() {
        return holder.format("nodeNotAvailable");
    }

    /**
     * Key {@code nodeNotAvailable}: {@code Cannot get installation for node,
     * since it count be not online}.
     * 
     * @return
     *     {@code Cannot get installation for node, since it count be not online}
     */
    public static Localizable _nodeNotAvailable() {
        return new Localizable(holder, "nodeNotAvailable");
    }

    /**
     * Key {@code AndroidEmulatorBuild.sdCardTooSmall}: {@code SD card size
     * must be at least 9 MB}.
     * 
     * @return
     *     {@code SD card size must be at least 9 MB}
     */
    public static String AndroidEmulatorBuild_sdCardTooSmall() {
        return holder.format("AndroidEmulatorBuild.sdCardTooSmall");
    }

    /**
     * Key {@code AndroidEmulatorBuild.sdCardTooSmall}: {@code SD card size
     * must be at least 9 MB}.
     * 
     * @return
     *     {@code SD card size must be at least 9 MB}
     */
    public static Localizable _AndroidEmulatorBuild_sdCardTooSmall() {
        return new Localizable(holder, "AndroidEmulatorBuild.sdCardTooSmall");
    }

    /**
     * Key {@code AndroidSDKInstaller.displayName}: {@code Install from
     * dl.google.com/android/repository}.
     * 
     * @return
     *     {@code Install from dl.google.com/android/repository}
     */
    public static String AndroidSDKInstaller_displayName() {
        return holder.format("AndroidSDKInstaller.displayName");
    }

    /**
     * Key {@code AndroidSDKInstaller.displayName}: {@code Install from
     * dl.google.com/android/repository}.
     * 
     * @return
     *     {@code Install from dl.google.com/android/repository}
     */
    public static Localizable _AndroidSDKInstaller_displayName() {
        return new Localizable(holder, "AndroidSDKInstaller.displayName");
    }

    /**
     * Key {@code AndroidEmulatorBuild.wrongDensity}: {@code Expected a pair
     * integer greater than 0}.
     * 
     * @return
     *     {@code Expected a pair integer greater than 0}
     */
    public static String AndroidEmulatorBuild_wrongDensity() {
        return holder.format("AndroidEmulatorBuild.wrongDensity");
    }

    /**
     * Key {@code AndroidEmulatorBuild.wrongDensity}: {@code Expected a pair
     * integer greater than 0}.
     * 
     * @return
     *     {@code Expected a pair integer greater than 0}
     */
    public static Localizable _AndroidEmulatorBuild_wrongDensity() {
        return new Localizable(holder, "AndroidEmulatorBuild.wrongDensity");
    }

    /**
     * Key {@code AndroidSDKInstallation.displayName}: {@code Android Build
     * Tool}.
     * 
     * @return
     *     {@code Android Build Tool}
     */
    public static String AndroidSDKInstallation_displayName() {
        return holder.format("AndroidSDKInstallation.displayName");
    }

    /**
     * Key {@code AndroidSDKInstallation.displayName}: {@code Android Build
     * Tool}.
     * 
     * @return
     *     {@code Android Build Tool}
     */
    public static Localizable _AndroidSDKInstallation_displayName() {
        return new Localizable(holder, "AndroidSDKInstallation.displayName");
    }

    /**
     * Key {@code Platform.unknown}: {@code Unknown OS name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown OS name: {0}}
     */
    public static String Platform_unknown(Object arg0) {
        return holder.format("Platform.unknown", arg0);
    }

    /**
     * Key {@code Platform.unknown}: {@code Unknown OS name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown OS name: {0}}
     */
    public static Localizable _Platform_unknown(Object arg0) {
        return new Localizable(holder, "Platform.unknown", arg0);
    }

    /**
     * Key {@code JobHomeLocationLocator.displayName}: {@code Local to the
     * workspace}.
     * 
     * @return
     *     {@code Local to the workspace}
     */
    public static String JobHomeLocationLocator_displayName() {
        return holder.format("JobHomeLocationLocator.displayName");
    }

    /**
     * Key {@code JobHomeLocationLocator.displayName}: {@code Local to the
     * workspace}.
     * 
     * @return
     *     {@code Local to the workspace}
     */
    public static Localizable _JobHomeLocationLocator_displayName() {
        return new Localizable(holder, "JobHomeLocationLocator.displayName");
    }

    /**
     * Key {@code SystemTools.failureOnProperties}: {@code Error getting
     * system properties on remote Node}.
     * 
     * @return
     *     {@code Error getting system properties on remote Node}
     */
    public static String SystemTools_failureOnProperties() {
        return holder.format("SystemTools.failureOnProperties");
    }

    /**
     * Key {@code SystemTools.failureOnProperties}: {@code Error getting
     * system properties on remote Node}.
     * 
     * @return
     *     {@code Error getting system properties on remote Node}
     */
    public static Localizable _SystemTools_failureOnProperties() {
        return new Localizable(holder, "SystemTools.failureOnProperties");
    }

}
