// CHECKSTYLE:OFF

package hudson.plugins.android_emulator;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SENDING_COMMAND_TIMED_OUT}: {@code Aborting emulator
     * command ''{0}'' as it''s taking too long...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Aborting emulator command ''{0}'' as it''s taking too long...}
     */
    public static String SENDING_COMMAND_TIMED_OUT(Object arg0) {
        return holder.format("SENDING_COMMAND_TIMED_OUT", arg0);
    }

    /**
     * Key {@code SENDING_COMMAND_TIMED_OUT}: {@code Aborting emulator
     * command ''{0}'' as it''s taking too long...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Aborting emulator command ''{0}'' as it''s taking too long...}
     */
    public static Localizable _SENDING_COMMAND_TIMED_OUT(Object arg0) {
        return new Localizable(holder, "SENDING_COMMAND_TIMED_OUT", arg0);
    }

    /**
     * Key {@code REQUIRED_SDK_TOOLS_NOT_FOUND}: {@code Required tools not
     * found (<tt>adb</tt> etc.)}.
     * 
     * @return
     *     {@code Required tools not found (<tt>adb</tt> etc.)}
     */
    public static String REQUIRED_SDK_TOOLS_NOT_FOUND() {
        return holder.format("REQUIRED_SDK_TOOLS_NOT_FOUND");
    }

    /**
     * Key {@code REQUIRED_SDK_TOOLS_NOT_FOUND}: {@code Required tools not
     * found (<tt>adb</tt> etc.)}.
     * 
     * @return
     *     {@code Required tools not found (<tt>adb</tt> etc.)}
     */
    public static Localizable _REQUIRED_SDK_TOOLS_NOT_FOUND() {
        return new Localizable(holder, "REQUIRED_SDK_TOOLS_NOT_FOUND");
    }

    /**
     * Key {@code STARTING_MONKEY}: {@code Monkeying around with {0} (event
     * count: {1}, seed: {2}, categories: {3})...}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Monkeying around with {0} (event count: {1}, seed: {2},
     *     categories: {3})...}
     */
    public static String STARTING_MONKEY(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("STARTING_MONKEY", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code STARTING_MONKEY}: {@code Monkeying around with {0} (event
     * count: {1}, seed: {2}, categories: {3})...}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Monkeying around with {0} (event count: {1}, seed: {2},
     *     categories: {3})...}
     */
    public static Localizable _STARTING_MONKEY(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "STARTING_MONKEY", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code RUN_MONKEY}: {@code Run Android monkey tester}.
     * 
     * @return
     *     {@code Run Android monkey tester}
     */
    public static String RUN_MONKEY() {
        return holder.format("RUN_MONKEY");
    }

    /**
     * Key {@code RUN_MONKEY}: {@code Run Android monkey tester}.
     * 
     * @return
     *     {@code Run Android monkey tester}
     */
    public static Localizable _RUN_MONKEY() {
        return new Localizable(holder, "RUN_MONKEY");
    }

    /**
     * Key {@code CANNOT_START_EMULATOR}: {@code Cannot start Android
     * emulator: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot start Android emulator: {0}}
     */
    public static String CANNOT_START_EMULATOR(Object arg0) {
        return holder.format("CANNOT_START_EMULATOR", arg0);
    }

    /**
     * Key {@code CANNOT_START_EMULATOR}: {@code Cannot start Android
     * emulator: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot start Android emulator: {0}}
     */
    public static Localizable _CANNOT_START_EMULATOR(Object arg0) {
        return new Localizable(holder, "CANNOT_START_EMULATOR", arg0);
    }

    /**
     * Key {@code PROJECT_HAS_PLATFORM}: {@code Project file ''{0}'' requires
     * platform ''{1}''}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Project file ''{0}'' requires platform ''{1}''}
     */
    public static String PROJECT_HAS_PLATFORM(Object arg0, Object arg1) {
        return holder.format("PROJECT_HAS_PLATFORM", arg0, arg1);
    }

    /**
     * Key {@code PROJECT_HAS_PLATFORM}: {@code Project file ''{0}'' requires
     * platform ''{1}''}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Project file ''{0}'' requires platform ''{1}''}
     */
    public static Localizable _PROJECT_HAS_PLATFORM(Object arg0, Object arg1) {
        return new Localizable(holder, "PROJECT_HAS_PLATFORM", arg0, arg1);
    }

    /**
     * Key {@code MONKEY_RESULT_SUCCESS}: {@code Succeeded after {0} events}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Succeeded after {0} events}
     */
    public static String MONKEY_RESULT_SUCCESS(Object arg0) {
        return holder.format("MONKEY_RESULT_SUCCESS", arg0);
    }

    /**
     * Key {@code MONKEY_RESULT_SUCCESS}: {@code Succeeded after {0} events}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Succeeded after {0} events}
     */
    public static Localizable _MONKEY_RESULT_SUCCESS(Object arg0) {
        return new Localizable(holder, "MONKEY_RESULT_SUCCESS", arg0);
    }

    /**
     * Key {@code AVD_CREATION_ABORTED}: {@code AVD creation command failed
     * to complete normally}.
     * 
     * @return
     *     {@code AVD creation command failed to complete normally}
     */
    public static String AVD_CREATION_ABORTED() {
        return holder.format("AVD_CREATION_ABORTED");
    }

    /**
     * Key {@code AVD_CREATION_ABORTED}: {@code AVD creation command failed
     * to complete normally}.
     * 
     * @return
     *     {@code AVD creation command failed to complete normally}
     */
    public static Localizable _AVD_CREATION_ABORTED() {
        return new Localizable(holder, "AVD_CREATION_ABORTED");
    }

    /**
     * Key {@code SDK_NOT_SPECIFIED}: {@code Android SDK directory needs to
     * be specified in order to create an emulator}.
     * 
     * @return
     *     {@code Android SDK directory needs to be specified in order to create
     *     an emulator}
     */
    public static String SDK_NOT_SPECIFIED() {
        return holder.format("SDK_NOT_SPECIFIED");
    }

    /**
     * Key {@code SDK_NOT_SPECIFIED}: {@code Android SDK directory needs to
     * be specified in order to create an emulator}.
     * 
     * @return
     *     {@code Android SDK directory needs to be specified in order to create
     *     an emulator}
     */
    public static Localizable _SDK_NOT_SPECIFIED() {
        return new Localizable(holder, "SDK_NOT_SPECIFIED");
    }

    /**
     * Key {@code AVD_CONFIG_NOT_READABLE}: {@code Failed to parse AVD config
     * file}.
     * 
     * @return
     *     {@code Failed to parse AVD config file}
     */
    public static String AVD_CONFIG_NOT_READABLE() {
        return holder.format("AVD_CONFIG_NOT_READABLE");
    }

    /**
     * Key {@code AVD_CONFIG_NOT_READABLE}: {@code Failed to parse AVD config
     * file}.
     * 
     * @return
     *     {@code Failed to parse AVD config file}
     */
    public static Localizable _AVD_CONFIG_NOT_READABLE() {
        return new Localizable(holder, "AVD_CONFIG_NOT_READABLE");
    }

    /**
     * Key {@code FAILED_TO_DELETE_FILE}: {@code Failed to delete file or
     * directory: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to delete file or directory: {0}}
     */
    public static String FAILED_TO_DELETE_FILE(Object arg0) {
        return holder.format("FAILED_TO_DELETE_FILE", arg0);
    }

    /**
     * Key {@code FAILED_TO_DELETE_FILE}: {@code Failed to delete file or
     * directory: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to delete file or directory: {0}}
     */
    public static Localizable _FAILED_TO_DELETE_FILE(Object arg0) {
        return new Localizable(holder, "FAILED_TO_DELETE_FILE", arg0);
    }

    /**
     * Key {@code CORE_PROCESS_DID_NOT_START}: {@code System did not appear
     * to become ready; trying anyway...}.
     * 
     * @return
     *     {@code System did not appear to become ready; trying anyway...}
     */
    public static String CORE_PROCESS_DID_NOT_START() {
        return holder.format("CORE_PROCESS_DID_NOT_START");
    }

    /**
     * Key {@code CORE_PROCESS_DID_NOT_START}: {@code System did not appear
     * to become ready; trying anyway...}.
     * 
     * @return
     *     {@code System did not appear to become ready; trying anyway...}
     */
    public static Localizable _CORE_PROCESS_DID_NOT_START() {
        return new Localizable(holder, "CORE_PROCESS_DID_NOT_START");
    }

    /**
     * Key {@code PLATFORM_NOT_FOUND}: {@code Cannot find desired platform
     * ''{0}''; are you sure it is installed?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find desired platform ''{0}''; are you sure it is
     *     installed?}
     */
    public static String PLATFORM_NOT_FOUND(Object arg0) {
        return holder.format("PLATFORM_NOT_FOUND", arg0);
    }

    /**
     * Key {@code PLATFORM_NOT_FOUND}: {@code Cannot find desired platform
     * ''{0}''; are you sure it is installed?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find desired platform ''{0}''; are you sure it is
     *     installed?}
     */
    public static Localizable _PLATFORM_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "PLATFORM_NOT_FOUND", arg0);
    }

    /**
     * Key {@code SDK_NOT_FOUND}: {@code Cannot find Android SDK at ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find Android SDK at ''{0}''}
     */
    public static String SDK_NOT_FOUND(Object arg0) {
        return holder.format("SDK_NOT_FOUND", arg0);
    }

    /**
     * Key {@code SDK_NOT_FOUND}: {@code Cannot find Android SDK at ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find Android SDK at ''{0}''}
     */
    public static Localizable _SDK_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "SDK_NOT_FOUND", arg0);
    }

    /**
     * Key {@code EMULATOR_IS_READY}: {@code Emulator is ready for use (took
     * {0} seconds)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Emulator is ready for use (took {0} seconds)}
     */
    public static String EMULATOR_IS_READY(Object arg0) {
        return holder.format("EMULATOR_IS_READY", arg0);
    }

    /**
     * Key {@code EMULATOR_IS_READY}: {@code Emulator is ready for use (took
     * {0} seconds)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Emulator is ready for use (took {0} seconds)}
     */
    public static Localizable _EMULATOR_IS_READY(Object arg0) {
        return new Localizable(holder, "EMULATOR_IS_READY", arg0);
    }

    /**
     * Key {@code SCREEN_DENSITY_NOT_NUMERIC}: {@code Screen density should
     * be a number}.
     * 
     * @return
     *     {@code Screen density should be a number}
     */
    public static String SCREEN_DENSITY_NOT_NUMERIC() {
        return holder.format("SCREEN_DENSITY_NOT_NUMERIC");
    }

    /**
     * Key {@code SCREEN_DENSITY_NOT_NUMERIC}: {@code Screen density should
     * be a number}.
     * 
     * @return
     *     {@code Screen density should be a number}
     */
    public static Localizable _SCREEN_DENSITY_NOT_NUMERIC() {
        return new Localizable(holder, "SCREEN_DENSITY_NOT_NUMERIC");
    }

    /**
     * Key {@code BOOT_COMPLETION_TIMED_OUT}: {@code Timed-out after waiting
     * {0} seconds for emulator}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Timed-out after waiting {0} seconds for emulator}
     */
    public static String BOOT_COMPLETION_TIMED_OUT(Object arg0) {
        return holder.format("BOOT_COMPLETION_TIMED_OUT", arg0);
    }

    /**
     * Key {@code BOOT_COMPLETION_TIMED_OUT}: {@code Timed-out after waiting
     * {0} seconds for emulator}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Timed-out after waiting {0} seconds for emulator}
     */
    public static Localizable _BOOT_COMPLETION_TIMED_OUT(Object arg0) {
        return new Localizable(holder, "BOOT_COMPLETION_TIMED_OUT", arg0);
    }

    /**
     * Key {@code JOB_DESCRIPTION}: {@code Run an Android emulator during
     * build (Deprecated)}.
     * 
     * @return
     *     {@code Run an Android emulator during build (Deprecated)}
     */
    public static String JOB_DESCRIPTION() {
        return holder.format("JOB_DESCRIPTION");
    }

    /**
     * Key {@code JOB_DESCRIPTION}: {@code Run an Android emulator during
     * build (Deprecated)}.
     * 
     * @return
     *     {@code Run an Android emulator during build (Deprecated)}
     */
    public static Localizable _JOB_DESCRIPTION() {
        return new Localizable(holder, "JOB_DESCRIPTION");
    }

    /**
     * Key {@code AVD_CONFIG_NOT_WRITEABLE}: {@code Failed to save AVD config
     * file}.
     * 
     * @return
     *     {@code Failed to save AVD config file}
     */
    public static String AVD_CONFIG_NOT_WRITEABLE() {
        return holder.format("AVD_CONFIG_NOT_WRITEABLE");
    }

    /**
     * Key {@code AVD_CONFIG_NOT_WRITEABLE}: {@code Failed to save AVD config
     * file}.
     * 
     * @return
     *     {@code Failed to save AVD config file}
     */
    public static Localizable _AVD_CONFIG_NOT_WRITEABLE() {
        return new Localizable(holder, "AVD_CONFIG_NOT_WRITEABLE");
    }

    /**
     * Key {@code PLATFORM_INSTALL_REQUIRED}: {@code The configured Android
     * platform needs to be installed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The configured Android platform needs to be installed: {0}}
     */
    public static String PLATFORM_INSTALL_REQUIRED(Object arg0) {
        return holder.format("PLATFORM_INSTALL_REQUIRED", arg0);
    }

    /**
     * Key {@code PLATFORM_INSTALL_REQUIRED}: {@code The configured Android
     * platform needs to be installed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The configured Android platform needs to be installed: {0}}
     */
    public static Localizable _PLATFORM_INSTALL_REQUIRED(Object arg0) {
        return new Localizable(holder, "PLATFORM_INSTALL_REQUIRED", arg0);
    }

    /**
     * Key {@code EMULATOR_STOPPED_DURING_BOOT}: {@code Emulator was shut
     * down before it finished booting}.
     * 
     * @return
     *     {@code Emulator was shut down before it finished booting}
     */
    public static String EMULATOR_STOPPED_DURING_BOOT() {
        return holder.format("EMULATOR_STOPPED_DURING_BOOT");
    }

    /**
     * Key {@code EMULATOR_STOPPED_DURING_BOOT}: {@code Emulator was shut
     * down before it finished booting}.
     * 
     * @return
     *     {@code Emulator was shut down before it finished booting}
     */
    public static Localizable _EMULATOR_STOPPED_DURING_BOOT() {
        return new Localizable(holder, "EMULATOR_STOPPED_DURING_BOOT");
    }

    /**
     * Key {@code STARTING_EMULATOR}: {@code Starting Android emulator}.
     * 
     * @return
     *     {@code Starting Android emulator}
     */
    public static String STARTING_EMULATOR() {
        return holder.format("STARTING_EMULATOR");
    }

    /**
     * Key {@code STARTING_EMULATOR}: {@code Starting Android emulator}.
     * 
     * @return
     *     {@code Starting Android emulator}
     */
    public static Localizable _STARTING_EMULATOR() {
        return new Localizable(holder, "STARTING_EMULATOR");
    }

    /**
     * Key {@code ABI_REQUIRED}: {@code The Android SDKs ''avdmanager create
     * avd'' command requires the ABI to be specified.}.
     * 
     * @return
     *     {@code The Android SDKs ''avdmanager create avd'' command requires the
     *     ABI to be specified.}
     */
    public static String ABI_REQUIRED() {
        return holder.format("ABI_REQUIRED");
    }

    /**
     * Key {@code ABI_REQUIRED}: {@code The Android SDKs ''avdmanager create
     * avd'' command requires the ABI to be specified.}.
     * 
     * @return
     *     {@code The Android SDKs ''avdmanager create avd'' command requires the
     *     ABI to be specified.}
     */
    public static Localizable _ABI_REQUIRED() {
        return new Localizable(holder, "ABI_REQUIRED");
    }

    /**
     * Key {@code MONKEY_IGNORING_RESULT}: {@code Detected failures in monkey
     * output, but won''t change the build result}.
     * 
     * @return
     *     {@code Detected failures in monkey output, but won''t change the build
     *     result}
     */
    public static String MONKEY_IGNORING_RESULT() {
        return holder.format("MONKEY_IGNORING_RESULT");
    }

    /**
     * Key {@code MONKEY_IGNORING_RESULT}: {@code Detected failures in monkey
     * output, but won''t change the build result}.
     * 
     * @return
     *     {@code Detected failures in monkey output, but won''t change the build
     *     result}
     */
    public static Localizable _MONKEY_IGNORING_RESULT() {
        return new Localizable(holder, "MONKEY_IGNORING_RESULT");
    }

    /**
     * Key {@code SDK_PLATFORMS_EMPTY}: {@code SDK platforms directory
     * appears to be empty.  See inline help for info}.
     * 
     * @return
     *     {@code SDK platforms directory appears to be empty.  See inline help
     *     for info}
     */
    public static String SDK_PLATFORMS_EMPTY() {
        return holder.format("SDK_PLATFORMS_EMPTY");
    }

    /**
     * Key {@code SDK_PLATFORMS_EMPTY}: {@code SDK platforms directory
     * appears to be empty.  See inline help for info}.
     * 
     * @return
     *     {@code SDK platforms directory appears to be empty.  See inline help
     *     for info}
     */
    public static Localizable _SDK_PLATFORMS_EMPTY() {
        return new Localizable(holder, "SDK_PLATFORMS_EMPTY");
    }

    /**
     * Key {@code USING_SDK}: {@code Using Android SDK: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Using Android SDK: {0}}
     */
    public static String USING_SDK(Object arg0) {
        return holder.format("USING_SDK", arg0);
    }

    /**
     * Key {@code USING_SDK}: {@code Using Android SDK: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Using Android SDK: {0}}
     */
    public static Localizable _USING_SDK(Object arg0) {
        return new Localizable(holder, "USING_SDK", arg0);
    }

    /**
     * Key {@code INSTALLING_SDK}: {@code No Android SDK found; let''s
     * install it automatically...}.
     * 
     * @return
     *     {@code No Android SDK found; let''s install it automatically...}
     */
    public static String INSTALLING_SDK() {
        return holder.format("INSTALLING_SDK");
    }

    /**
     * Key {@code INSTALLING_SDK}: {@code No Android SDK found; let''s
     * install it automatically...}.
     * 
     * @return
     *     {@code No Android SDK found; let''s install it automatically...}
     */
    public static Localizable _INSTALLING_SDK() {
        return new Localizable(holder, "INSTALLING_SDK");
    }

    /**
     * Key {@code SDK_DOWNLOAD_FAILED}: {@code Failed to download Android
     * SDK}.
     * 
     * @return
     *     {@code Failed to download Android SDK}
     */
    public static String SDK_DOWNLOAD_FAILED() {
        return holder.format("SDK_DOWNLOAD_FAILED");
    }

    /**
     * Key {@code SDK_DOWNLOAD_FAILED}: {@code Failed to download Android
     * SDK}.
     * 
     * @return
     *     {@code Failed to download Android SDK}
     */
    public static Localizable _SDK_DOWNLOAD_FAILED() {
        return new Localizable(holder, "SDK_DOWNLOAD_FAILED");
    }

    /**
     * Key {@code EMULATOR_CONFIGURATION_BAD}: {@code Unrecognised Android
     * emulator configuration: ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unrecognised Android emulator configuration: ''{0}''}
     */
    public static String EMULATOR_CONFIGURATION_BAD(Object arg0) {
        return holder.format("EMULATOR_CONFIGURATION_BAD", arg0);
    }

    /**
     * Key {@code EMULATOR_CONFIGURATION_BAD}: {@code Unrecognised Android
     * emulator configuration: ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unrecognised Android emulator configuration: ''{0}''}
     */
    public static Localizable _EMULATOR_CONFIGURATION_BAD(Object arg0) {
        return new Localizable(holder, "EMULATOR_CONFIGURATION_BAD", arg0);
    }

    /**
     * Key {@code LOG_CREATING_SNAPSHOT}: {@code Creating snapshot...}.
     * 
     * @return
     *     {@code Creating snapshot...}
     */
    public static String LOG_CREATING_SNAPSHOT() {
        return holder.format("LOG_CREATING_SNAPSHOT");
    }

    /**
     * Key {@code LOG_CREATING_SNAPSHOT}: {@code Creating snapshot...}.
     * 
     * @return
     *     {@code Creating snapshot...}
     */
    public static Localizable _LOG_CREATING_SNAPSHOT() {
        return new Localizable(holder, "LOG_CREATING_SNAPSHOT");
    }

    /**
     * Key {@code WAITING_FOR_EMULATOR}: {@code Waiting for the configured
     * Android emulator to become available}.
     * 
     * @return
     *     {@code Waiting for the configured Android emulator to become
     *     available}
     */
    public static String WAITING_FOR_EMULATOR() {
        return holder.format("WAITING_FOR_EMULATOR");
    }

    /**
     * Key {@code WAITING_FOR_EMULATOR}: {@code Waiting for the configured
     * Android emulator to become available}.
     * 
     * @return
     *     {@code Waiting for the configured Android emulator to become
     *     available}
     */
    public static Localizable _WAITING_FOR_EMULATOR() {
        return new Localizable(holder, "WAITING_FOR_EMULATOR");
    }

    /**
     * Key {@code CREATE_PROJECT_BUILD_FILES}: {@code Create Android Ant
     * build files}.
     * 
     * @return
     *     {@code Create Android Ant build files}
     */
    public static String CREATE_PROJECT_BUILD_FILES() {
        return holder.format("CREATE_PROJECT_BUILD_FILES");
    }

    /**
     * Key {@code CREATE_PROJECT_BUILD_FILES}: {@code Create Android Ant
     * build files}.
     * 
     * @return
     *     {@code Create Android Ant build files}
     */
    public static Localizable _CREATE_PROJECT_BUILD_FILES() {
        return new Localizable(holder, "CREATE_PROJECT_BUILD_FILES");
    }

    /**
     * Key {@code PROJECT_TYPE_TEST}: {@code test}.
     * 
     * @return
     *     {@code test}
     */
    public static String PROJECT_TYPE_TEST() {
        return holder.format("PROJECT_TYPE_TEST");
    }

    /**
     * Key {@code PROJECT_TYPE_TEST}: {@code test}.
     * 
     * @return
     *     {@code test}
     */
    public static Localizable _PROJECT_TYPE_TEST() {
        return new Localizable(holder, "PROJECT_TYPE_TEST");
    }

    /**
     * Key {@code CREATING_BUILD_FILES}: {@code Creating build files for {0}
     * project at ''{1}''...}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Creating build files for {0} project at ''{1}''...}
     */
    public static String CREATING_BUILD_FILES(Object arg0, Object arg1) {
        return holder.format("CREATING_BUILD_FILES", arg0, arg1);
    }

    /**
     * Key {@code CREATING_BUILD_FILES}: {@code Creating build files for {0}
     * project at ''{1}''...}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Creating build files for {0} project at ''{1}''...}
     */
    public static Localizable _CREATING_BUILD_FILES(Object arg0, Object arg1) {
        return new Localizable(holder, "CREATING_BUILD_FILES", arg0, arg1);
    }

    /**
     * Key {@code PACKAGE_ID_NOT_SPECIFIED}: {@code No package ID was
     * specified to be uninstalled}.
     * 
     * @return
     *     {@code No package ID was specified to be uninstalled}
     */
    public static String PACKAGE_ID_NOT_SPECIFIED() {
        return holder.format("PACKAGE_ID_NOT_SPECIFIED");
    }

    /**
     * Key {@code PACKAGE_ID_NOT_SPECIFIED}: {@code No package ID was
     * specified to be uninstalled}.
     * 
     * @return
     *     {@code No package ID was specified to be uninstalled}
     */
    public static Localizable _PACKAGE_ID_NOT_SPECIFIED() {
        return new Localizable(holder, "PACKAGE_ID_NOT_SPECIFIED");
    }

    /**
     * Key {@code SDK_PLATFORM_STRING_UNRECOGNISED}: {@code Format of given
     * platform looks incorrect: ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Format of given platform looks incorrect: ''{0}''}
     */
    public static String SDK_PLATFORM_STRING_UNRECOGNISED(Object arg0) {
        return holder.format("SDK_PLATFORM_STRING_UNRECOGNISED", arg0);
    }

    /**
     * Key {@code SDK_PLATFORM_STRING_UNRECOGNISED}: {@code Format of given
     * platform looks incorrect: ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Format of given platform looks incorrect: ''{0}''}
     */
    public static Localizable _SDK_PLATFORM_STRING_UNRECOGNISED(Object arg0) {
        return new Localizable(holder, "SDK_PLATFORM_STRING_UNRECOGNISED", arg0);
    }

    /**
     * Key {@code UNINSTALLING_APK}: {@code Uninstalling APK with package ID
     * ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Uninstalling APK with package ID ''{0}''}
     */
    public static String UNINSTALLING_APK(Object arg0) {
        return holder.format("UNINSTALLING_APK", arg0);
    }

    /**
     * Key {@code UNINSTALLING_APK}: {@code Uninstalling APK with package ID
     * ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Uninstalling APK with package ID ''{0}''}
     */
    public static Localizable _UNINSTALLING_APK(Object arg0) {
        return new Localizable(holder, "UNINSTALLING_APK", arg0);
    }

    /**
     * Key {@code SDK_DETERMINATION_FAILED}: {@code Determination of SDK root
     * failed}.
     * 
     * @return
     *     {@code Determination of SDK root failed}
     */
    public static String SDK_DETERMINATION_FAILED() {
        return holder.format("SDK_DETERMINATION_FAILED");
    }

    /**
     * Key {@code SDK_DETERMINATION_FAILED}: {@code Determination of SDK root
     * failed}.
     * 
     * @return
     *     {@code Determination of SDK root failed}
     */
    public static Localizable _SDK_DETERMINATION_FAILED() {
        return new Localizable(holder, "SDK_DETERMINATION_FAILED");
    }

    /**
     * Key {@code STARTING_EMULATOR_FROM_SNAPSHOT}: {@code Starting Android
     * emulator from snapshot}.
     * 
     * @return
     *     {@code Starting Android emulator from snapshot}
     */
    public static String STARTING_EMULATOR_FROM_SNAPSHOT() {
        return holder.format("STARTING_EMULATOR_FROM_SNAPSHOT");
    }

    /**
     * Key {@code STARTING_EMULATOR_FROM_SNAPSHOT}: {@code Starting Android
     * emulator from snapshot}.
     * 
     * @return
     *     {@code Starting Android emulator from snapshot}
     */
    public static Localizable _STARTING_EMULATOR_FROM_SNAPSHOT() {
        return new Localizable(holder, "STARTING_EMULATOR_FROM_SNAPSHOT");
    }

    /**
     * Key {@code INSTALLING_REQUIRED_COMPONENTS}: {@code Going to install
     * required Android SDK components...}.
     * 
     * @return
     *     {@code Going to install required Android SDK components...}
     */
    public static String INSTALLING_REQUIRED_COMPONENTS() {
        return holder.format("INSTALLING_REQUIRED_COMPONENTS");
    }

    /**
     * Key {@code INSTALLING_REQUIRED_COMPONENTS}: {@code Going to install
     * required Android SDK components...}.
     * 
     * @return
     *     {@code Going to install required Android SDK components...}
     */
    public static Localizable _INSTALLING_REQUIRED_COMPONENTS() {
        return new Localizable(holder, "INSTALLING_REQUIRED_COMPONENTS");
    }

    /**
     * Key {@code MONKEY_RESULT_ANR}: {@code Stopped responding after {0} of
     * {1} events}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stopped responding after {0} of {1} events}
     */
    public static String MONKEY_RESULT_ANR(Object arg0, Object arg1) {
        return holder.format("MONKEY_RESULT_ANR", arg0, arg1);
    }

    /**
     * Key {@code MONKEY_RESULT_ANR}: {@code Stopped responding after {0} of
     * {1} events}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stopped responding after {0} of {1} events}
     */
    public static Localizable _MONKEY_RESULT_ANR(Object arg0, Object arg1) {
        return new Localizable(holder, "MONKEY_RESULT_ANR", arg0, arg1);
    }

    /**
     * Key {@code NO_EXECUTORS_ON_NODE}: {@code Can''t run build on node, as
     * there seems to be no executor available}.
     * 
     * @return
     *     {@code Can''t run build on node, as there seems to be no executor
     *     available}
     */
    public static String NO_EXECUTORS_ON_NODE() {
        return holder.format("NO_EXECUTORS_ON_NODE");
    }

    /**
     * Key {@code NO_EXECUTORS_ON_NODE}: {@code Can''t run build on node, as
     * there seems to be no executor available}.
     * 
     * @return
     *     {@code Can''t run build on node, as there seems to be no executor
     *     available}
     */
    public static Localizable _NO_EXECUTORS_ON_NODE() {
        return new Localizable(holder, "NO_EXECUTORS_ON_NODE");
    }

    /**
     * Key {@code EMULATOR_STATE_REPORT}: {@code Emulator reported that the
     * startup process is ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Emulator reported that the startup process is ''{0}''}
     */
    public static String EMULATOR_STATE_REPORT(Object arg0) {
        return holder.format("EMULATOR_STATE_REPORT", arg0);
    }

    /**
     * Key {@code EMULATOR_STATE_REPORT}: {@code Emulator reported that the
     * startup process is ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Emulator reported that the startup process is ''{0}''}
     */
    public static Localizable _EMULATOR_STATE_REPORT(Object arg0) {
        return new Localizable(holder, "EMULATOR_STATE_REPORT", arg0);
    }

    /**
     * Key {@code SCREEN_DENSITY_REQUIRED}: {@code Screen density is
     * required}.
     * 
     * @return
     *     {@code Screen density is required}
     */
    public static String SCREEN_DENSITY_REQUIRED() {
        return holder.format("SCREEN_DENSITY_REQUIRED");
    }

    /**
     * Key {@code SCREEN_DENSITY_REQUIRED}: {@code Screen density is
     * required}.
     * 
     * @return
     *     {@code Screen density is required}
     */
    public static Localizable _SCREEN_DENSITY_REQUIRED() {
        return new Localizable(holder, "SCREEN_DENSITY_REQUIRED");
    }

    /**
     * Key {@code AVD_DOES_NOT_EXIST}: {@code Could not start AVD ''{0}'', as
     * it could not be found at ''{1}''}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not start AVD ''{0}'', as it could not be found at
     *     ''{1}''}
     */
    public static String AVD_DOES_NOT_EXIST(Object arg0, Object arg1) {
        return holder.format("AVD_DOES_NOT_EXIST", arg0, arg1);
    }

    /**
     * Key {@code AVD_DOES_NOT_EXIST}: {@code Could not start AVD ''{0}'', as
     * it could not be found at ''{1}''}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not start AVD ''{0}'', as it could not be found at
     *     ''{1}''}
     */
    public static Localizable _AVD_DOES_NOT_EXIST(Object arg0, Object arg1) {
        return new Localizable(holder, "AVD_DOES_NOT_EXIST", arg0, arg1);
    }

    /**
     * Key {@code MORE_THAN_ONE_ABI}: {@code There is more than one system
     * image defined for platform ''{0}''.
     * Pick an image to use and set it in
     * the ''Target ABI'' config field.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There is more than one system image defined for platform
     *     ''{0}''.
     *     Pick an image to use and set it in the ''Target ABI'' config
     *     field.}
     */
    public static String MORE_THAN_ONE_ABI(Object arg0) {
        return holder.format("MORE_THAN_ONE_ABI", arg0);
    }

    /**
     * Key {@code MORE_THAN_ONE_ABI}: {@code There is more than one system
     * image defined for platform ''{0}''.
     * Pick an image to use and set it in
     * the ''Target ABI'' config field.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There is more than one system image defined for platform
     *     ''{0}''.
     *     Pick an image to use and set it in the ''Target ABI'' config
     *     field.}
     */
    public static Localizable _MORE_THAN_ONE_ABI(Object arg0) {
        return new Localizable(holder, "MORE_THAN_ONE_ABI", arg0);
    }

    /**
     * Key {@code INVALID_TARGET_ABI}: {@code Unrecognised target ABI}.
     * 
     * @return
     *     {@code Unrecognised target ABI}
     */
    public static String INVALID_TARGET_ABI() {
        return holder.format("INVALID_TARGET_ABI");
    }

    /**
     * Key {@code INVALID_TARGET_ABI}: {@code Unrecognised target ABI}.
     * 
     * @return
     *     {@code Unrecognised target ABI}
     */
    public static Localizable _INVALID_TARGET_ABI() {
        return new Localizable(holder, "INVALID_TARGET_ABI");
    }

    /**
     * Key {@code ENSURING_PLATFORMS_INSTALLED}: {@code Ensuring platform(s)
     * are installed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Ensuring platform(s) are installed: {0}}
     */
    public static String ENSURING_PLATFORMS_INSTALLED(Object arg0) {
        return holder.format("ENSURING_PLATFORMS_INSTALLED", arg0);
    }

    /**
     * Key {@code ENSURING_PLATFORMS_INSTALLED}: {@code Ensuring platform(s)
     * are installed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Ensuring platform(s) are installed: {0}}
     */
    public static Localizable _ENSURING_PLATFORMS_INSTALLED(Object arg0) {
        return new Localizable(holder, "ENSURING_PLATFORMS_INSTALLED", arg0);
    }

    /**
     * Key {@code APK_NOT_FOUND}: {@code Could not find APK file ''{0}'' to
     * be installed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find APK file ''{0}'' to be installed}
     */
    public static String APK_NOT_FOUND(Object arg0) {
        return holder.format("APK_NOT_FOUND", arg0);
    }

    /**
     * Key {@code APK_NOT_FOUND}: {@code Could not find APK file ''{0}'' to
     * be installed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find APK file ''{0}'' to be installed}
     */
    public static Localizable _APK_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "APK_NOT_FOUND", arg0);
    }

    /**
     * Key {@code BUILD_RESULT_IGNORE}: {@code Do nothing}.
     * 
     * @return
     *     {@code Do nothing}
     */
    public static String BUILD_RESULT_IGNORE() {
        return holder.format("BUILD_RESULT_IGNORE");
    }

    /**
     * Key {@code BUILD_RESULT_IGNORE}: {@code Do nothing}.
     * 
     * @return
     *     {@code Do nothing}
     */
    public static Localizable _BUILD_RESULT_IGNORE() {
        return new Localizable(holder, "BUILD_RESULT_IGNORE");
    }

    /**
     * Key {@code USING_PATH}: {@code [none found; relying on PATH]}.
     * 
     * @return
     *     {@code [none found; relying on PATH]}
     */
    public static String USING_PATH() {
        return holder.format("USING_PATH");
    }

    /**
     * Key {@code USING_PATH}: {@code [none found; relying on PATH]}.
     * 
     * @return
     *     {@code [none found; relying on PATH]}
     */
    public static Localizable _USING_PATH() {
        return new Localizable(holder, "USING_PATH");
    }

    /**
     * Key {@code EMULATOR_PAUSED_SNAPSHOT}: {@code Creating snapshot...}.
     * 
     * @return
     *     {@code Creating snapshot...}
     */
    public static String EMULATOR_PAUSED_SNAPSHOT() {
        return holder.format("EMULATOR_PAUSED_SNAPSHOT");
    }

    /**
     * Key {@code EMULATOR_PAUSED_SNAPSHOT}: {@code Creating snapshot...}.
     * 
     * @return
     *     {@code Creating snapshot...}
     */
    public static Localizable _EMULATOR_PAUSED_SNAPSHOT() {
        return new Localizable(holder, "EMULATOR_PAUSED_SNAPSHOT");
    }

    /**
     * Key {@code INSTALLING_APK}: {@code Installing APK file ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing APK file ''{0}''}
     */
    public static String INSTALLING_APK(Object arg0) {
        return holder.format("INSTALLING_APK", arg0);
    }

    /**
     * Key {@code INSTALLING_APK}: {@code Installing APK file ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing APK file ''{0}''}
     */
    public static Localizable _INSTALLING_APK(Object arg0) {
        return new Localizable(holder, "INSTALLING_APK", arg0);
    }

    /**
     * Key {@code MONKEY_SETTING_RESULT}: {@code Detected failures in monkey
     * output; setting build result to {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Detected failures in monkey output; setting build result to
     *     {0}}
     */
    public static String MONKEY_SETTING_RESULT(Object arg0) {
        return holder.format("MONKEY_SETTING_RESULT", arg0);
    }

    /**
     * Key {@code MONKEY_SETTING_RESULT}: {@code Detected failures in monkey
     * output; setting build result to {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Detected failures in monkey output; setting build result to
     *     {0}}
     */
    public static Localizable _MONKEY_SETTING_RESULT(Object arg0) {
        return new Localizable(holder, "MONKEY_SETTING_RESULT", arg0);
    }

    /**
     * Key {@code LOADING_SNAPSHOT}: {@code Loading snapshot ''{0}'' into
     * emulator on port {1}...}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Loading snapshot ''{0}'' into emulator on port {1}...}
     */
    public static String LOADING_SNAPSHOT(Object arg0, Object arg1) {
        return holder.format("LOADING_SNAPSHOT", arg0, arg1);
    }

    /**
     * Key {@code LOADING_SNAPSHOT}: {@code Loading snapshot ''{0}'' into
     * emulator on port {1}...}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Loading snapshot ''{0}'' into emulator on port {1}...}
     */
    public static Localizable _LOADING_SNAPSHOT(Object arg0, Object arg1) {
        return new Localizable(holder, "LOADING_SNAPSHOT", arg0, arg1);
    }

    /**
     * Key {@code SAVING_SNAPSHOT}: {@code Saving snapshot ''{0}'' for
     * emulator on port {1}...}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Saving snapshot ''{0}'' for emulator on port {1}...}
     */
    public static String SAVING_SNAPSHOT(Object arg0, Object arg1) {
        return holder.format("SAVING_SNAPSHOT", arg0, arg1);
    }

    /**
     * Key {@code SAVING_SNAPSHOT}: {@code Saving snapshot ''{0}'' for
     * emulator on port {1}...}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Saving snapshot ''{0}'' for emulator on port {1}...}
     */
    public static Localizable _SAVING_SNAPSHOT(Object arg0, Object arg1) {
        return new Localizable(holder, "SAVING_SNAPSHOT", arg0, arg1);
    }

    /**
     * Key {@code PUBLISH_MONKEY_OUTPUT}: {@code Publish Android monkey
     * tester result}.
     * 
     * @return
     *     {@code Publish Android monkey tester result}
     */
    public static String PUBLISH_MONKEY_OUTPUT() {
        return holder.format("PUBLISH_MONKEY_OUTPUT");
    }

    /**
     * Key {@code PUBLISH_MONKEY_OUTPUT}: {@code Publish Android monkey
     * tester result}.
     * 
     * @return
     *     {@code Publish Android monkey tester result}
     */
    public static Localizable _PUBLISH_MONKEY_OUTPUT() {
        return new Localizable(holder, "PUBLISH_MONKEY_OUTPUT");
    }

    /**
     * Key {@code NO_MONKEY_OUTPUT}: {@code Could not open monkey output file
     * ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not open monkey output file ''{0}''}
     */
    public static String NO_MONKEY_OUTPUT(Object arg0) {
        return holder.format("NO_MONKEY_OUTPUT", arg0);
    }

    /**
     * Key {@code NO_MONKEY_OUTPUT}: {@code Could not open monkey output file
     * ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not open monkey output file ''{0}''}
     */
    public static Localizable _NO_MONKEY_OUTPUT(Object arg0) {
        return new Localizable(holder, "NO_MONKEY_OUTPUT", arg0);
    }

    /**
     * Key {@code SETTING_HARDWARE_PROPERTIES}: {@code Setting hardware
     * properties:}.
     * 
     * @return
     *     {@code Setting hardware properties:}
     */
    public static String SETTING_HARDWARE_PROPERTIES() {
        return holder.format("SETTING_HARDWARE_PROPERTIES");
    }

    /**
     * Key {@code SETTING_HARDWARE_PROPERTIES}: {@code Setting hardware
     * properties:}.
     * 
     * @return
     *     {@code Setting hardware properties:}
     */
    public static Localizable _SETTING_HARDWARE_PROPERTIES() {
        return new Localizable(holder, "SETTING_HARDWARE_PROPERTIES");
    }

    /**
     * Key {@code MANIFEST_XPATH_FAILURE}: {@code Failed to evaluate XPath
     * for manifest at ''{0}''. Please report this as a bug!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to evaluate XPath for manifest at ''{0}''. Please report
     *     this as a bug!}
     */
    public static String MANIFEST_XPATH_FAILURE(Object arg0) {
        return holder.format("MANIFEST_XPATH_FAILURE", arg0);
    }

    /**
     * Key {@code MANIFEST_XPATH_FAILURE}: {@code Failed to evaluate XPath
     * for manifest at ''{0}''. Please report this as a bug!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to evaluate XPath for manifest at ''{0}''. Please report
     *     this as a bug!}
     */
    public static Localizable _MANIFEST_XPATH_FAILURE(Object arg0) {
        return new Localizable(holder, "MANIFEST_XPATH_FAILURE", arg0);
    }

    /**
     * Key {@code WAITING_FOR_CORE_PROCESS}: {@code Waiting for system
     * package manager to start...}.
     * 
     * @return
     *     {@code Waiting for system package manager to start...}
     */
    public static String WAITING_FOR_CORE_PROCESS() {
        return holder.format("WAITING_FOR_CORE_PROCESS");
    }

    /**
     * Key {@code WAITING_FOR_CORE_PROCESS}: {@code Waiting for system
     * package manager to start...}.
     * 
     * @return
     *     {@code Waiting for system package manager to start...}
     */
    public static Localizable _WAITING_FOR_CORE_PROCESS() {
        return new Localizable(holder, "WAITING_FOR_CORE_PROCESS");
    }

    /**
     * Key {@code BUILD_RESULT_FAILURE}: {@code Failure}.
     * 
     * @return
     *     {@code Failure}
     */
    public static String BUILD_RESULT_FAILURE() {
        return holder.format("BUILD_RESULT_FAILURE");
    }

    /**
     * Key {@code BUILD_RESULT_FAILURE}: {@code Failure}.
     * 
     * @return
     *     {@code Failure}
     */
    public static Localizable _BUILD_RESULT_FAILURE() {
        return new Localizable(holder, "BUILD_RESULT_FAILURE");
    }

    /**
     * Key {@code WAITING_FOR_BOOT_COMPLETION}: {@code Waiting for emulator
     * to finish booting...}.
     * 
     * @return
     *     {@code Waiting for emulator to finish booting...}
     */
    public static String WAITING_FOR_BOOT_COMPLETION() {
        return holder.format("WAITING_FOR_BOOT_COMPLETION");
    }

    /**
     * Key {@code WAITING_FOR_BOOT_COMPLETION}: {@code Waiting for emulator
     * to finish booting...}.
     * 
     * @return
     *     {@code Waiting for emulator to finish booting...}
     */
    public static Localizable _WAITING_FOR_BOOT_COMPLETION() {
        return new Localizable(holder, "WAITING_FOR_BOOT_COMPLETION");
    }

    /**
     * Key {@code ARCHIVING_LOG}: {@code Archiving emulator log}.
     * 
     * @return
     *     {@code Archiving emulator log}
     */
    public static String ARCHIVING_LOG() {
        return holder.format("ARCHIVING_LOG");
    }

    /**
     * Key {@code ARCHIVING_LOG}: {@code Archiving emulator log}.
     * 
     * @return
     *     {@code Archiving emulator log}
     */
    public static Localizable _ARCHIVING_LOG() {
        return new Localizable(holder, "ARCHIVING_LOG");
    }

    /**
     * Key {@code WAITING_INITIAL_SNAPSHOT}: {@code Giving the system some
     * time to settle before creating initial snapshot...}.
     * 
     * @return
     *     {@code Giving the system some time to settle before creating initial
     *     snapshot...}
     */
    public static String WAITING_INITIAL_SNAPSHOT() {
        return holder.format("WAITING_INITIAL_SNAPSHOT");
    }

    /**
     * Key {@code WAITING_INITIAL_SNAPSHOT}: {@code Giving the system some
     * time to settle before creating initial snapshot...}.
     * 
     * @return
     *     {@code Giving the system some time to settle before creating initial
     *     snapshot...}
     */
    public static Localizable _WAITING_INITIAL_SNAPSHOT() {
        return new Localizable(holder, "WAITING_INITIAL_SNAPSHOT");
    }

    /**
     * Key {@code APK_NOT_SPECIFIED}: {@code No APK file was specified to be
     * installed}.
     * 
     * @return
     *     {@code No APK file was specified to be installed}
     */
    public static String APK_NOT_SPECIFIED() {
        return holder.format("APK_NOT_SPECIFIED");
    }

    /**
     * Key {@code APK_NOT_SPECIFIED}: {@code No APK file was specified to be
     * installed}.
     * 
     * @return
     *     {@code No APK file was specified to be installed}
     */
    public static Localizable _APK_NOT_SPECIFIED() {
        return new Localizable(holder, "APK_NOT_SPECIFIED");
    }

    /**
     * Key {@code SDK_COMPONENT_INSTALLATION_UNSUPPORTED}: {@code However,
     * this cannot be automatically installed as SDK Tools r14 or newer is
     * required...}.
     * 
     * @return
     *     {@code However, this cannot be automatically installed as SDK Tools
     *     r14 or newer is required...}
     */
    public static String SDK_COMPONENT_INSTALLATION_UNSUPPORTED() {
        return holder.format("SDK_COMPONENT_INSTALLATION_UNSUPPORTED");
    }

    /**
     * Key {@code SDK_COMPONENT_INSTALLATION_UNSUPPORTED}: {@code However,
     * this cannot be automatically installed as SDK Tools r14 or newer is
     * required...}.
     * 
     * @return
     *     {@code However, this cannot be automatically installed as SDK Tools
     *     r14 or newer is required...}
     */
    public static Localizable _SDK_COMPONENT_INSTALLATION_UNSUPPORTED() {
        return new Localizable(holder, "SDK_COMPONENT_INSTALLATION_UNSUPPORTED");
    }

    /**
     * Key {@code MONKEY_RESULT}: {@code Android monkey test: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Android monkey test: {0}}
     */
    public static String MONKEY_RESULT(Object arg0) {
        return holder.format("MONKEY_RESULT", arg0);
    }

    /**
     * Key {@code MONKEY_RESULT}: {@code Android monkey test: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Android monkey test: {0}}
     */
    public static Localizable _MONKEY_RESULT(Object arg0) {
        return new Localizable(holder, "MONKEY_RESULT", arg0);
    }

    /**
     * Key {@code SDK_INSTALLATION_FAILED}: {@code Android SDK installation
     * failed}.
     * 
     * @return
     *     {@code Android SDK installation failed}
     */
    public static String SDK_INSTALLATION_FAILED() {
        return holder.format("SDK_INSTALLATION_FAILED");
    }

    /**
     * Key {@code SDK_INSTALLATION_FAILED}: {@code Android SDK installation
     * failed}.
     * 
     * @return
     *     {@code Android SDK installation failed}
     */
    public static Localizable _SDK_INSTALLATION_FAILED() {
        return new Localizable(holder, "SDK_INSTALLATION_FAILED");
    }

    /**
     * Key {@code NO_PROJECTS_FOUND_FOR_PREREQUISITES}: {@code No Android
     * projects found; won''t install any dependencies.}.
     * 
     * @return
     *     {@code No Android projects found; won''t install any dependencies.}
     */
    public static String NO_PROJECTS_FOUND_FOR_PREREQUISITES() {
        return holder.format("NO_PROJECTS_FOUND_FOR_PREREQUISITES");
    }

    /**
     * Key {@code NO_PROJECTS_FOUND_FOR_PREREQUISITES}: {@code No Android
     * projects found; won''t install any dependencies.}.
     * 
     * @return
     *     {@code No Android projects found; won''t install any dependencies.}
     */
    public static Localizable _NO_PROJECTS_FOUND_FOR_PREREQUISITES() {
        return new Localizable(holder, "NO_PROJECTS_FOUND_FOR_PREREQUISITES");
    }

    /**
     * Key {@code INVALID_SDK_DIRECTORY}: {@code Does not look like an
     * Android SDK directory}.
     * 
     * @return
     *     {@code Does not look like an Android SDK directory}
     */
    public static String INVALID_SDK_DIRECTORY() {
        return holder.format("INVALID_SDK_DIRECTORY");
    }

    /**
     * Key {@code INVALID_SDK_DIRECTORY}: {@code Does not look like an
     * Android SDK directory}.
     * 
     * @return
     *     {@code Does not look like an Android SDK directory}
     */
    public static Localizable _INVALID_SDK_DIRECTORY() {
        return new Localizable(holder, "INVALID_SDK_DIRECTORY");
    }

    /**
     * Key {@code EMULATOR_CONSOLE_REPORT}: {@code Emulator reported that the
     * console is available on port {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Emulator reported that the console is available on port {0}}
     */
    public static String EMULATOR_CONSOLE_REPORT(Object arg0) {
        return holder.format("EMULATOR_CONSOLE_REPORT", arg0);
    }

    /**
     * Key {@code EMULATOR_CONSOLE_REPORT}: {@code Emulator reported that the
     * console is available on port {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Emulator reported that the console is available on port {0}}
     */
    public static Localizable _EMULATOR_CONSOLE_REPORT(Object arg0) {
        return new Localizable(holder, "EMULATOR_CONSOLE_REPORT", arg0);
    }

    /**
     * Key {@code BUILD_RESULT_UNSTABLE}: {@code Unstable}.
     * 
     * @return
     *     {@code Unstable}
     */
    public static String BUILD_RESULT_UNSTABLE() {
        return holder.format("BUILD_RESULT_UNSTABLE");
    }

    /**
     * Key {@code BUILD_RESULT_UNSTABLE}: {@code Unstable}.
     * 
     * @return
     *     {@code Unstable}
     */
    public static Localizable _BUILD_RESULT_UNSTABLE() {
        return new Localizable(holder, "BUILD_RESULT_UNSTABLE");
    }

    /**
     * Key {@code INVALID_AVD_NAME}: {@code Invalid AVD name}.
     * 
     * @return
     *     {@code Invalid AVD name}
     */
    public static String INVALID_AVD_NAME() {
        return holder.format("INVALID_AVD_NAME");
    }

    /**
     * Key {@code INVALID_AVD_NAME}: {@code Invalid AVD name}.
     * 
     * @return
     *     {@code Invalid AVD name}
     */
    public static Localizable _INVALID_AVD_NAME() {
        return new Localizable(holder, "INVALID_AVD_NAME");
    }

    /**
     * Key {@code SUSPECT_RESOLUTION_ANDROID_3}: {@code That doesn''t look
     * right for Android {0}. Did you mean WXGA?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code That doesn''t look right for Android {0}. Did you mean WXGA?}
     */
    public static String SUSPECT_RESOLUTION_ANDROID_3(Object arg0) {
        return holder.format("SUSPECT_RESOLUTION_ANDROID_3", arg0);
    }

    /**
     * Key {@code SUSPECT_RESOLUTION_ANDROID_3}: {@code That doesn''t look
     * right for Android {0}. Did you mean WXGA?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code That doesn''t look right for Android {0}. Did you mean WXGA?}
     */
    public static Localizable _SUSPECT_RESOLUTION_ANDROID_3(Object arg0) {
        return new Localizable(holder, "SUSPECT_RESOLUTION_ANDROID_3", arg0);
    }

    /**
     * Key {@code SUSPECT_RESOLUTION_ANDROID_4}: {@code That doesn''t look
     * right for Android {0}. Did you mean WXGA720 or WXGA800?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code That doesn''t look right for Android {0}. Did you mean WXGA720
     *     or WXGA800?}
     */
    public static String SUSPECT_RESOLUTION_ANDROID_4(Object arg0) {
        return holder.format("SUSPECT_RESOLUTION_ANDROID_4", arg0);
    }

    /**
     * Key {@code SUSPECT_RESOLUTION_ANDROID_4}: {@code That doesn''t look
     * right for Android {0}. Did you mean WXGA720 or WXGA800?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code That doesn''t look right for Android {0}. Did you mean WXGA720
     *     or WXGA800?}
     */
    public static Localizable _SUSPECT_RESOLUTION_ANDROID_4(Object arg0) {
        return new Localizable(holder, "SUSPECT_RESOLUTION_ANDROID_4", arg0);
    }

    /**
     * Key {@code NODE_UNAVAILABLE_EXCEPTION}: {@code Build node seems to be
     * unavailable: channel/node/computer is null.}.
     * 
     * @return
     *     {@code Build node seems to be unavailable: channel/node/computer is
     *     null.}
     */
    public static String NODE_UNAVAILABLE_EXCEPTION() {
        return holder.format("NODE_UNAVAILABLE_EXCEPTION");
    }

    /**
     * Key {@code NODE_UNAVAILABLE_EXCEPTION}: {@code Build node seems to be
     * unavailable: channel/node/computer is null.}.
     * 
     * @return
     *     {@code Build node seems to be unavailable: channel/node/computer is
     *     null.}
     */
    public static Localizable _NODE_UNAVAILABLE_EXCEPTION() {
        return new Localizable(holder, "NODE_UNAVAILABLE_EXCEPTION");
    }

    /**
     * Key {@code SENDING_COMMAND_FAILED}: {@code Failed to execute emulator
     * command ''{0}'': {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to execute emulator command ''{0}'': {1}}
     */
    public static String SENDING_COMMAND_FAILED(Object arg0, Object arg1) {
        return holder.format("SENDING_COMMAND_FAILED", arg0, arg1);
    }

    /**
     * Key {@code SENDING_COMMAND_FAILED}: {@code Failed to execute emulator
     * command ''{0}'': {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to execute emulator command ''{0}'': {1}}
     */
    public static Localizable _SENDING_COMMAND_FAILED(Object arg0, Object arg1) {
        return new Localizable(holder, "SENDING_COMMAND_FAILED", arg0, arg1);
    }

    /**
     * Key {@code OS_VERSION_REQUIRED}: {@code OS version is required}.
     * 
     * @return
     *     {@code OS version is required}
     */
    public static String OS_VERSION_REQUIRED() {
        return holder.format("OS_VERSION_REQUIRED");
    }

    /**
     * Key {@code OS_VERSION_REQUIRED}: {@code OS version is required}.
     * 
     * @return
     *     {@code OS version is required}
     */
    public static Localizable _OS_VERSION_REQUIRED() {
        return new Localizable(holder, "OS_VERSION_REQUIRED");
    }

    /**
     * Key {@code CREATING_AVD}: {@code Creating Android AVD: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Creating Android AVD: {0}}
     */
    public static String CREATING_AVD(Object arg0) {
        return holder.format("CREATING_AVD", arg0);
    }

    /**
     * Key {@code CREATING_AVD}: {@code Creating Android AVD: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Creating Android AVD: {0}}
     */
    public static Localizable _CREATING_AVD(Object arg0) {
        return new Localizable(holder, "CREATING_AVD", arg0);
    }

    /**
     * Key {@code SDK_INSTALL_UPDATE_TOOLS}: {@code Outdated SDK Tools found.
     * Upgrading from ''{0}'' to ''{1}''}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Outdated SDK Tools found. Upgrading from ''{0}'' to ''{1}''}
     */
    public static String SDK_INSTALL_UPDATE_TOOLS(Object arg0, Object arg1) {
        return holder.format("SDK_INSTALL_UPDATE_TOOLS", arg0, arg1);
    }

    /**
     * Key {@code SDK_INSTALL_UPDATE_TOOLS}: {@code Outdated SDK Tools found.
     * Upgrading from ''{0}'' to ''{1}''}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Outdated SDK Tools found. Upgrading from ''{0}'' to ''{1}''}
     */
    public static Localizable _SDK_INSTALL_UPDATE_TOOLS(Object arg0, Object arg1) {
        return new Localizable(holder, "SDK_INSTALL_UPDATE_TOOLS", arg0, arg1);
    }

    /**
     * Key {@code SDK_UNAVAILABLE}: {@code The Android SDK is not available
     * for {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The Android SDK is not available for {0}}
     */
    public static String SDK_UNAVAILABLE(Object arg0) {
        return holder.format("SDK_UNAVAILABLE", arg0);
    }

    /**
     * Key {@code SDK_UNAVAILABLE}: {@code The Android SDK is not available
     * for {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The Android SDK is not available for {0}}
     */
    public static Localizable _SDK_UNAVAILABLE(Object arg0) {
        return new Localizable(holder, "SDK_UNAVAILABLE", arg0);
    }

    /**
     * Key {@code SDK_ADDON_INSTALLATION_UNSUPPORTED}: {@code Unfortunately
     * this particular package cannot be automatically installed on SDK Tools
     * r15 or earlier...}.
     * 
     * @return
     *     {@code Unfortunately this particular package cannot be automatically
     *     installed on SDK Tools r15 or earlier...}
     */
    public static String SDK_ADDON_INSTALLATION_UNSUPPORTED() {
        return holder.format("SDK_ADDON_INSTALLATION_UNSUPPORTED");
    }

    /**
     * Key {@code SDK_ADDON_INSTALLATION_UNSUPPORTED}: {@code Unfortunately
     * this particular package cannot be automatically installed on SDK Tools
     * r15 or earlier...}.
     * 
     * @return
     *     {@code Unfortunately this particular package cannot be automatically
     *     installed on SDK Tools r15 or earlier...}
     */
    public static Localizable _SDK_ADDON_INSTALLATION_UNSUPPORTED() {
        return new Localizable(holder, "SDK_ADDON_INSTALLATION_UNSUPPORTED");
    }

    /**
     * Key {@code UNINSTALL_ANDROID_PACKAGE}: {@code Uninstall Android
     * package}.
     * 
     * @return
     *     {@code Uninstall Android package}
     */
    public static String UNINSTALL_ANDROID_PACKAGE() {
        return holder.format("UNINSTALL_ANDROID_PACKAGE");
    }

    /**
     * Key {@code UNINSTALL_ANDROID_PACKAGE}: {@code Uninstall Android
     * package}.
     * 
     * @return
     *     {@code Uninstall Android package}
     */
    public static Localizable _UNINSTALL_ANDROID_PACKAGE() {
        return new Localizable(holder, "UNINSTALL_ANDROID_PACKAGE");
    }

    /**
     * Key {@code READING_PROJECT_FILE_FAILED}: {@code Reading platform from
     * project file failed:}.
     * 
     * @return
     *     {@code Reading platform from project file failed:}
     */
    public static String READING_PROJECT_FILE_FAILED() {
        return holder.format("READING_PROJECT_FILE_FAILED");
    }

    /**
     * Key {@code READING_PROJECT_FILE_FAILED}: {@code Reading platform from
     * project file failed:}.
     * 
     * @return
     *     {@code Reading platform from project file failed:}
     */
    public static Localizable _READING_PROJECT_FILE_FAILED() {
        return new Localizable(holder, "READING_PROJECT_FILE_FAILED");
    }

    /**
     * Key {@code DEFAULT_LOCALE_WARNING}: {@code Locale will default to
     * ''{0}'' if not specified}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Locale will default to ''{0}'' if not specified}
     */
    public static String DEFAULT_LOCALE_WARNING(Object arg0) {
        return holder.format("DEFAULT_LOCALE_WARNING", arg0);
    }

    /**
     * Key {@code DEFAULT_LOCALE_WARNING}: {@code Locale will default to
     * ''{0}'' if not specified}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Locale will default to ''{0}'' if not specified}
     */
    public static Localizable _DEFAULT_LOCALE_WARNING(Object arg0) {
        return new Localizable(holder, "DEFAULT_LOCALE_WARNING", arg0);
    }

    /**
     * Key {@code FAILED_TO_DELETE_AVD}: {@code Failed to delete AVD: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to delete AVD: {0}}
     */
    public static String FAILED_TO_DELETE_AVD(Object arg0) {
        return holder.format("FAILED_TO_DELETE_AVD", arg0);
    }

    /**
     * Key {@code FAILED_TO_DELETE_AVD}: {@code Failed to delete AVD: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to delete AVD: {0}}
     */
    public static Localizable _FAILED_TO_DELETE_AVD(Object arg0) {
        return new Localizable(holder, "FAILED_TO_DELETE_AVD", arg0);
    }

    /**
     * Key {@code INVALID_RESOLUTION_FORMAT}: {@code Resolution should be
     * xVGA, or WWWxHHH}.
     * 
     * @return
     *     {@code Resolution should be xVGA, or WWWxHHH}
     */
    public static String INVALID_RESOLUTION_FORMAT() {
        return holder.format("INVALID_RESOLUTION_FORMAT");
    }

    /**
     * Key {@code INVALID_RESOLUTION_FORMAT}: {@code Resolution should be
     * xVGA, or WWWxHHH}.
     * 
     * @return
     *     {@code Resolution should be xVGA, or WWWxHHH}
     */
    public static Localizable _INVALID_RESOLUTION_FORMAT() {
        return new Localizable(holder, "INVALID_RESOLUTION_FORMAT");
    }

    /**
     * Key {@code FINDING_PROJECTS}: {@code Searching for Android
     * projects...}.
     * 
     * @return
     *     {@code Searching for Android projects...}
     */
    public static String FINDING_PROJECTS() {
        return holder.format("FINDING_PROJECTS");
    }

    /**
     * Key {@code FINDING_PROJECTS}: {@code Searching for Android
     * projects...}.
     * 
     * @return
     *     {@code Searching for Android projects...}
     */
    public static Localizable _FINDING_PROJECTS() {
        return new Localizable(holder, "FINDING_PROJECTS");
    }

    /**
     * Key {@code FOUND_PROJECTS_TO_UPDATE}: {@code Found {0} projects to
     * create build files for.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Found {0} projects to create build files for.}
     */
    public static String FOUND_PROJECTS_TO_UPDATE(Object arg0) {
        return holder.format("FOUND_PROJECTS_TO_UPDATE", arg0);
    }

    /**
     * Key {@code FOUND_PROJECTS_TO_UPDATE}: {@code Found {0} projects to
     * create build files for.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Found {0} projects to create build files for.}
     */
    public static Localizable _FOUND_PROJECTS_TO_UPDATE(Object arg0) {
        return new Localizable(holder, "FOUND_PROJECTS_TO_UPDATE", arg0);
    }

    /**
     * Key {@code ABI_INSTALLATION_UNSUPPORTED}: {@code It appears that the
     * configured platform is based on Android 4.0 or newer.
     * This requires
     * the ''ARM EABI v7a System Image'' package which cannot be
     * automatically installed with SDK Tools r16 or earlier.
     * Please install
     * this component manually via the Android SDK Manager, or upgrade to SDK
     * Tools r17}.
     * 
     * @return
     *     {@code It appears that the configured platform is based on Android 4.0
     *     or newer.
     *     This requires the ''ARM EABI v7a System Image'' package
     *     which cannot be automatically installed with SDK Tools r16 or
     *     earlier.
     *     Please install this component manually via the Android SDK
     *     Manager, or upgrade to SDK Tools r17}
     */
    public static String ABI_INSTALLATION_UNSUPPORTED() {
        return holder.format("ABI_INSTALLATION_UNSUPPORTED");
    }

    /**
     * Key {@code ABI_INSTALLATION_UNSUPPORTED}: {@code It appears that the
     * configured platform is based on Android 4.0 or newer.
     * This requires
     * the ''ARM EABI v7a System Image'' package which cannot be
     * automatically installed with SDK Tools r16 or earlier.
     * Please install
     * this component manually via the Android SDK Manager, or upgrade to SDK
     * Tools r17}.
     * 
     * @return
     *     {@code It appears that the configured platform is based on Android 4.0
     *     or newer.
     *     This requires the ''ARM EABI v7a System Image'' package
     *     which cannot be automatically installed with SDK Tools r16 or
     *     earlier.
     *     Please install this component manually via the Android SDK
     *     Manager, or upgrade to SDK Tools r17}
     */
    public static Localizable _ABI_INSTALLATION_UNSUPPORTED() {
        return new Localizable(holder, "ABI_INSTALLATION_UNSUPPORTED");
    }

    /**
     * Key {@code CANNOT_CONNECT_TO_EMULATOR}: {@code Could not connect to
     * running emulator; cannot continue}.
     * 
     * @return
     *     {@code Could not connect to running emulator; cannot continue}
     */
    public static String CANNOT_CONNECT_TO_EMULATOR() {
        return holder.format("CANNOT_CONNECT_TO_EMULATOR");
    }

    /**
     * Key {@code CANNOT_CONNECT_TO_EMULATOR}: {@code Could not connect to
     * running emulator; cannot continue}.
     * 
     * @return
     *     {@code Could not connect to running emulator; cannot continue}
     */
    public static Localizable _CANNOT_CONNECT_TO_EMULATOR() {
        return new Localizable(holder, "CANNOT_CONNECT_TO_EMULATOR");
    }

    /**
     * Key {@code COULD_NOT_DETERMINE_APK_PACKAGE}: {@code Could not
     * determine package name from APK file ''{0}''; cannot uninstall}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not determine package name from APK file ''{0}''; cannot
     *     uninstall}
     */
    public static String COULD_NOT_DETERMINE_APK_PACKAGE(Object arg0) {
        return holder.format("COULD_NOT_DETERMINE_APK_PACKAGE", arg0);
    }

    /**
     * Key {@code COULD_NOT_DETERMINE_APK_PACKAGE}: {@code Could not
     * determine package name from APK file ''{0}''; cannot uninstall}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not determine package name from APK file ''{0}''; cannot
     *     uninstall}
     */
    public static Localizable _COULD_NOT_DETERMINE_APK_PACKAGE(Object arg0) {
        return new Localizable(holder, "COULD_NOT_DETERMINE_APK_PACKAGE", arg0);
    }

    /**
     * Key {@code COULD_NOT_CHECK_BOOT_COMPLETION}: {@code Could not check
     * for boot completion:}.
     * 
     * @return
     *     {@code Could not check for boot completion:}
     */
    public static String COULD_NOT_CHECK_BOOT_COMPLETION() {
        return holder.format("COULD_NOT_CHECK_BOOT_COMPLETION");
    }

    /**
     * Key {@code COULD_NOT_CHECK_BOOT_COMPLETION}: {@code Could not check
     * for boot completion:}.
     * 
     * @return
     *     {@code Could not check for boot completion:}
     */
    public static Localizable _COULD_NOT_CHECK_BOOT_COMPLETION() {
        return new Localizable(holder, "COULD_NOT_CHECK_BOOT_COMPLETION");
    }

    /**
     * Key {@code AVD_DIRECTORY_CREATION_FAILED}: {@code Could not create
     * directory ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not create directory ''{0}''}
     */
    public static String AVD_DIRECTORY_CREATION_FAILED(Object arg0) {
        return holder.format("AVD_DIRECTORY_CREATION_FAILED", arg0);
    }

    /**
     * Key {@code AVD_DIRECTORY_CREATION_FAILED}: {@code Could not create
     * directory ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not create directory ''{0}''}
     */
    public static Localizable _AVD_DIRECTORY_CREATION_FAILED(Object arg0) {
        return new Localizable(holder, "AVD_DIRECTORY_CREATION_FAILED", arg0);
    }

    /**
     * Key {@code CONFIG_FILE_UNSUPPORTED_EXTENSION}: {@code Unsupported
     * config file type ''{0}'' detected. Currently only .ini and .properties
     * files are supported.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unsupported config file type ''{0}'' detected. Currently only
     *     .ini and .properties files are supported.}
     */
    public static String CONFIG_FILE_UNSUPPORTED_EXTENSION(Object arg0) {
        return holder.format("CONFIG_FILE_UNSUPPORTED_EXTENSION", arg0);
    }

    /**
     * Key {@code CONFIG_FILE_UNSUPPORTED_EXTENSION}: {@code Unsupported
     * config file type ''{0}'' detected. Currently only .ini and .properties
     * files are supported.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unsupported config file type ''{0}'' detected. Currently only
     *     .ini and .properties files are supported.}
     */
    public static Localizable _CONFIG_FILE_UNSUPPORTED_EXTENSION(Object arg0) {
        return new Localizable(holder, "CONFIG_FILE_UNSUPPORTED_EXTENSION", arg0);
    }

    /**
     * Key {@code FOUND_TEST_PROJECT_WITHOUT_APP}: {@code No related app
     * project found; cannot create build files for test project at
     * ''{0}''.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No related app project found; cannot create build files for
     *     test project at ''{0}''.}
     */
    public static String FOUND_TEST_PROJECT_WITHOUT_APP(Object arg0) {
        return holder.format("FOUND_TEST_PROJECT_WITHOUT_APP", arg0);
    }

    /**
     * Key {@code FOUND_TEST_PROJECT_WITHOUT_APP}: {@code No related app
     * project found; cannot create build files for test project at
     * ''{0}''.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No related app project found; cannot create build files for
     *     test project at ''{0}''.}
     */
    public static Localizable _FOUND_TEST_PROJECT_WITHOUT_APP(Object arg0) {
        return new Localizable(holder, "FOUND_TEST_PROJECT_WITHOUT_APP", arg0);
    }

    /**
     * Key {@code MONKEY_RESULT_UNRECOGNISED}: {@code Could not determine
     * results from file}.
     * 
     * @return
     *     {@code Could not determine results from file}
     */
    public static String MONKEY_RESULT_UNRECOGNISED() {
        return holder.format("MONKEY_RESULT_UNRECOGNISED");
    }

    /**
     * Key {@code MONKEY_RESULT_UNRECOGNISED}: {@code Could not determine
     * results from file}.
     * 
     * @return
     *     {@code Could not determine results from file}
     */
    public static Localizable _MONKEY_RESULT_UNRECOGNISED() {
        return new Localizable(holder, "MONKEY_RESULT_UNRECOGNISED");
    }

    /**
     * Key {@code NO_PROJECTS_FOUND_TO_UPDATE}: {@code No Android projects
     * found to create build files for.}.
     * 
     * @return
     *     {@code No Android projects found to create build files for.}
     */
    public static String NO_PROJECTS_FOUND_TO_UPDATE() {
        return holder.format("NO_PROJECTS_FOUND_TO_UPDATE");
    }

    /**
     * Key {@code NO_PROJECTS_FOUND_TO_UPDATE}: {@code No Android projects
     * found to create build files for.}.
     * 
     * @return
     *     {@code No Android projects found to create build files for.}
     */
    public static Localizable _NO_PROJECTS_FOUND_TO_UPDATE() {
        return new Localizable(holder, "NO_PROJECTS_FOUND_TO_UPDATE");
    }

    /**
     * Key {@code AVD_NAME_REQUIRED}: {@code AVD name is required}.
     * 
     * @return
     *     {@code AVD name is required}
     */
    public static String AVD_NAME_REQUIRED() {
        return holder.format("AVD_NAME_REQUIRED");
    }

    /**
     * Key {@code AVD_NAME_REQUIRED}: {@code AVD name is required}.
     * 
     * @return
     *     {@code AVD name is required}
     */
    public static Localizable _AVD_NAME_REQUIRED() {
        return new Localizable(holder, "AVD_NAME_REQUIRED");
    }

    /**
     * Key {@code FAILED_TO_READ_MANIFEST}: {@code Failed to read manifest
     * file at ''{0}''.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to read manifest file at ''{0}''.}
     */
    public static String FAILED_TO_READ_MANIFEST(Object arg0) {
        return holder.format("FAILED_TO_READ_MANIFEST", arg0);
    }

    /**
     * Key {@code FAILED_TO_READ_MANIFEST}: {@code Failed to read manifest
     * file at ''{0}''.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to read manifest file at ''{0}''.}
     */
    public static Localizable _FAILED_TO_READ_MANIFEST(Object arg0) {
        return new Localizable(holder, "FAILED_TO_READ_MANIFEST", arg0);
    }

    /**
     * Key {@code SD_CARD_CREATION_FAILED}: {@code Could not add SD card to
     * emulator:}.
     * 
     * @return
     *     {@code Could not add SD card to emulator:}
     */
    public static String SD_CARD_CREATION_FAILED() {
        return holder.format("SD_CARD_CREATION_FAILED");
    }

    /**
     * Key {@code SD_CARD_CREATION_FAILED}: {@code Could not add SD card to
     * emulator:}.
     * 
     * @return
     *     {@code Could not add SD card to emulator:}
     */
    public static Localizable _SD_CARD_CREATION_FAILED() {
        return new Localizable(holder, "SD_CARD_CREATION_FAILED");
    }

    /**
     * Key {@code DOWNLOADING_SDK_FROM}: {@code Downloading and installing
     * Android SDK from {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downloading and installing Android SDK from {0}}
     */
    public static String DOWNLOADING_SDK_FROM(Object arg0) {
        return holder.format("DOWNLOADING_SDK_FROM", arg0);
    }

    /**
     * Key {@code DOWNLOADING_SDK_FROM}: {@code Downloading and installing
     * Android SDK from {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downloading and installing Android SDK from {0}}
     */
    public static Localizable _DOWNLOADING_SDK_FROM(Object arg0) {
        return new Localizable(holder, "DOWNLOADING_SDK_FROM", arg0);
    }

    /**
     * Key {@code INVALID_SD_CARD_SIZE}: {@code SD card size should be
     * numeric with suffix, e.g. 32M}.
     * 
     * @return
     *     {@code SD card size should be numeric with suffix, e.g. 32M}
     */
    public static String INVALID_SD_CARD_SIZE() {
        return holder.format("INVALID_SD_CARD_SIZE");
    }

    /**
     * Key {@code INVALID_SD_CARD_SIZE}: {@code SD card size should be
     * numeric with suffix, e.g. 32M}.
     * 
     * @return
     *     {@code SD card size should be numeric with suffix, e.g. 32M}
     */
    public static Localizable _INVALID_SD_CARD_SIZE() {
        return new Localizable(holder, "INVALID_SD_CARD_SIZE");
    }

    /**
     * Key {@code AVD_CREATION_FAILED}: {@code Failed to run AVD creation
     * command}.
     * 
     * @return
     *     {@code Failed to run AVD creation command}
     */
    public static String AVD_CREATION_FAILED() {
        return holder.format("AVD_CREATION_FAILED");
    }

    /**
     * Key {@code AVD_CREATION_FAILED}: {@code Failed to run AVD creation
     * command}.
     * 
     * @return
     *     {@code Failed to run AVD creation command}
     */
    public static Localizable _AVD_CREATION_FAILED() {
        return new Localizable(holder, "AVD_CREATION_FAILED");
    }

    /**
     * Key {@code INVALID_OS_VERSION}: {@code Invalid OS version}.
     * 
     * @return
     *     {@code Invalid OS version}
     */
    public static String INVALID_OS_VERSION() {
        return holder.format("INVALID_OS_VERSION");
    }

    /**
     * Key {@code INVALID_OS_VERSION}: {@code Invalid OS version}.
     * 
     * @return
     *     {@code Invalid OS version}
     */
    public static Localizable _INVALID_OS_VERSION() {
        return new Localizable(holder, "INVALID_OS_VERSION");
    }

    /**
     * Key {@code BASE_SDK_INSTALLED}: {@code Base SDK installed
     * successfully}.
     * 
     * @return
     *     {@code Base SDK installed successfully}
     */
    public static String BASE_SDK_INSTALLED() {
        return holder.format("BASE_SDK_INSTALLED");
    }

    /**
     * Key {@code BASE_SDK_INSTALLED}: {@code Base SDK installed
     * successfully}.
     * 
     * @return
     *     {@code Base SDK installed successfully}
     */
    public static Localizable _BASE_SDK_INSTALLED() {
        return new Localizable(holder, "BASE_SDK_INSTALLED");
    }

    /**
     * Key {@code EMULATOR_DID_NOT_START}: {@code Emulator did not appear to
     * start; giving up}.
     * 
     * @return
     *     {@code Emulator did not appear to start; giving up}
     */
    public static String EMULATOR_DID_NOT_START() {
        return holder.format("EMULATOR_DID_NOT_START");
    }

    /**
     * Key {@code EMULATOR_DID_NOT_START}: {@code Emulator did not appear to
     * start; giving up}.
     * 
     * @return
     *     {@code Emulator did not appear to start; giving up}
     */
    public static Localizable _EMULATOR_DID_NOT_START() {
        return new Localizable(holder, "EMULATOR_DID_NOT_START");
    }

    /**
     * Key {@code INVALID_AVD_TARGET}: {@code The desired AVD platform
     * ''{0}'' is not installed on this machine}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The desired AVD platform ''{0}'' is not installed on this
     *     machine}
     */
    public static String INVALID_AVD_TARGET(Object arg0) {
        return holder.format("INVALID_AVD_TARGET", arg0);
    }

    /**
     * Key {@code INVALID_AVD_TARGET}: {@code The desired AVD platform
     * ''{0}'' is not installed on this machine}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The desired AVD platform ''{0}'' is not installed on this
     *     machine}
     */
    public static Localizable _INVALID_AVD_TARGET(Object arg0) {
        return new Localizable(holder, "INVALID_AVD_TARGET", arg0);
    }

    /**
     * Key {@code PROJECT_TYPE_LIBRARY}: {@code library}.
     * 
     * @return
     *     {@code library}
     */
    public static String PROJECT_TYPE_LIBRARY() {
        return holder.format("PROJECT_TYPE_LIBRARY");
    }

    /**
     * Key {@code PROJECT_TYPE_LIBRARY}: {@code library}.
     * 
     * @return
     *     {@code library}
     */
    public static Localizable _PROJECT_TYPE_LIBRARY() {
        return new Localizable(holder, "PROJECT_TYPE_LIBRARY");
    }

    /**
     * Key {@code STARTING_EMULATOR_SNAPSHOT_INIT}: {@code Starting Android
     * emulator and creating initial snapshot}.
     * 
     * @return
     *     {@code Starting Android emulator and creating initial snapshot}
     */
    public static String STARTING_EMULATOR_SNAPSHOT_INIT() {
        return holder.format("STARTING_EMULATOR_SNAPSHOT_INIT");
    }

    /**
     * Key {@code STARTING_EMULATOR_SNAPSHOT_INIT}: {@code Starting Android
     * emulator and creating initial snapshot}.
     * 
     * @return
     *     {@code Starting Android emulator and creating initial snapshot}
     */
    public static Localizable _STARTING_EMULATOR_SNAPSHOT_INIT() {
        return new Localizable(holder, "STARTING_EMULATOR_SNAPSHOT_INIT");
    }

    /**
     * Key {@code SAVE_EMULATOR_SNAPSHOT}: {@code Save an Android emulator
     * snapshot}.
     * 
     * @return
     *     {@code Save an Android emulator snapshot}
     */
    public static String SAVE_EMULATOR_SNAPSHOT() {
        return holder.format("SAVE_EMULATOR_SNAPSHOT");
    }

    /**
     * Key {@code SAVE_EMULATOR_SNAPSHOT}: {@code Save an Android emulator
     * snapshot}.
     * 
     * @return
     *     {@code Save an Android emulator snapshot}
     */
    public static Localizable _SAVE_EMULATOR_SNAPSHOT() {
        return new Localizable(holder, "SAVE_EMULATOR_SNAPSHOT");
    }

    /**
     * Key {@code AVD_DIRECTORY_NOT_FOUND}: {@code Could not find AVD
     * directory ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find AVD directory ''{0}''}
     */
    public static String AVD_DIRECTORY_NOT_FOUND(Object arg0) {
        return holder.format("AVD_DIRECTORY_NOT_FOUND", arg0);
    }

    /**
     * Key {@code AVD_DIRECTORY_NOT_FOUND}: {@code Could not find AVD
     * directory ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find AVD directory ''{0}''}
     */
    public static Localizable _AVD_DIRECTORY_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "AVD_DIRECTORY_NOT_FOUND", arg0);
    }

    /**
     * Key {@code SDK_TOOLS_NOT_FOUND}: {@code Required Android tools not
     * found in PATH; cannot continue}.
     * 
     * @return
     *     {@code Required Android tools not found in PATH; cannot continue}
     */
    public static String SDK_TOOLS_NOT_FOUND() {
        return holder.format("SDK_TOOLS_NOT_FOUND");
    }

    /**
     * Key {@code SDK_TOOLS_NOT_FOUND}: {@code Required Android tools not
     * found in PATH; cannot continue}.
     * 
     * @return
     *     {@code Required Android tools not found in PATH; cannot continue}
     */
    public static Localizable _SDK_TOOLS_NOT_FOUND() {
        return new Localizable(holder, "SDK_TOOLS_NOT_FOUND");
    }

    /**
     * Key {@code INVALID_DIRECTORY}: {@code Does not appear to be a valid
     * directory}.
     * 
     * @return
     *     {@code Does not appear to be a valid directory}
     */
    public static String INVALID_DIRECTORY() {
        return holder.format("INVALID_DIRECTORY");
    }

    /**
     * Key {@code INVALID_DIRECTORY}: {@code Does not appear to be a valid
     * directory}.
     * 
     * @return
     *     {@code Does not appear to be a valid directory}
     */
    public static Localizable _INVALID_DIRECTORY() {
        return new Localizable(holder, "INVALID_DIRECTORY");
    }

    /**
     * Key {@code STOPPING_EMULATOR}: {@code Stopping Android emulator}.
     * 
     * @return
     *     {@code Stopping Android emulator}
     */
    public static String STOPPING_EMULATOR() {
        return holder.format("STOPPING_EMULATOR");
    }

    /**
     * Key {@code STOPPING_EMULATOR}: {@code Stopping Android emulator}.
     * 
     * @return
     *     {@code Stopping Android emulator}
     */
    public static Localizable _STOPPING_EMULATOR() {
        return new Localizable(holder, "STOPPING_EMULATOR");
    }

    /**
     * Key {@code INSTALL_PREREQUISITES}: {@code Install Android project
     * prerequisites}.
     * 
     * @return
     *     {@code Install Android project prerequisites}
     */
    public static String INSTALL_PREREQUISITES() {
        return holder.format("INSTALL_PREREQUISITES");
    }

    /**
     * Key {@code INSTALL_PREREQUISITES}: {@code Install Android project
     * prerequisites}.
     * 
     * @return
     *     {@code Install Android project prerequisites}
     */
    public static Localizable _INSTALL_PREREQUISITES() {
        return new Localizable(holder, "INSTALL_PREREQUISITES");
    }

    /**
     * Key {@code SD_CARD_SIZE_TOO_SMALL}: {@code SD card size must be at
     * least 9 megabytes}.
     * 
     * @return
     *     {@code SD card size must be at least 9 megabytes}
     */
    public static String SD_CARD_SIZE_TOO_SMALL() {
        return holder.format("SD_CARD_SIZE_TOO_SMALL");
    }

    /**
     * Key {@code SD_CARD_SIZE_TOO_SMALL}: {@code SD card size must be at
     * least 9 megabytes}.
     * 
     * @return
     *     {@code SD card size must be at least 9 megabytes}
     */
    public static Localizable _SD_CARD_SIZE_TOO_SMALL() {
        return new Localizable(holder, "SD_CARD_SIZE_TOO_SMALL");
    }

    /**
     * Key {@code PROJECT_TYPE_APP}: {@code app}.
     * 
     * @return
     *     {@code app}
     */
    public static String PROJECT_TYPE_APP() {
        return holder.format("PROJECT_TYPE_APP");
    }

    /**
     * Key {@code PROJECT_TYPE_APP}: {@code app}.
     * 
     * @return
     *     {@code app}
     */
    public static Localizable _PROJECT_TYPE_APP() {
        return new Localizable(holder, "PROJECT_TYPE_APP");
    }

    /**
     * Key {@code INVALID_EXECUTABLE}: {@code Unrecognised executable}.
     * 
     * @return
     *     {@code Unrecognised executable}
     */
    public static String INVALID_EXECUTABLE() {
        return holder.format("INVALID_EXECUTABLE");
    }

    /**
     * Key {@code INVALID_EXECUTABLE}: {@code Unrecognised executable}.
     * 
     * @return
     *     {@code Unrecognised executable}
     */
    public static Localizable _INVALID_EXECUTABLE() {
        return new Localizable(holder, "INVALID_EXECUTABLE");
    }

    /**
     * Key {@code PLATFORM_IMAGE_NOT_FOUND}: {@code Cannot find desired
     * platform image at ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find desired platform image at ''{0}''}
     */
    public static String PLATFORM_IMAGE_NOT_FOUND(Object arg0) {
        return holder.format("PLATFORM_IMAGE_NOT_FOUND", arg0);
    }

    /**
     * Key {@code PLATFORM_IMAGE_NOT_FOUND}: {@code Cannot find desired
     * platform image at ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot find desired platform image at ''{0}''}
     */
    public static Localizable _PLATFORM_IMAGE_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "PLATFORM_IMAGE_NOT_FOUND", arg0);
    }

    /**
     * Key {@code SDK_ADDON_NAME_INCORRECT}: {@code Android add-on name looks
     * incorrect: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Android add-on name looks incorrect: {0}}
     */
    public static String SDK_ADDON_NAME_INCORRECT(Object arg0) {
        return holder.format("SDK_ADDON_NAME_INCORRECT", arg0);
    }

    /**
     * Key {@code SDK_ADDON_NAME_INCORRECT}: {@code Android add-on name looks
     * incorrect: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Android add-on name looks incorrect: {0}}
     */
    public static Localizable _SDK_ADDON_NAME_INCORRECT(Object arg0) {
        return new Localizable(holder, "SDK_ADDON_NAME_INCORRECT", arg0);
    }

    /**
     * Key {@code INSTALL_ANDROID_PACKAGE}: {@code Install Android package}.
     * 
     * @return
     *     {@code Install Android package}
     */
    public static String INSTALL_ANDROID_PACKAGE() {
        return holder.format("INSTALL_ANDROID_PACKAGE");
    }

    /**
     * Key {@code INSTALL_ANDROID_PACKAGE}: {@code Install Android package}.
     * 
     * @return
     *     {@code Install Android package}
     */
    public static Localizable _INSTALL_ANDROID_PACKAGE() {
        return new Localizable(holder, "INSTALL_ANDROID_PACKAGE");
    }

    /**
     * Key {@code DELAYING_START_UP}: {@code Waiting {0} seconds before
     * starting emulator...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Waiting {0} seconds before starting emulator...}
     */
    public static String DELAYING_START_UP(Object arg0) {
        return holder.format("DELAYING_START_UP", arg0);
    }

    /**
     * Key {@code DELAYING_START_UP}: {@code Waiting {0} seconds before
     * starting emulator...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Waiting {0} seconds before starting emulator...}
     */
    public static Localizable _DELAYING_START_UP(Object arg0) {
        return new Localizable(holder, "DELAYING_START_UP", arg0);
    }

    /**
     * Key {@code FAILED_TO_CREATE_FILE}: {@code Failed to create file or
     * directory: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to create file or directory: {0}}
     */
    public static String FAILED_TO_CREATE_FILE(Object arg0) {
        return holder.format("FAILED_TO_CREATE_FILE", arg0);
    }

    /**
     * Key {@code FAILED_TO_CREATE_FILE}: {@code Failed to create file or
     * directory: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to create file or directory: {0}}
     */
    public static Localizable _FAILED_TO_CREATE_FILE(Object arg0) {
        return new Localizable(holder, "FAILED_TO_CREATE_FILE", arg0);
    }

    /**
     * Key {@code ADDING_SD_CARD}: {@code Adding {0} SD card to AVD
     * ''{1}''...}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Adding {0} SD card to AVD ''{1}''...}
     */
    public static String ADDING_SD_CARD(Object arg0, Object arg1) {
        return holder.format("ADDING_SD_CARD", arg0, arg1);
    }

    /**
     * Key {@code ADDING_SD_CARD}: {@code Adding {0} SD card to AVD
     * ''{1}''...}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Adding {0} SD card to AVD ''{1}''...}
     */
    public static Localizable _ADDING_SD_CARD(Object arg0, Object arg1) {
        return new Localizable(holder, "ADDING_SD_CARD", arg0, arg1);
    }

    /**
     * Key {@code SCREEN_RESOLUTION_REQUIRED}: {@code Screen resolution is
     * required}.
     * 
     * @return
     *     {@code Screen resolution is required}
     */
    public static String SCREEN_RESOLUTION_REQUIRED() {
        return holder.format("SCREEN_RESOLUTION_REQUIRED");
    }

    /**
     * Key {@code SCREEN_RESOLUTION_REQUIRED}: {@code Screen resolution is
     * required}.
     * 
     * @return
     *     {@code Screen resolution is required}
     */
    public static Localizable _SCREEN_RESOLUTION_REQUIRED() {
        return new Localizable(holder, "SCREEN_RESOLUTION_REQUIRED");
    }

    /**
     * Key {@code FAILED_TO_DETERMINE_PROJECT_TYPE}: {@code Failed to
     * determine type of project at ''{0}''.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to determine type of project at ''{0}''.}
     */
    public static String FAILED_TO_DETERMINE_PROJECT_TYPE(Object arg0) {
        return holder.format("FAILED_TO_DETERMINE_PROJECT_TYPE", arg0);
    }

    /**
     * Key {@code FAILED_TO_DETERMINE_PROJECT_TYPE}: {@code Failed to
     * determine type of project at ''{0}''.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to determine type of project at ''{0}''.}
     */
    public static Localizable _FAILED_TO_DETERMINE_PROJECT_TYPE(Object arg0) {
        return new Localizable(holder, "FAILED_TO_DETERMINE_PROJECT_TYPE", arg0);
    }

    /**
     * Key {@code MONKEY_RESULT_CRASH}: {@code Crashed after {0} of {1}
     * events}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Crashed after {0} of {1} events}
     */
    public static String MONKEY_RESULT_CRASH(Object arg0, Object arg1) {
        return holder.format("MONKEY_RESULT_CRASH", arg0, arg1);
    }

    /**
     * Key {@code MONKEY_RESULT_CRASH}: {@code Crashed after {0} of {1}
     * events}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Crashed after {0} of {1} events}
     */
    public static Localizable _MONKEY_RESULT_CRASH(Object arg0, Object arg1) {
        return new Localizable(holder, "MONKEY_RESULT_CRASH", arg0, arg1);
    }

    /**
     * Key {@code INTERRUPTED_DURING_BOOT_COMPLETION}: {@code Interrupted
     * while waiting for emulator to finish booting.}.
     * 
     * @return
     *     {@code Interrupted while waiting for emulator to finish booting.}
     */
    public static String INTERRUPTED_DURING_BOOT_COMPLETION() {
        return holder.format("INTERRUPTED_DURING_BOOT_COMPLETION");
    }

    /**
     * Key {@code INTERRUPTED_DURING_BOOT_COMPLETION}: {@code Interrupted
     * while waiting for emulator to finish booting.}.
     * 
     * @return
     *     {@code Interrupted while waiting for emulator to finish booting.}
     */
    public static Localizable _INTERRUPTED_DURING_BOOT_COMPLETION() {
        return new Localizable(holder, "INTERRUPTED_DURING_BOOT_COMPLETION");
    }

    /**
     * Key {@code LOCALE_FORMAT_WARNING}: {@code Locale should have format:
     * ab_XY}.
     * 
     * @return
     *     {@code Locale should have format: ab_XY}
     */
    public static String LOCALE_FORMAT_WARNING() {
        return holder.format("LOCALE_FORMAT_WARNING");
    }

    /**
     * Key {@code LOCALE_FORMAT_WARNING}: {@code Locale should have format:
     * ab_XY}.
     * 
     * @return
     *     {@code Locale should have format: ab_XY}
     */
    public static Localizable _LOCALE_FORMAT_WARNING() {
        return new Localizable(holder, "LOCALE_FORMAT_WARNING");
    }

    /**
     * Key {@code ERASING_EXISTING_EMULATOR_DATA}: {@code Erasing existing
     * emulator data...}.
     * 
     * @return
     *     {@code Erasing existing emulator data...}
     */
    public static String ERASING_EXISTING_EMULATOR_DATA() {
        return holder.format("ERASING_EXISTING_EMULATOR_DATA");
    }

    /**
     * Key {@code ERASING_EXISTING_EMULATOR_DATA}: {@code Erasing existing
     * emulator data...}.
     * 
     * @return
     *     {@code Erasing existing emulator data...}
     */
    public static Localizable _ERASING_EXISTING_EMULATOR_DATA() {
        return new Localizable(holder, "ERASING_EXISTING_EMULATOR_DATA");
    }

    /**
     * Key {@code EMULATOR_RESUME_FAILED}: {@code Failed to restart emulator
     * execution; cannot continue}.
     * 
     * @return
     *     {@code Failed to restart emulator execution; cannot continue}
     */
    public static String EMULATOR_RESUME_FAILED() {
        return holder.format("EMULATOR_RESUME_FAILED");
    }

    /**
     * Key {@code EMULATOR_RESUME_FAILED}: {@code Failed to restart emulator
     * execution; cannot continue}.
     * 
     * @return
     *     {@code Failed to restart emulator execution; cannot continue}
     */
    public static Localizable _EMULATOR_RESUME_FAILED() {
        return new Localizable(holder, "EMULATOR_RESUME_FAILED");
    }

    /**
     * Key {@code EMULATOR_ALREADY_IN_USE}: {@code Emulator could not be
     * started as AVD ''{0}'' is already running on this machine}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Emulator could not be started as AVD ''{0}'' is already running
     *     on this machine}
     */
    public static String EMULATOR_ALREADY_IN_USE(Object arg0) {
        return holder.format("EMULATOR_ALREADY_IN_USE", arg0);
    }

    /**
     * Key {@code EMULATOR_ALREADY_IN_USE}: {@code Emulator could not be
     * started as AVD ''{0}'' is already running on this machine}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Emulator could not be started as AVD ''{0}'' is already running
     *     on this machine}
     */
    public static Localizable _EMULATOR_ALREADY_IN_USE(Object arg0) {
        return new Localizable(holder, "EMULATOR_ALREADY_IN_USE", arg0);
    }

    /**
     * Key {@code JOB_CONFIG_EMPTY_ABI}: {@code If using SDK Tools r25.3 or
     * higher device creation will fail if empty}.
     * 
     * @return
     *     {@code If using SDK Tools r25.3 or higher device creation will fail if
     *     empty}
     */
    public static String JOB_CONFIG_EMPTY_ABI() {
        return holder.format("JOB_CONFIG_EMPTY_ABI");
    }

    /**
     * Key {@code JOB_CONFIG_EMPTY_ABI}: {@code If using SDK Tools r25.3 or
     * higher device creation will fail if empty}.
     * 
     * @return
     *     {@code If using SDK Tools r25.3 or higher device creation will fail if
     *     empty}
     */
    public static Localizable _JOB_CONFIG_EMPTY_ABI() {
        return new Localizable(holder, "JOB_CONFIG_EMPTY_ABI");
    }

    /**
     * Key {@code INSTALLING_SDK_COMPONENTS}: {@code Installing the ''{0}''
     * SDK component(s)...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing the ''{0}'' SDK component(s)...}
     */
    public static String INSTALLING_SDK_COMPONENTS(Object arg0) {
        return holder.format("INSTALLING_SDK_COMPONENTS", arg0);
    }

    /**
     * Key {@code INSTALLING_SDK_COMPONENTS}: {@code Installing the ''{0}''
     * SDK component(s)...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing the ''{0}'' SDK component(s)...}
     */
    public static Localizable _INSTALLING_SDK_COMPONENTS(Object arg0) {
        return new Localizable(holder, "INSTALLING_SDK_COMPONENTS", arg0);
    }

    /**
     * Key {@code ERROR_MISCONFIGURED}: {@code Cannot start Android emulator
     * due to misconfiguration: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot start Android emulator due to misconfiguration: {0}}
     */
    public static String ERROR_MISCONFIGURED(Object arg0) {
        return holder.format("ERROR_MISCONFIGURED", arg0);
    }

    /**
     * Key {@code ERROR_MISCONFIGURED}: {@code Cannot start Android emulator
     * due to misconfiguration: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot start Android emulator due to misconfiguration: {0}}
     */
    public static Localizable _ERROR_MISCONFIGURED(Object arg0) {
        return new Localizable(holder, "ERROR_MISCONFIGURED", arg0);
    }

    /**
     * Key {@code UNLOCKING_SCREEN}: {@code Attempting to unlock emulator
     * screen}.
     * 
     * @return
     *     {@code Attempting to unlock emulator screen}
     */
    public static String UNLOCKING_SCREEN() {
        return holder.format("UNLOCKING_SCREEN");
    }

    /**
     * Key {@code UNLOCKING_SCREEN}: {@code Attempting to unlock emulator
     * screen}.
     * 
     * @return
     *     {@code Attempting to unlock emulator screen}
     */
    public static Localizable _UNLOCKING_SCREEN() {
        return new Localizable(holder, "UNLOCKING_SCREEN");
    }

    /**
     * Key {@code EMULATOR_SHUTDOWN_FAILED}: {@code Failed to shut down
     * emulator; the process may still be running...}.
     * 
     * @return
     *     {@code Failed to shut down emulator; the process may still be
     *     running...}
     */
    public static String EMULATOR_SHUTDOWN_FAILED() {
        return holder.format("EMULATOR_SHUTDOWN_FAILED");
    }

    /**
     * Key {@code EMULATOR_SHUTDOWN_FAILED}: {@code Failed to shut down
     * emulator; the process may still be running...}.
     * 
     * @return
     *     {@code Failed to shut down emulator; the process may still be
     *     running...}
     */
    public static Localizable _EMULATOR_SHUTDOWN_FAILED() {
        return new Localizable(holder, "EMULATOR_SHUTDOWN_FAILED");
    }

    /**
     * Key {@code LOAD_EMULATOR_SNAPSHOT}: {@code Load an Android emulator
     * snapshot}.
     * 
     * @return
     *     {@code Load an Android emulator snapshot}
     */
    public static String LOAD_EMULATOR_SNAPSHOT() {
        return holder.format("LOAD_EMULATOR_SNAPSHOT");
    }

    /**
     * Key {@code LOAD_EMULATOR_SNAPSHOT}: {@code Load an Android emulator
     * snapshot}.
     * 
     * @return
     *     {@code Load an Android emulator snapshot}
     */
    public static Localizable _LOAD_EMULATOR_SNAPSHOT() {
        return new Localizable(holder, "LOAD_EMULATOR_SNAPSHOT");
    }

    /**
     * Key {@code MONKEY_RESULT_NONE}: {@code No monkey output was provided}.
     * 
     * @return
     *     {@code No monkey output was provided}
     */
    public static String MONKEY_RESULT_NONE() {
        return holder.format("MONKEY_RESULT_NONE");
    }

    /**
     * Key {@code MONKEY_RESULT_NONE}: {@code No monkey output was provided}.
     * 
     * @return
     *     {@code No monkey output was provided}
     */
    public static Localizable _MONKEY_RESULT_NONE() {
        return new Localizable(holder, "MONKEY_RESULT_NONE");
    }

    /**
     * Key {@code SNAPSHOT_CREATION_FAILED}: {@code Snapshot creation failed;
     * will try again during the next build}.
     * 
     * @return
     *     {@code Snapshot creation failed; will try again during the next build}
     */
    public static String SNAPSHOT_CREATION_FAILED() {
        return holder.format("SNAPSHOT_CREATION_FAILED");
    }

    /**
     * Key {@code SNAPSHOT_CREATION_FAILED}: {@code Snapshot creation failed;
     * will try again during the next build}.
     * 
     * @return
     *     {@code Snapshot creation failed; will try again during the next build}
     */
    public static Localizable _SNAPSHOT_CREATION_FAILED() {
        return new Localizable(holder, "SNAPSHOT_CREATION_FAILED");
    }

    /**
     * Key {@code SNAPSHOTS_NOT_SUPPORTED}: {@code Snapshots are enabled, but
     * cannot be used as they are not supported by the current SDK Tools}.
     * 
     * @return
     *     {@code Snapshots are enabled, but cannot be used as they are not
     *     supported by the current SDK Tools}
     */
    public static String SNAPSHOTS_NOT_SUPPORTED() {
        return holder.format("SNAPSHOTS_NOT_SUPPORTED");
    }

    /**
     * Key {@code SNAPSHOTS_NOT_SUPPORTED}: {@code Snapshots are enabled, but
     * cannot be used as they are not supported by the current SDK Tools}.
     * 
     * @return
     *     {@code Snapshots are enabled, but cannot be used as they are not
     *     supported by the current SDK Tools}
     */
    public static Localizable _SNAPSHOTS_NOT_SUPPORTED() {
        return new Localizable(holder, "SNAPSHOTS_NOT_SUPPORTED");
    }

    /**
     * Key {@code COULD_NOT_CREATE_EMULATOR}: {@code Could not create Android
     * emulator: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not create Android emulator: {0}}
     */
    public static String COULD_NOT_CREATE_EMULATOR(Object arg0) {
        return holder.format("COULD_NOT_CREATE_EMULATOR", arg0);
    }

    /**
     * Key {@code COULD_NOT_CREATE_EMULATOR}: {@code Could not create Android
     * emulator: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not create Android emulator: {0}}
     */
    public static Localizable _COULD_NOT_CREATE_EMULATOR(Object arg0) {
        return new Localizable(holder, "COULD_NOT_CREATE_EMULATOR", arg0);
    }

    /**
     * Key {@code AVD_CREATION_INTERRUPTED}: {@code Interrupted while
     * creating new emulator}.
     * 
     * @return
     *     {@code Interrupted while creating new emulator}
     */
    public static String AVD_CREATION_INTERRUPTED() {
        return holder.format("AVD_CREATION_INTERRUPTED");
    }

    /**
     * Key {@code AVD_CREATION_INTERRUPTED}: {@code Interrupted while
     * creating new emulator}.
     * 
     * @return
     *     {@code Interrupted while creating new emulator}
     */
    public static Localizable _AVD_CREATION_INTERRUPTED() {
        return new Localizable(holder, "AVD_CREATION_INTERRUPTED");
    }

}
