/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.additionalmetrics;

import hudson.model.Job;
import hudson.model.Run;
import org.jenkinsci.plugins.additionalmetrics.AvgCheckoutDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.AvgDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.AvgSuccessDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.Duration;
import org.jenkinsci.plugins.additionalmetrics.FailureRateColumn;
import org.jenkinsci.plugins.additionalmetrics.FailureTimeRateColumn;
import org.jenkinsci.plugins.additionalmetrics.MaxCheckoutDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.MaxDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.MaxSuccessDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.MinCheckoutDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.MinDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.MinSuccessDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.Rate;
import org.jenkinsci.plugins.additionalmetrics.RunWithDuration;
import org.jenkinsci.plugins.additionalmetrics.StdevDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.StdevSuccessDurationColumn;
import org.jenkinsci.plugins.additionalmetrics.SuccessRateColumn;
import org.jenkinsci.plugins.additionalmetrics.SuccessTimeRateColumn;
import org.jenkinsci.plugins.additionalmetrics.UnstableRateColumn;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public record JobMetrics(Job job) {
    @Exported
    public long getAvgCheckoutDuration() {
        AvgCheckoutDurationColumn avgCheckoutDurationColumn = new AvgCheckoutDurationColumn();
        Duration avgCheckoutDuration = avgCheckoutDurationColumn.getAverageCheckoutDuration((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(avgCheckoutDuration);
    }

    @Exported
    public long getAvgDuration() {
        AvgDurationColumn avgDurationColumn = new AvgDurationColumn();
        Duration avgDuration = avgDurationColumn.getAverageDuration((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(avgDuration);
    }

    @Exported
    public long getAvgSuccessDuration() {
        AvgSuccessDurationColumn avgSuccessDurationColumn = new AvgSuccessDurationColumn();
        Duration avgSuccessDuration = avgSuccessDurationColumn.getAverageSuccessDuration((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(avgSuccessDuration);
    }

    @Exported
    public long getMaxCheckoutDuration() {
        MaxCheckoutDurationColumn maxCheckoutDurationColumn = new MaxCheckoutDurationColumn();
        RunWithDuration longestCheckoutRun = maxCheckoutDurationColumn.getLongestCheckoutRun((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(longestCheckoutRun);
    }

    @Exported
    public long getMaxDuration() {
        MaxDurationColumn maxDurationColumn = new MaxDurationColumn();
        RunWithDuration longestRun = maxDurationColumn.getLongestRun((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(longestRun);
    }

    @Exported
    public long getMaxSuccessDuration() {
        MaxSuccessDurationColumn maxSuccessDurationColumn = new MaxSuccessDurationColumn();
        RunWithDuration longestSuccessfulRun = maxSuccessDurationColumn.getLongestSuccessfulRun((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(longestSuccessfulRun);
    }

    @Exported
    public long getMinCheckoutDuration() {
        MinCheckoutDurationColumn minCheckoutDurationColumn = new MinCheckoutDurationColumn();
        RunWithDuration shortestCheckoutRun = minCheckoutDurationColumn.getShortestCheckoutRun((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(shortestCheckoutRun);
    }

    @Exported
    public long getMinDuration() {
        MinDurationColumn minDurationColumn = new MinDurationColumn();
        RunWithDuration shortestRun = minDurationColumn.getShortestRun((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(shortestRun);
    }

    @Exported
    public long getMinSuccessDuration() {
        MinSuccessDurationColumn minSuccessDurationColumn = new MinSuccessDurationColumn();
        RunWithDuration shortestSuccessfulRun = minSuccessDurationColumn.getShortestSuccessfulRun((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(shortestSuccessfulRun);
    }

    @Exported
    public double getSuccessRate() {
        SuccessRateColumn successRateColumn = new SuccessRateColumn();
        Rate successRate = successRateColumn.getSuccessRate((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.rateOrDefaultToZero(successRate);
    }

    @Exported
    public double getFailureRate() {
        FailureRateColumn failureRateColumn = new FailureRateColumn();
        Rate failureRate = failureRateColumn.getFailureRate((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.rateOrDefaultToZero(failureRate);
    }

    @Exported
    public double getSuccessTimeRate() {
        SuccessTimeRateColumn successTimeRateColumn = new SuccessTimeRateColumn();
        Rate successTimeRate = successTimeRateColumn.getSuccessTimeRate((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.rateOrDefaultToZero(successTimeRate);
    }

    @Exported
    public double getFailureTimeRate() {
        FailureTimeRateColumn failureTimeRateColumn = new FailureTimeRateColumn();
        Rate failureTimeRate = failureTimeRateColumn.getFailureTimeRate((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.rateOrDefaultToZero(failureTimeRate);
    }

    @Exported
    public long getStandardDeviationDuration() {
        StdevDurationColumn stdevDurationColumn = new StdevDurationColumn();
        Duration standardDeviationDuration = stdevDurationColumn.getStdevDuration((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(standardDeviationDuration);
    }

    @Exported
    public long getStandardDeviationSuccessDuration() {
        StdevSuccessDurationColumn stdevSuccessDurationColumn = new StdevSuccessDurationColumn();
        Duration standardDeviationSuccessDuration = stdevSuccessDurationColumn.getStdevSuccessDuration((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.durationOrDefaultToZero(standardDeviationSuccessDuration);
    }

    @Exported
    public double getUnstableRate() {
        UnstableRateColumn unstableRateColumn = new UnstableRateColumn();
        Rate unstableRate = unstableRateColumn.getUnstableRate((Job<? extends Job, ? extends Run>)this.job);
        return JobMetrics.rateOrDefaultToZero(unstableRate);
    }

    private static double rateOrDefaultToZero(Rate rate) {
        if (rate != null) {
            return rate.getAsDouble();
        }
        return 0.0;
    }

    private static long durationOrDefaultToZero(Duration duration) {
        if (duration != null) {
            return duration.getAsLong();
        }
        return 0L;
    }

    private static long durationOrDefaultToZero(RunWithDuration runWithDuration) {
        if (runWithDuration != null) {
            return runWithDuration.duration().getAsLong();
        }
        return 0L;
    }
}

