/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.CacheKey;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.crypto.bcrypt.BCrypt;

@Restricted(value={NoExternalUse.class})
public final class CacheUtil {
    private static final int BCRYPT_MAX_LENGTH = 72;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean NO_CACHE_AUTH = Boolean.getBoolean(CacheUtil.class.getName() + ".noCacheAuth");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int BCRYPT_ROUNDS = Integer.getInteger(CacheUtil.class.getName() + ".bcryptLogRounds", 10);
    private static final SecureRandom RANDOM = new SecureRandom();

    private CacheUtil() {
    }

    @CheckForNull
    public static CacheKey computeCacheKey(@NonNull String username, @NonNull AbstractActiveDirectoryAuthenticationProvider.Password password, Set<CacheKey> existingKeys) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        if (password instanceof AbstractActiveDirectoryAuthenticationProvider.UserPassword) {
            if (NO_CACHE_AUTH) {
                return null;
            }
            CacheKey existingKey = CacheUtil.findExistingKeyForUserAndPasswordInSet(username, ((AbstractActiveDirectoryAuthenticationProvider.UserPassword)password).getPassword(), existingKeys);
            if (existingKey != null) {
                return existingKey;
            }
            String salt = CacheUtil.computeSalt();
            String passwordHash = CacheUtil.computeHash(((AbstractActiveDirectoryAuthenticationProvider.UserPassword)password).getPassword(), salt);
            return new CacheKey(username, salt, passwordHash);
        }
        return new CacheKey(username);
    }

    private static String computeHash(@NonNull String password, String salt) {
        return BCrypt.hashpw((String)password, (String)salt);
    }

    private static CacheKey findExistingKeyForUserAndPasswordInSet(String username, String password, Set<CacheKey> existingKeys) {
        for (CacheKey key : existingKeys) {
            if (key.getSalt() == null || key.getPasswordHash() == null || !Objects.equals(key.getUsername(), username)) continue;
            byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
            if (passwordBytes.length > 72) {
                passwordBytes = Arrays.copyOfRange(passwordBytes, 0, 72);
            }
            if (!BCrypt.checkpw((byte[])passwordBytes, (String)key.getPasswordHash())) continue;
            return key;
        }
        return null;
    }

    private static String computeSalt() {
        return BCrypt.gensalt((int)BCRYPT_ROUNDS);
    }
}

