/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.github.benmanes.caffeine.cache.Cache;
import com4j.COM4J;
import com4j.Com4jObject;
import com4j.ComException;
import com4j.ComObjectListener;
import com4j.ExecutionException;
import com4j.Variant;
import com4j.typelibs.activeDirectory.IADs;
import com4j.typelibs.activeDirectory.IADsGroup;
import com4j.typelibs.activeDirectory.IADsOpenDSObject;
import com4j.typelibs.activeDirectory.IADsUser;
import com4j.typelibs.ado20.ClassFactory;
import com4j.typelibs.ado20.Property;
import com4j.typelibs.ado20._Command;
import com4j.typelibs.ado20._Connection;
import com4j.typelibs.ado20._Recordset;
import com4j.util.ComObjectCollector;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryGroupDetails;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.plugins.active_directory.CacheAuthenticationException;
import hudson.plugins.active_directory.CacheConfiguration;
import hudson.plugins.active_directory.CacheKey;
import hudson.plugins.active_directory.CacheUtil;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ActiveDirectoryAuthenticationProvider
extends AbstractActiveDirectoryAuthenticationProvider {
    private static boolean ALLOW_EMPTY_PASSWORD = Boolean.getBoolean(ActiveDirectoryAuthenticationProvider.class.getName() + ".ALLOW_EMPTY_PASSWORD");
    @Restricted(value={NoExternalUse.class})
    static final String ADSI_FLAGS_SYSTEM_PROPERTY_NAME = ActiveDirectoryAuthenticationProvider.class.getName() + ".ADSI_FLAGS_OVERRIDE";
    @Restricted(value={NoExternalUse.class})
    static final String ADSI_PASSWORDLESS_FLAGS_SYSTEM_PROPERTY_NAME = ActiveDirectoryAuthenticationProvider.class.getName() + ".ADSI_PASSWORDLESS_FLAGS_OVERRIDE";
    private final String defaultNamingContext;
    private final _Connection con;
    private CacheConfiguration cache;
    private final Cache<CacheKey, UserDetails> userCache;
    private final Cache<String, ActiveDirectoryGroupDetails> groupCache;
    private final int ADSI_FLAGS;
    private final int ADSI_PASSWORDLESS_FLAGS;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryAuthenticationProvider.class.getName());
    private static final int ADS_SECURE_AUTHENTICATION = 1;
    private static final int ADS_USE_SSL = 2;
    private static final int ADS_READONLY_SERVER = 4;
    private static final int ADS_USE_SIGNING = 64;
    private static final int ADS_USE_SEALING = 128;
    private static final int DEFAULT_NON_TLS_FLAGS = 196;
    private static final int DEFAULT_TLS_FLAGS = 6;

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public ActiveDirectoryAuthenticationProvider() throws IOException {
        this(null);
    }

    public ActiveDirectoryAuthenticationProvider(ActiveDirectorySecurityRealm realm) throws AuthenticationException {
        Integer adsi_override_flags = Integer.getInteger(ADSI_FLAGS_SYSTEM_PROPERTY_NAME);
        if (adsi_override_flags != null) {
            LOGGER.log(Level.INFO, () -> String.format(Locale.ROOT, "ADSI_FLAGS_OVERRIDE set, use the following as the flags for ADSI: 0x%1$04X", adsi_override_flags));
            LOGGER.log(Level.INFO, "See https://www.jenkins.io/redirect/plugin/active-directory/iads-ads_authentication_enum for full flag details.");
            this.ADSI_FLAGS = adsi_override_flags;
        } else {
            this.ADSI_FLAGS = realm == null ? 6 : (realm.getRequireTLS() != false ? 6 : 196);
        }
        Integer adsi_passwordless_override_flags = Integer.getInteger(ADSI_PASSWORDLESS_FLAGS_SYSTEM_PROPERTY_NAME);
        if (adsi_passwordless_override_flags != null) {
            LOGGER.log(Level.INFO, () -> String.format(Locale.ROOT, "ADSI_PASSWORDLESS_FLAGS_OVERRIDE set, use the following as the flags for passwordless ADSI: 0x%1$04X", adsi_passwordless_override_flags));
            LOGGER.log(Level.INFO, "See https://www.jenkins.io/redirect/plugin/active-directory/iads-ads_authentication_enum for full flag details.");
            this.ADSI_PASSWORDLESS_FLAGS = adsi_passwordless_override_flags;
        } else {
            this.ADSI_PASSWORDLESS_FLAGS = this.ADSI_FLAGS | 1;
        }
        try {
            IADsOpenDSObject dso = (IADsOpenDSObject)COM4J.getObject(IADsOpenDSObject.class, (String)"LDAP:", null);
            IADs rootDSE = (IADs)dso.openDSObject("LDAP://RootDSE", null, null, this.ADSI_PASSWORDLESS_FLAGS).queryInterface(IADs.class);
            this.defaultNamingContext = (String)rootDSE.get("defaultNamingContext");
            LOGGER.info("Active Directory domain is " + this.defaultNamingContext);
            this.con = ClassFactory.createConnection();
            this.con.provider("ADsDSOObject");
            Property property = this.con.properties((Object)"ADSI Flag");
            property.value((Object)this.ADSI_PASSWORDLESS_FLAGS);
            this.con.open("Active Directory Provider", "", "", -1);
            if (realm != null) {
                this.cache = realm.cache;
            }
            if (this.cache == null) {
                this.cache = new CacheConfiguration(0, 0);
            }
            if (this.cache.getUserCache() == null || this.cache.getGroupCache() == null) {
                this.cache = new CacheConfiguration(this.cache.getSize(), this.cache.getTtl());
            }
            this.userCache = this.cache.getUserCache();
            this.groupCache = this.cache.getGroupCache();
        }
        catch (ExecutionException e) {
            throw new AuthenticationServiceException("Failed to connect to Active Directory. Does this machine belong to Active Directory?", (Throwable)e);
        }
    }

    static String dnToLdapUrl(String dn) {
        return "LDAP://" + dn.replace("/", "\\/");
    }

    @Override
    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            AbstractActiveDirectoryAuthenticationProvider.Password password;
            if (authentication == null) {
                password = AbstractActiveDirectoryAuthenticationProvider.NoAuthentication.INSTANCE;
            } else {
                String userPassword = (String)authentication.getCredentials();
                if (!ALLOW_EMPTY_PASSWORD && StringUtils.isEmpty((String)userPassword)) {
                    LOGGER.log(Level.FINE, "Empty password not allowed was tried by user {0}", username);
                    throw new BadCredentialsException("Empty password not allowed");
                }
                password = new AbstractActiveDirectoryAuthenticationProvider.UserPassword(userPassword);
            }
            CacheKey cacheKey = CacheUtil.computeCacheKey(username, password, this.userCache.asMap().keySet());
            Function<CacheKey, UserDetails> userDetailsFunction = cacheKey1 -> {
                String dn = this.getDnOfUserOrGroup(username);
                ComObjectCollector col = new ComObjectCollector();
                COM4J.addListener((ComObjectListener)col);
                try {
                    IADsUser usr;
                    IADsOpenDSObject dso = (IADsOpenDSObject)COM4J.getObject(IADsOpenDSObject.class, (String)"LDAP:", null);
                    try {
                        usr = (IADsUser)(authentication == null ? dso.openDSObject(ActiveDirectoryAuthenticationProvider.dnToLdapUrl(dn), null, null, this.ADSI_PASSWORDLESS_FLAGS) : dso.openDSObject(ActiveDirectoryAuthenticationProvider.dnToLdapUrl(dn), dn, ((AbstractActiveDirectoryAuthenticationProvider.UserPassword)password).getPassword(), this.ADSI_FLAGS)).queryInterface(IADsUser.class);
                    }
                    catch (ComException e) {
                        String msg = String.format("Incorrect password for %s DN=%s: error=%08X", username, dn, e.getHRESULT());
                        LOGGER.log(Level.FINE, String.format("Login failure: Incorrect password for %s DN=%s: error=%08X", username, dn, e.getHRESULT()), e);
                        throw new BadCredentialsException(msg, (Throwable)e);
                    }
                    if (usr == null) {
                        throw new UsernameNotFoundException("User not found: " + username);
                    }
                    ArrayList<Object> groups = new ArrayList<Object>();
                    for (Com4jObject g : usr.groups()) {
                        if (g == null) continue;
                        IADsGroup grp = (IADsGroup)g.queryInterface(IADsGroup.class);
                        groups.add(new SimpleGrantedAuthority(grp.name().substring(3)));
                    }
                    groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
                    LOGGER.log(Level.FINE, "Login successful: {0} dn={1}", new Object[]{username, dn});
                    Iterator iterator = new ActiveDirectoryUserDetail(username, "redacted", !this.isAccountDisabled(usr), true, true, true, groups, this.getFullName(usr), this.getEmailAddress(usr), this.getTelephoneNumber(usr)).updateUserInfo();
                    return iterator;
                }
                finally {
                    col.disposeAll();
                    COM4J.removeListener((ComObjectListener)col);
                }
            };
            return cacheKey == null ? userDetailsFunction.apply(null) : (UserDetails)this.userCache.get((Object)cacheKey, userDetailsFunction);
        }
        catch (Exception e) {
            if (e instanceof AuthenticationException) {
                throw (AuthenticationException)e;
            }
            Throwable t = e.getCause();
            if (t instanceof AuthenticationException) {
                throw (AuthenticationException)t;
            }
            LOGGER.log(Level.SEVERE, String.format("There was a problem caching user %s", username), e);
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching user " + username, e);
        }
    }

    private String getTelephoneNumber(IADsUser usr) {
        try {
            Object t = usr.telephoneNumber();
            return t == null ? null : t.toString();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private String getEmailAddress(IADsUser usr) {
        try {
            return usr.emailAddress();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private String getFullName(IADsUser usr) {
        try {
            return usr.fullName();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private boolean isAccountDisabled(IADsUser usr) {
        try {
            return usr.accountDisabled();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return false;
            }
            throw e;
        }
    }

    private String getDnOfUserOrGroup(String userOrGroupname) throws UsernameNotFoundException {
        _Command cmd = ClassFactory.createCommand();
        cmd.activeConnection(this.con);
        cmd.commandText("<LDAP://" + this.defaultNamingContext + ">;(sAMAccountName=" + userOrGroupname + ");distinguishedName;subTree");
        _Recordset rs = cmd.execute(null, (Object)Variant.getMissing(), -1);
        if (rs.eof()) {
            throw new UsernameNotFoundException("No such user or group: " + userOrGroupname);
        }
        String dn = rs.fields().item((Object)"distinguishedName").value().toString();
        return dn;
    }

    @Override
    public GroupDetails loadGroupByGroupname(String groupname) {
        try {
            return (GroupDetails)this.groupCache.get((Object)groupname, s -> {
                ComObjectCollector col = new ComObjectCollector();
                COM4J.addListener((ComObjectListener)col);
                try {
                    String dn = this.getDnOfUserOrGroup(groupname);
                    IADsOpenDSObject dso = (IADsOpenDSObject)COM4J.getObject(IADsOpenDSObject.class, (String)"LDAP:", null);
                    IADsGroup group = (IADsGroup)dso.openDSObject(ActiveDirectoryAuthenticationProvider.dnToLdapUrl(dn), null, null, this.ADSI_PASSWORDLESS_FLAGS).queryInterface(IADsGroup.class);
                    if (group == null) {
                        throw new UserMayOrMayNotExistException2(groupname);
                    }
                    ActiveDirectoryGroupDetails activeDirectoryGroupDetails = new ActiveDirectoryGroupDetails(groupname);
                    return activeDirectoryGroupDetails;
                }
                catch (UsernameNotFoundException e) {
                    throw new UsernameNotFoundException("Failed to get the DN of the group " + groupname);
                }
                catch (ComException e) {
                    LOGGER.log(Level.WARNING, String.format("Failed to figure out details of AD group: %s", groupname), e);
                    throw new UserMayOrMayNotExistException2(groupname);
                }
                finally {
                    col.disposeAll();
                    COM4J.removeListener((ComObjectListener)col);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof AuthenticationException) {
                throw (AuthenticationException)e;
            }
            Throwable t = e.getCause();
            if (t instanceof AuthenticationException) {
                throw (AuthenticationException)t;
            }
            LOGGER.log(Level.SEVERE, String.format("There was a problem caching group %s", groupname), e);
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching group " + groupname, e);
        }
    }
}

