/*
 * Decompiled with CFR 0.152.
 */
package com.absint.astree;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class StatusPoller
extends Thread {
    private static long INITIAL_DELAY = 1000L;
    private static String OFF_MSG = "[NOTE] Analyzer log not available in console. Analysis may be running on a remote machine.\n";
    private long interval;
    private boolean alive = true;
    private TaskListener listener;
    private FilePath log;

    StatusPoller(long interval, TaskListener listener, FilePath log) {
        this.interval = interval;
        this.listener = listener;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean active = true;
        boolean exceptionCaught = false;
        RandomAccessFile fileHandler = null;
        StringBuilder sb = null;
        long lpos = 0L;
        try {
            StatusPoller.sleep(INITIAL_DELAY);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (active && !exceptionCaught) {
            if (!this.alive) {
                active = false;
            }
            try {
                StatusPoller.sleep(this.interval);
                fileHandler = new RandomAccessFile(new File(this.log.getRemote()), "r");
                if (fileHandler.length() == 0L) continue;
                long cpos = fileHandler.length() - 1L;
                sb = new StringBuilder();
                for (long filePointer = lpos; filePointer <= cpos; ++filePointer) {
                    fileHandler.seek(filePointer);
                    sb.append((char)fileHandler.readByte());
                }
                lpos = cpos;
                this.listener.getLogger().print(sb.toString());
            }
            catch (InterruptedException filePointer) {
            }
            catch (FileNotFoundException e) {
                if (!exceptionCaught) {
                    this.listener.getLogger().print(OFF_MSG);
                }
                exceptionCaught = true;
            }
            catch (IOException e) {
                if (!exceptionCaught) {
                    this.listener.getLogger().print(OFF_MSG);
                }
                exceptionCaught = true;
            }
            finally {
                if (fileHandler == null) continue;
                try {
                    fileHandler.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void kill() {
        this.alive = false;
    }
}

