/*
 * Decompiled with CFR 0.152.
 */
package com.absint.astree;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AstreeReportParser
extends IssueParser {
    private static final long serialVersionUID = 1L;

    public boolean accepts(ReaderFactory readerFactory) {
        return this.isXmlFile(readerFactory);
    }

    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        IssueBuilder issueBuilder = new IssueBuilder();
        Handler handler = new Handler();
        readerFactory.parse((DefaultHandler)handler);
        issueBuilder.setReference(handler.projectDescription);
        Report report = new Report();
        report.setOriginReportFile(readerFactory.getFileName());
        StringBuilder descriptionBuilder = new StringBuilder();
        StringBuilder categoryBuilder = new StringBuilder();
        for (Message message : handler.messages) {
            AlarmType type;
            String context;
            String code = handler.codeSnippets.get(message.locationID);
            if (code != null && !code.isEmpty()) {
                descriptionBuilder.append("<p>Code:</p><pre>");
                descriptionBuilder.append(code);
                descriptionBuilder.append("</pre>");
            }
            if ((context = message.context) != null && !context.isEmpty()) {
                descriptionBuilder.append("<p>Context:</p><pre>");
                descriptionBuilder.append(context);
                descriptionBuilder.append("</pre>");
            }
            if ((type = handler.types.get(message.typeID)) == null) {
                throw new ParsingException("Missing finding category " + message.typeID, new Object[0]);
            }
            String category = handler.categories.get(type.categoryID);
            if (category == null) {
                throw new ParsingException("Missing finding group " + type.categoryID, new Object[0]);
            }
            categoryBuilder.append(type.type);
            categoryBuilder.append(" [");
            categoryBuilder.append(category);
            categoryBuilder.append(']');
            Location location = handler.locations.get(message.locationID);
            if (location == null) {
                location = new Location();
            }
            issueBuilder.setMessage(message.text).setFileName(handler.files.get(location.fileID)).setLineStart(location.startLine).setLineEnd(location.endLine).setColumnStart(location.startColumn).setColumnEnd(location.endColumn).setCategory(categoryBuilder.toString()).setDescription(descriptionBuilder.toString()).setSeverity(message.severity);
            report.add(issueBuilder.build());
            descriptionBuilder.setLength(0);
            categoryBuilder.setLength(0);
        }
        issueBuilder.close();
        return report;
    }

    private static class Handler
    extends DefaultHandler {
        public String projectDescription;
        public Map<String, String> categories = new HashMap<String, String>();
        public Map<String, AlarmType> types = new HashMap<String, AlarmType>();
        public Map<String, String> codeSnippets = new HashMap<String, String>();
        public Map<String, String> files = new HashMap<String, String>();
        public Map<String, Location> locations = new HashMap<String, Location>();
        public List<Message> messages = new ArrayList<Message>();
        private String currentId;
        private Message currentMessage;
        private AlarmType currentAlarmType;
        private boolean collectCurrentCharacters = false;
        private StringBuilder currentCharacters = new StringBuilder();
        private StringBuilder auxiliaryStringBuilder = new StringBuilder();

        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("alarm_category") || qName.equals("category_group")) {
                this.currentId = attributes.getValue("id");
                this.collectCurrentCharacters = true;
            } else if (qName.equals("alarm_type")) {
                this.currentId = attributes.getValue("id");
                this.currentAlarmType = new AlarmType();
                this.currentAlarmType.categoryID = attributes.getValue("category_id");
                this.collectCurrentCharacters = true;
            } else if (qName.equals("finding_category")) {
                this.currentId = attributes.getValue("finding_key");
                this.currentAlarmType = new AlarmType();
                this.currentAlarmType.categoryID = attributes.getValue("category_group_id");
                this.collectCurrentCharacters = true;
            } else if (qName.equals("code-snippet")) {
                this.currentId = attributes.getValue("location_id");
            } else if (qName.equals("line") || qName.equals("textline")) {
                this.collectCurrentCharacters = true;
            } else if (qName.equals("file")) {
                this.files.put(attributes.getValue("id"), attributes.getValue("name"));
            } else if (qName.equals("location")) {
                Location location = new Location();
                location.fileID = attributes.getValue("p_file");
                location.startLine = attributes.getValue("p_start_line");
                location.endLine = attributes.getValue("p_end_line");
                location.startColumn = attributes.getValue("p_start_col");
                location.endColumn = attributes.getValue("p_end_col");
                this.locations.put(attributes.getValue("id"), location);
            } else if (qName.equals("finding")) {
                if (attributes.getValue("duplicate").equals("1")) {
                    return;
                }
                this.currentMessage = new Message();
                this.currentMessage.locationID = attributes.getValue("location_id");
                this.currentMessage.typeID = attributes.getValue("key");
                this.currentMessage.context = attributes.getValue("context");
                this.currentMessage.severity = attributes.getValue("kind").equals("alarm") ? Severity.WARNING_HIGH : Severity.ERROR;
            } else if (qName.equals("alarm_message") || qName.equals("error_message") || qName.equals("note_message")) {
                if (attributes.getValue("duplicate").equals("1")) {
                    return;
                }
                this.currentMessage = new Message();
                this.currentMessage.locationID = attributes.getValue("location_id");
                this.currentMessage.typeID = attributes.getValue("type");
                this.currentMessage.context = attributes.getValue("context");
                this.currentMessage.severity = qName.equals("alarm_message") ? Severity.WARNING_HIGH : (qName.equals("error_message") ? Severity.ERROR : Severity.WARNING_LOW);
            } else if (qName.equals("project")) {
                this.projectDescription = attributes.getValue("description");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("alarm_category") || qName.equals("category_group")) {
                this.categories.put(this.currentId, this.currentCharacters.toString());
                this.currentId = null;
                this.collectCurrentCharacters = false;
                this.currentCharacters.setLength(0);
            } else if (qName.equals("alarm_type") || qName.equals("finding_category")) {
                this.currentAlarmType.type = this.currentCharacters.toString();
                this.types.put(this.currentId, this.currentAlarmType);
                this.currentId = null;
                this.currentAlarmType = null;
                this.collectCurrentCharacters = false;
                this.currentCharacters.setLength(0);
            } else if (qName.equals("code-snippet")) {
                this.codeSnippets.put(this.currentId, this.auxiliaryStringBuilder.toString());
                this.currentId = null;
                this.auxiliaryStringBuilder.setLength(0);
            } else if (qName.equals("line") || qName.equals("textline")) {
                if (this.auxiliaryStringBuilder.length() != 0) {
                    if (qName.equals("textline")) {
                        this.auxiliaryStringBuilder.append("<br>");
                    } else {
                        this.auxiliaryStringBuilder.append('\n');
                    }
                }
                this.auxiliaryStringBuilder.append(StringEscapeUtils.escapeHtml4((String)this.currentCharacters.toString()));
                this.collectCurrentCharacters = false;
                this.currentCharacters.setLength(0);
            } else if (qName.equals("finding") || qName.equals("alarm_message") || qName.equals("error_message") || qName.equals("note_message")) {
                if (this.currentMessage != null) {
                    this.currentMessage.text = this.auxiliaryStringBuilder.toString();
                    this.messages.add(this.currentMessage);
                }
                this.currentMessage = null;
                this.auxiliaryStringBuilder.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.collectCurrentCharacters) {
                this.currentCharacters.append(ch, start, length);
            }
        }
    }

    private static class Message {
        public String locationID;
        public String typeID;
        public String context;
        public String text;
        public Severity severity;

        private Message() {
        }
    }

    private static class AlarmType {
        public String categoryID;
        public String type;

        private AlarmType() {
        }
    }

    private static class Location {
        public String fileID;
        public String startLine;
        public String endLine;
        public String startColumn;
        public String endColumn;

        private Location() {
        }
    }
}

