/*
 * Decompiled with CFR 0.152.
 */
package com.absint.astree;

import com.absint.astree.AnalysisServerConfiguration;
import com.absint.astree.AnalysisSummary;
import com.absint.astree.FailonSwitch;
import com.absint.astree.StatusPoller;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AstreeBuilder
extends Builder
implements SimpleBuildStep {
    private static final String PLUGIN_NAME = "Astr\u00e9e for C Jenkins PlugIn";
    private static final String BUILD_NR = "24.10";
    private static final String TMP_REPORT_FILE = "absint_astree_analysis_report";
    private static final String TMP_PREPROCESS_OUTPUT = "absint_astree_preprocess_output.txt";
    private String dax_file;
    private String output_dir;
    private String analysis_id;
    private FailonSwitch failonswitch;
    private boolean genXMLOverview;
    private boolean genXMLCoverage;
    private boolean genXMLAlarmsByOccurence;
    private boolean genXMLAlarmsByCategory;
    private boolean genXMLAlarmsByFile;
    private boolean genXMLRulechecks;
    private boolean genPreprocessOutput;
    private boolean dropAnalysis;
    private boolean skip_analysis;
    private Proc proc;

    @DataBoundConstructor
    public AstreeBuilder(String dax_file, String analysis_id, String output_dir, boolean skip_analysis, boolean genXMLOverview, boolean genXMLCoverage, boolean genXMLAlarmsByOccurence, boolean genXMLAlarmsByCategory, boolean genXMLAlarmsByFile, boolean genXMLRulechecks, boolean dropAnalysis, boolean genPreprocessOutput, FailonSwitch failonswitch, AnalysisServerConfiguration analysisSrv) {
        this.dax_file = dax_file;
        this.analysis_id = analysis_id;
        this.output_dir = output_dir;
        this.skip_analysis = skip_analysis;
        this.failonswitch = failonswitch;
        this.genXMLOverview = genXMLOverview;
        this.genXMLCoverage = genXMLCoverage;
        this.genXMLAlarmsByOccurence = genXMLAlarmsByOccurence;
        this.genXMLAlarmsByCategory = genXMLAlarmsByCategory;
        this.genXMLAlarmsByFile = genXMLAlarmsByFile;
        this.genXMLRulechecks = genXMLRulechecks;
        this.dropAnalysis = dropAnalysis;
        this.genPreprocessOutput = genPreprocessOutput;
    }

    public String getDax_file() {
        return this.dax_file;
    }

    public String getAnalysis_id() {
        return this.analysis_id;
    }

    public String getOutput_dir() {
        return this.output_dir;
    }

    public boolean isFailonswitch() {
        return this.failonswitch != null;
    }

    public String getFailon() {
        if (this.failonswitch == null) {
            return "";
        }
        return this.failonswitch.getFailon();
    }

    public boolean isSkip_analysis() {
        return this.skip_analysis;
    }

    public boolean isGenXMLOverview() {
        return this.genXMLOverview;
    }

    public boolean isGenXMLCoverage() {
        return this.genXMLCoverage;
    }

    public boolean isGenXMLAlarmsByOccurence() {
        return this.genXMLAlarmsByOccurence;
    }

    public boolean isGenXMLAlarmsByCategory() {
        return this.genXMLAlarmsByCategory;
    }

    public boolean isGenXMLAlarmsByFile() {
        return this.genXMLAlarmsByFile;
    }

    public boolean isGenXMLRulechecks() {
        return this.genXMLRulechecks;
    }

    public boolean isGenPreprocessOutput() {
        return this.genPreprocessOutput;
    }

    public boolean isDropAnalysis() {
        return this.dropAnalysis;
    }

    private static final String expandEnvironmentVarsHelper(String cmdln, Map<String, String> envMap, boolean isUnix) {
        String pattern = "\\$\\{([A-Za-z_][A-Za-z0-9_]*)\\}";
        Pattern expr = Pattern.compile("\\$\\{([A-Za-z_][A-Za-z0-9_]*)\\}");
        Matcher matcher = expr.matcher(cmdln);
        while (matcher.find()) {
            String envValue = envMap.get(matcher.group(1).toUpperCase());
            envValue = envValue == null ? "" : envValue.replace("\\", "\\\\");
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            cmdln = subexpr.matcher(cmdln).replaceAll(envValue);
        }
        if (isUnix) {
            return cmdln.replace('\\', '/');
        }
        return cmdln.replace('/', '\\');
    }

    private ArgumentListBuilder constructCommandLineCall(String reportfile, EnvVars envVars, boolean isUnix, FilePath preprocessOutput) {
        ArgumentListBuilder builder = new ArgumentListBuilder();
        builder.add(this.getDescriptor().getAlauncher());
        builder.add("-b");
        builder.add(new String[]{"-s", AstreeBuilder.expandEnvironmentVarsHelper(this.getDescriptor().getAstree_server(), (Map<String, String>)envVars, isUnix)});
        if (this.analysis_id != null && !this.analysis_id.trim().isEmpty()) {
            builder.add(new String[]{"--id", AstreeBuilder.expandEnvironmentVarsHelper(this.analysis_id, (Map<String, String>)envVars, isUnix)});
        }
        if (this.dax_file != null && !this.dax_file.trim().isEmpty()) {
            builder.add(new String[]{"--import", AstreeBuilder.expandEnvironmentVarsHelper(this.dax_file, (Map<String, String>)envVars, isUnix)});
        }
        builder.add(new String[]{"--report-file", reportfile + ".txt"});
        builder.add(new String[]{"--xml-report-file", reportfile + ".xml"});
        if (this.genPreprocessOutput) {
            builder.add(new String[]{"--preprocess-report-file", preprocessOutput.getRemote()});
        }
        if (this.dropAnalysis) {
            builder.add("--drop");
        }
        return builder;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        int exitCode = -1;
        if (this.output_dir == null || this.output_dir.equals("")) {
            this.output_dir = workspace.toString();
        }
        String reportfile = workspace.toString() + (launcher.isUnix() ? "/" : "\\") + TMP_REPORT_FILE;
        try {
            listener.getLogger().println("This is Astr\u00e9e for C Jenkins PlugIn in version 24.10");
            FilePath rfile = new FilePath(workspace, "absint_astree_analysis_report.txt");
            if (rfile.delete()) {
                listener.getLogger().println("Old log file erased.");
            }
            rfile.touch(System.currentTimeMillis());
            listener.getLogger().println("New log file created.");
            StatusPoller sp = new StatusPoller(1000L, listener, rfile);
            if (this.skip_analysis) {
                listener.getLogger().println("Analysis run has been (temporarily) deactivated. Skipping analysis run.");
                return;
            }
            if (this.failonswitch != null) {
                listener.getLogger().println("Astr\u00e9e fails build on " + this.failonswitch.getFailon());
            }
            Object infoStringSummaryDest = "Summary reports will be generated in " + this.output_dir;
            infoStringSummaryDest = AstreeBuilder.expandEnvironmentVarsHelper("Summary reports will be generated in " + this.output_dir, (Map<String, String>)build.getEnvironment(listener), launcher.isUnix());
            listener.getLogger().println((String)infoStringSummaryDest);
            EnvVars envVars = build.getEnvironment(listener);
            if (!this.getDescriptor().getUser().trim().isEmpty() && !this.getDescriptor().getPassword().trim().isEmpty()) {
                envVars.put("A3_SERVER_USER", this.getDescriptor().getUser());
                envVars.put("A3_SERVER_PASSWORD", this.getDescriptor().getPassword());
            }
            sp.start();
            this.proc = launcher.launch().cmds(this.constructCommandLineCall(reportfile, build.getEnvironment(listener), launcher.isUnix(), workspace.child(TMP_PREPROCESS_OUTPUT))).envs((Map)envVars).stdout((OutputStream)listener.getLogger()).pwd(workspace).start();
            exitCode = this.proc.join();
            sp.kill();
            sp.join();
            if (exitCode == 0) {
                listener.getLogger().println("Analysis run succeeded.");
            } else {
                listener.getLogger().println("Analysis run failed.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.getLogger().println("IOException caught during analysis run.");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            listener.getLogger().println("InterruptedException caught during analysis run.");
        }
        if (exitCode == 0) {
            AnalysisSummary summary = AnalysisSummary.readFromReportFile(reportfile + ".txt");
            if (this.failonswitch != null && this.failonswitch.failOnErrors() && summary.getNumberOfErrors() > 0) {
                listener.getLogger().println("Errors reported! Number of errors: " + summary.getNumberOfErrors());
                build.setResult(Result.FAILURE);
            } else if (this.failonswitch != null && this.failonswitch.failOnAlarms() && summary.getNumberOfAlarms() > 0) {
                listener.getLogger().println("Alarms reported! Number of alarms: " + summary.getNumberOfAlarms());
                build.setResult(Result.FAILURE);
            } else if (this.failonswitch != null && this.failonswitch.failOnFlowAnomalies() && summary.getNumberOfFlowAnomalies() + summary.getNumberOfAlarms() > 0) {
                build.setResult(Result.FAILURE);
            }
        } else {
            build.setResult(Result.FAILURE);
        }
    }

    protected void finalize() {
        try {
            if (this.proc != null) {
                this.proc.kill();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private void copyText2PrintStream(PrintStream dest, String srcPath) {
        dest.println("Appending analysis report.");
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcPath), "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                dest.println(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String alauncher;
        private String astree_server;
        private String user;
        private String password;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Astr\u00e9e Analysis Run";
        }

        public FormValidation doCheckAstree_server(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.trim().equals("")) {
                return FormValidation.error((String)"Please set a valid server of form <hostname>:<port>");
            }
            if (!value.matches("[a-zA-Z][a-zA-Z0-9\\.\\-]{0,22}[a-zA-Z0-9]:\\d{1,5}") && !value.matches("(\\d{1,3}\\.){3,3}\\d{1,3}:\\d{1,5}")) {
                return FormValidation.warning((String)"The Astr\u00e9e Server needs to be specified as a hostname followed by a colon followed by a port number.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlauncher(@QueryParameter String value, AbstractProject project) throws IOException, ServletException {
            if (value == null || value.trim().equals("")) {
                return FormValidation.error((String)"No file specified.");
            }
            File ftmp = new File(value);
            if (!ftmp.exists()) {
                return FormValidation.error((String)"Specified file not found.");
            }
            if (!ftmp.isFile()) {
                return FormValidation.error((String)"Specified file is not a normal file.");
            }
            if (!ftmp.canExecute()) {
                return FormValidation.error((String)"Specified file cannot be executed.");
            }
            return FormValidation.ok();
        }

        public static final boolean containsEnvVars(String s) {
            String pattern = "\\$\\{([A-Za-z_][A-Za-z0-9_]*)\\}";
            Pattern expr = Pattern.compile("\\$\\{([A-Za-z_][A-Za-z0-9_]*)\\}");
            Matcher matcher = expr.matcher(s);
            return matcher.find();
        }

        public FormValidation doCheckDax_file(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.trim().equals("")) {
                return FormValidation.warning((String)"No DAX file specified. Only ID will be used.");
            }
            if (DescriptorImpl.containsEnvVars(value)) {
                return FormValidation.warning((String)"The specified path contains an environment variable, please make sure the constructed paths are correct.");
            }
            File ftmp = new File(value);
            if (!ftmp.exists()) {
                return FormValidation.error((String)"Specified file not found.");
            }
            if (!ftmp.canRead()) {
                return FormValidation.error((String)"Specified file cannot be read.");
            }
            if (!value.endsWith(".dax")) {
                return FormValidation.warning((String)"The specified file exists, but does not have the expected suffix (.dax).");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAnalysis_id(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.trim().equals("")) {
                return FormValidation.warning((String)"No ID specified. Only DAX file will be used.");
            }
            if (DescriptorImpl.containsEnvVars(value)) {
                return FormValidation.warning((String)"The ID contains an environment variable, please make sure that the constructed IDs are valid.");
            }
            if (!value.matches("\\d*")) {
                return FormValidation.error((String)"ID is not valid.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOutput_dir(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.trim().equals("")) {
                return FormValidation.warning((String)"No directory specified.");
            }
            if (DescriptorImpl.containsEnvVars(value)) {
                return FormValidation.warning((String)"The specified path contains an environment variable, please make sure that the constructed paths are correct.");
            }
            File ftmp = new File(value);
            if (!ftmp.exists()) {
                return FormValidation.error((String)"Specified directory not found.");
            }
            if (!ftmp.isDirectory()) {
                return FormValidation.error((String)"Specified path is no directory.");
            }
            if (!ftmp.canRead() || !ftmp.canWrite()) {
                return FormValidation.warning((String)"No permissions to read/write the specified directory.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.alauncher = formData.getString("alauncher");
            this.astree_server = formData.getString("astree_server");
            this.user = formData.getString("user");
            this.password = formData.getString("password");
            this.save();
            return super.configure(req, formData);
        }

        public String getAstree_server() {
            return this.astree_server;
        }

        public String getAlauncher() {
            return this.alauncher;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

