/*
 * Decompiled with CFR 0.152.
 */
package com.absint.astree;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AnalysisSummary {
    private int numberOfErrors;
    private int numberOfAlarms;
    private int numberOfFlowAnomalies;
    private int numberOfRuleViolations;
    private int numberOfTrueAlarms;
    private int numberOfUncommentedAlarms;

    private AnalysisSummary(int numberOfErrors, int numberOfAlarms, int numberOfFlowAnomalies, int numberOfRuleViolations, int numberOfTrueAlarms, int numberOfUncommentedAlarms) {
        this.numberOfErrors = numberOfErrors;
        this.numberOfAlarms = numberOfAlarms;
        this.numberOfFlowAnomalies = numberOfFlowAnomalies;
        this.numberOfRuleViolations = numberOfRuleViolations;
        this.numberOfTrueAlarms = numberOfTrueAlarms;
        this.numberOfUncommentedAlarms = numberOfUncommentedAlarms;
    }

    public static AnalysisSummary readFromReportFile(String path) {
        int numberOfErrors = 0;
        int numberOfAlarms = 0;
        int numberOfFlowAnomalies = 0;
        int numberOfRuleViolations = 0;
        int numberOfTrueAlarms = 0;
        int numberOfUncommentedAlarms = 0;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            String line = br.readLine();
            boolean skipping = true;
            while (line != null) {
                if (!skipping) {
                    if (line.trim().startsWith("Errors:")) {
                        numberOfErrors = Integer.parseInt(line.substring(line.indexOf(":") + 1, line.length()).trim());
                    } else if (line.trim().startsWith("Run-time errors:")) {
                        numberOfAlarms = Integer.parseInt(line.substring(line.indexOf(":") + 1, line.length()).trim());
                    } else if (line.trim().startsWith("Flow anomalies:")) {
                        numberOfFlowAnomalies = Integer.parseInt(line.substring(line.indexOf(":") + 1, line.length()).trim());
                    } else if (line.trim().startsWith("Rule violations:")) {
                        numberOfRuleViolations = Integer.parseInt(line.substring(line.indexOf(":") + 1, line.length()).trim());
                    }
                }
                if (skipping && line.trim().startsWith("/* Result summary */")) {
                    skipping = false;
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            return null;
        }
        return new AnalysisSummary(numberOfErrors, numberOfAlarms, numberOfFlowAnomalies, numberOfRuleViolations, numberOfTrueAlarms, numberOfUncommentedAlarms);
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public int getNumberOfAlarms() {
        return this.numberOfAlarms;
    }

    public int getNumberOfFlowAnomalies() {
        return this.numberOfFlowAnomalies;
    }

    public int getNumberOfRuleViolations() {
        return this.numberOfRuleViolations;
    }

    public int getNumberOfTrueAlarms() {
        return this.numberOfTrueAlarms;
    }

    public int getNumberOfUncommentedAlarms() {
        return this.numberOfUncommentedAlarms;
    }
}

