/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils;

import hudson.Extension;
import hudson.model.PeriodicWork;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.JenkinsCrumb;

@Extension
public class DropCachePeriodicWork
extends PeriodicWork {
    private static Map<String, JenkinsCrumb> crumbMap = new HashMap<String, JenkinsCrumb>();
    private static Map<String, JSONObject> jobInfoMap = new HashMap<String, JSONObject>();
    private static Logger logger = Logger.getLogger(DropCachePeriodicWork.class.getName());
    private static Lock jobInfoLock = new ReentrantLock();
    private static Lock crumbLock = new ReentrantLock();

    public long getRecurrencePeriod() {
        return TimeUnit.MINUTES.toMillis(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JenkinsCrumb safePutCrumb(String key, JenkinsCrumb jenkinsCrumb, boolean isCacheEnable) {
        if (!isCacheEnable) {
            return jenkinsCrumb;
        }
        try {
            crumbLock.lock();
            crumbMap.put(key, jenkinsCrumb);
            JenkinsCrumb jenkinsCrumb2 = jenkinsCrumb;
            return jenkinsCrumb2;
        }
        finally {
            crumbLock.unlock();
        }
    }

    public static JenkinsCrumb safeGetCrumb(String key, boolean isCacheEnable) {
        if (!isCacheEnable) {
            return null;
        }
        try {
            crumbLock.lock();
            if (crumbMap.containsKey(key)) {
                JenkinsCrumb jenkinsCrumb = crumbMap.get(key);
                return jenkinsCrumb;
            }
            JenkinsCrumb jenkinsCrumb = null;
            return jenkinsCrumb;
        }
        finally {
            crumbLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject safePutJobInfo(String key, JSONObject jobInfo, boolean isCacheEnable) {
        if (!isCacheEnable) {
            return jobInfo;
        }
        try {
            jobInfoLock.lock();
            jobInfoMap.put(key, jobInfo);
            JSONObject jSONObject = jobInfo;
            return jSONObject;
        }
        finally {
            jobInfoLock.unlock();
        }
    }

    public static JSONObject safeGetJobInfo(String key, boolean isCacheEnable) {
        if (!isCacheEnable) {
            return null;
        }
        try {
            jobInfoLock.lock();
            if (jobInfoMap.containsKey(key)) {
                JSONObject jSONObject = jobInfoMap.get(key);
                return jSONObject;
            }
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            jobInfoLock.unlock();
        }
    }

    protected void doRun() throws Exception {
        logger.log(Level.INFO, "begin schedule clean...");
        try {
            crumbLock.lock();
            crumbMap.clear();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Fail to clear crumb cache", e);
        }
        finally {
            crumbLock.unlock();
        }
        try {
            jobInfoLock.lock();
            jobInfoMap.clear();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Fail to clear job info cache", e);
        }
        finally {
            jobInfoLock.unlock();
        }
        logger.log(Level.INFO, "end schedule clean...");
    }
}

