/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BasicBuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.TokenMacroUtils;

public class Base64Utils {
    public static final String AUTHTYPE_BASIC = "Basic";

    public static String encode(String input) throws UnsupportedEncodingException {
        byte[] encoded = Base64.encodeBase64((byte[])input.getBytes("UTF-8"));
        return new String(encoded, "UTF-8");
    }

    @NonNull
    public static String generateAuthorizationHeaderValue(String authType, String user, String password, BuildContext context, boolean applyMacro) throws IOException {
        if (StringUtils.isEmpty((String)user)) {
            throw new IllegalArgumentException("user null or empty");
        }
        if (password == null) {
            throw new IllegalArgumentException("password null");
        }
        String authTypeKey = Base64Utils.getAuthType(authType);
        Object tuple = user + ":" + password;
        if (applyMacro) {
            tuple = TokenMacroUtils.applyTokenMacroReplacements((String)tuple, (BasicBuildContext)context);
        }
        String encodedTuple = Base64Utils.encode((String)tuple);
        return authTypeKey + " " + encodedTuple;
    }

    @NonNull
    private static String getAuthType(String authType) {
        if (AUTHTYPE_BASIC.equalsIgnoreCase(authType)) {
            return AUTHTYPE_BASIC;
        }
        throw new IllegalArgumentException("AuthType wrong or not supported yet: " + authType);
    }
}

