/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Run;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.RemoteBuildInfo;

public class RemoteBuildInfoExporterAction
implements EnvironmentContributingAction {
    public static final String JOB_NAME_VARIABLE = "LAST_TRIGGERED_JOB_NAME";
    public static final String ALL_JOBS_NAME_VARIABLE = "TRIGGERED_JOB_NAMES";
    public static final String BUILD_URL_VARIABLE_PREFIX = "TRIGGERED_BUILD_URL_";
    public static final String BUILD_NUMBER_VARIABLE_PREFIX = "TRIGGERED_BUILD_NUMBER_";
    public static final String ALL_BUILD_NUMBER_VARIABLE_PREFIX = "TRIGGERED_BUILD_NUMBERS_";
    public static final String BUILD_RESULT_VARIABLE_PREFIX = "TRIGGERED_BUILD_RESULT_";
    public static final String BUILD_RUN_COUNT_PREFIX = "TRIGGERED_BUILD_RUN_COUNT_";
    public static final String RUN = "_RUN_";
    private List<BuildReference> builds = new ArrayList<BuildReference>();

    public RemoteBuildInfoExporterAction(Run<?, ?> parentBuild, BuildReference buildRef) {
        this.addBuildReferenceSafe(buildRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteBuildInfoExporterAction addBuildInfoExporterAction(@NonNull Run<?, ?> parentBuild, String triggeredProjectName, int buildNumber, URL jobURL, RemoteBuildInfo buildInfo) {
        RemoteBuildInfoExporterAction action;
        BuildReference reference = new BuildReference(triggeredProjectName, buildNumber, jobURL, buildInfo);
        Run<?, ?> run = parentBuild;
        synchronized (run) {
            action = (RemoteBuildInfoExporterAction)parentBuild.getAction(RemoteBuildInfoExporterAction.class);
            if (action == null) {
                action = new RemoteBuildInfoExporterAction(parentBuild, reference);
                parentBuild.addAction((Action)action);
            } else {
                action.addBuildReference(reference);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuildReferenceSafe(BuildReference buildRef) {
        List<BuildReference> list = this.builds;
        synchronized (list) {
            this.removeDuplicates(this.builds, buildRef);
            this.builds.add(buildRef);
        }
    }

    private boolean removeDuplicates(List<BuildReference> buildRefList, BuildReference buildRef) {
        ArrayList<BuildReference> duplicates = new ArrayList<BuildReference>();
        for (BuildReference build : buildRefList) {
            if (!build.projectName.equals(buildRef.projectName) || build.buildNumber != buildRef.buildNumber) continue;
            duplicates.add(build);
        }
        if (duplicates.size() > 0) {
            buildRefList.removeAll(duplicates);
            return true;
        }
        return false;
    }

    public void addBuildReference(BuildReference buildRef) {
        this.addBuildReferenceSafe(buildRef);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        for (String project : this.getProjectsWithBuilds()) {
            String sanatizedProjectName = RemoteBuildInfoExporterAction.sanitizeProjectName(project);
            List<BuildReference> refs = this.getBuildRefs(project);
            env.put(ALL_BUILD_NUMBER_VARIABLE_PREFIX + sanatizedProjectName, this.getBuildNumbersString(refs, ","));
            env.put(BUILD_RUN_COUNT_PREFIX + sanatizedProjectName, Integer.toString(refs.size()));
            for (BuildReference br : refs) {
                if (br.buildNumber == 0) continue;
                String tiggeredBuildRunResultKey = BUILD_RESULT_VARIABLE_PREFIX + sanatizedProjectName + RUN + Integer.toString(br.buildNumber);
                env.put(tiggeredBuildRunResultKey, br.buildInfo.getResult().toString());
            }
            BuildReference lastBuild = null;
            for (int i = refs.size(); i > 0; --i) {
                if (refs.get((int)(i - 1)).buildNumber == 0) continue;
                lastBuild = refs.get(i - 1);
                break;
            }
            if (lastBuild == null) continue;
            env.put(JOB_NAME_VARIABLE, lastBuild.projectName);
            env.put(BUILD_NUMBER_VARIABLE_PREFIX + sanatizedProjectName, Integer.toString(lastBuild.buildNumber));
            env.put(BUILD_URL_VARIABLE_PREFIX + sanatizedProjectName, lastBuild.jobURL.toString());
            env.put(BUILD_RESULT_VARIABLE_PREFIX + sanatizedProjectName, lastBuild.buildInfo.getResult().toString());
        }
    }

    public static String sanitizeProjectName(String project) {
        if (project == null) {
            return null;
        }
        return project.replaceAll("[^a-zA-Z0-9]+", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BuildReference> getBuildRefs(String project) {
        ArrayList<BuildReference> refs = new ArrayList<BuildReference>();
        List<BuildReference> list = this.builds;
        synchronized (list) {
            for (BuildReference br : this.builds) {
                if (!br.projectName.equals(project)) continue;
                refs.add(br);
            }
        }
        return refs;
    }

    private String getBuildNumbersString(List<BuildReference> refs, String separator) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (BuildReference s : refs) {
            if (s.buildNumber == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s.buildNumber);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getProjectsWithBuilds() {
        LinkedHashSet<String> projects = new LinkedHashSet<String>();
        List<BuildReference> list = this.builds;
        synchronized (list) {
            for (BuildReference br : this.builds) {
                if (br.buildNumber == 0) continue;
                if (projects.contains(br.projectName)) {
                    projects.remove(br.projectName);
                }
                projects.add(br.projectName);
            }
        }
        return projects;
    }

    public static class BuildReference {
        public final String projectName;
        public final int buildNumber;
        public final RemoteBuildInfo buildInfo;
        public final URL jobURL;

        public BuildReference(String projectName, int buildNumber, URL jobURL, RemoteBuildInfo buildInfo) {
            this.projectName = projectName;
            this.buildNumber = buildNumber;
            this.buildInfo = buildInfo;
            this.jobURL = jobURL;
        }
    }
}

