/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BasicBuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteBuildConfiguration;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteJenkinsServer;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.Auth2;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.NullAuth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.FileParameters;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.JobParameters;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.MapParameter;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.MapParameters;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.StringParameters;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.pipeline.Handle;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.RemoteBuildStatus;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.FormValidationUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.OtelUtils;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBuildPipelineStep
extends Step {
    private RemoteBuildConfiguration remoteBuildConfig = new RemoteBuildConfiguration();
    private static final Logger logger = LoggerFactory.getLogger(RemoteBuildPipelineStep.class);

    @DataBoundConstructor
    public RemoteBuildPipelineStep(String job) {
        this.remoteBuildConfig.setJob(job);
        this.remoteBuildConfig.setShouldNotFailBuild(false);
        this.remoteBuildConfig.setBlockBuildUntilComplete(true);
    }

    @DataBoundSetter
    public void setAbortTriggeredJob(boolean abortTriggeredJob) {
        this.remoteBuildConfig.setAbortTriggeredJob(abortTriggeredJob);
    }

    @DataBoundSetter
    public void setMaxConn(int maxConn) {
        this.remoteBuildConfig.setMaxConn(maxConn);
    }

    @DataBoundSetter
    public void setAuth(Auth2 auth) {
        this.remoteBuildConfig.setAuth2(auth);
    }

    @DataBoundSetter
    public void setRemoteJenkinsName(String remoteJenkinsName) {
        this.remoteBuildConfig.setRemoteJenkinsName(remoteJenkinsName);
    }

    @DataBoundSetter
    public void setRemoteJenkinsUrl(String remoteJenkinsUrl) {
        this.remoteBuildConfig.setRemoteJenkinsUrl(remoteJenkinsUrl);
    }

    @DataBoundSetter
    public void setShouldNotFailBuild(boolean shouldNotFailBuild) {
        this.remoteBuildConfig.setShouldNotFailBuild(shouldNotFailBuild);
    }

    @DataBoundSetter
    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.remoteBuildConfig.setTrustAllCertificates(trustAllCertificates);
    }

    @DataBoundSetter
    public void setOverrideTrustAllCertificates(boolean overrideTrustAllCertificates) {
        this.remoteBuildConfig.setOverrideTrustAllCertificates(overrideTrustAllCertificates);
    }

    @DataBoundSetter
    public void setPreventRemoteBuildQueue(boolean preventRemoteBuildQueue) {
        this.remoteBuildConfig.setPreventRemoteBuildQueue(preventRemoteBuildQueue);
    }

    @DataBoundSetter
    public void setHttpGetReadTimeout(int readTimeout) {
        this.remoteBuildConfig.setHttpGetReadTimeout(readTimeout);
    }

    @DataBoundSetter
    public void setHttpPostReadTimeout(int readTimeout) {
        this.remoteBuildConfig.setHttpPostReadTimeout(readTimeout);
    }

    @DataBoundSetter
    public void setPollInterval(int pollInterval) {
        this.remoteBuildConfig.setPollInterval(pollInterval);
    }

    @DataBoundSetter
    public void setBlockBuildUntilComplete(boolean blockBuildUntilComplete) {
        this.remoteBuildConfig.setBlockBuildUntilComplete(blockBuildUntilComplete);
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.remoteBuildConfig.setToken(token);
    }

    @DataBoundSetter
    public void setParameters(Object parameters) throws AbortException {
        if (parameters instanceof JobParameters) {
            logger.trace("job parameter detected");
            this.remoteBuildConfig.setParameters2((JobParameters)parameters);
        } else if (parameters instanceof String) {
            String parametersAsString = (String)parameters;
            if (parametersAsString.contains("=") || parametersAsString.contains("\n")) {
                logger.trace("string var");
                this.remoteBuildConfig.setParameters2(new StringParameters(parametersAsString));
            } else {
                logger.trace("string file");
                this.remoteBuildConfig.setParameters2(new FileParameters(parametersAsString));
            }
        } else if (parameters instanceof Map) {
            logger.trace("map");
            Map<String, String> parametersAsMap = ((Map)parameters).entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString()));
            logger.trace("parsed map");
            this.remoteBuildConfig.setParameters2(new MapParameters(parametersAsMap));
        } else {
            logger.trace(parameters.getClass().toString() + ", force casting to UninstantiatedDescribable");
            if (!(parameters instanceof UninstantiatedDescribable)) {
                throw new AbortException("Cannot parse pipeline parameters.");
            }
            UninstantiatedDescribable uninstantiatedParms = (UninstantiatedDescribable)parameters;
            Map args = uninstantiatedParms.getArguments();
            if (args.entrySet().size() < 1) {
                throw new AbortException("Cannot parse pipeline parameters, no parameters detected.");
            }
            Object keys = "";
            for (Map.Entry entry2 : args.entrySet()) {
                keys = (String)keys + (String)entry2.getKey() + ",";
                if (entry2.getValue() instanceof List) {
                    if (!((String)entry2.getKey()).equalsIgnoreCase("parameters")) continue;
                    MapParameters mps = new MapParameters();
                    ArrayList<MapParameter> lmp = new ArrayList<MapParameter>();
                    for (Object obj : (List)entry2.getValue()) {
                        UninstantiatedDescribable ao = (UninstantiatedDescribable)obj;
                        MapParameter mpTmp = new MapParameter();
                        for (Map.Entry subParms : ao.getArguments().entrySet()) {
                            Map.Entry castedParm = subParms;
                            if (castedParm.getKey() == "name") {
                                mpTmp.setName((String)castedParm.getValue());
                                continue;
                            }
                            if (castedParm.getKey() == "value") {
                                mpTmp.setValue((String)castedParm.getValue());
                                continue;
                            }
                            throw new AbortException("Cannot parse pipeline parameters, unknown sub key: " + (String)castedParm.getKey());
                        }
                        lmp.add(mpTmp);
                    }
                    mps.setParameters(lmp);
                    logger.trace("map data: " + mps.toString());
                    this.remoteBuildConfig.setParameters2(mps);
                    return;
                }
                if (!((String)entry2.getKey()).toLowerCase().equalsIgnoreCase("filepath")) continue;
                logger.trace(entry2.getValue().toString());
                this.remoteBuildConfig.setParameters2(new FileParameters(entry2.getValue().toString()));
                return;
            }
            throw new AbortException("Cannot parse pipeline parameters, unknown key: " + (String)keys);
        }
    }

    @Deprecated
    @DataBoundSetter
    public void setParameterFile(String parameterFile) {
        this.remoteBuildConfig.setParameters2(new FileParameters(parameterFile));
    }

    @DataBoundSetter
    public void setEnhancedLogging(boolean enhancedLogging) {
        this.remoteBuildConfig.setEnhancedLogging(enhancedLogging);
    }

    @DataBoundSetter
    public void setUseJobInfoCache(boolean useJobInfoCache) {
        this.remoteBuildConfig.setUseJobInfoCache(useJobInfoCache);
    }

    @DataBoundSetter
    public void setUseCrumbCache(boolean useCrumbCache) {
        this.remoteBuildConfig.setUseCrumbCache(useCrumbCache);
    }

    @DataBoundSetter
    public void setDisabled(boolean disabled) {
        this.remoteBuildConfig.setDisabled(disabled);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this.remoteBuildConfig);
    }

    public String getRemoteJenkinsName() {
        return this.remoteBuildConfig.getRemoteJenkinsName();
    }

    public String getRemoteJenkinsUrl() {
        return this.remoteBuildConfig.getRemoteJenkinsUrl();
    }

    public String getJob() {
        return this.remoteBuildConfig.getJob();
    }

    public boolean getShouldNotFailBuild() {
        return this.remoteBuildConfig.getShouldNotFailBuild();
    }

    public boolean getTrustAllCertificates() {
        return this.remoteBuildConfig.getTrustAllCertificates();
    }

    public boolean getOverrideTrustAllCertificates() {
        return this.remoteBuildConfig.getOverrideTrustAllCertificates();
    }

    public boolean getPreventRemoteBuildQueue() {
        return this.remoteBuildConfig.getPreventRemoteBuildQueue();
    }

    public int getHttpGetReadTimeout() {
        return this.remoteBuildConfig.getHttpGetReadTimeout();
    }

    public int getHttpPostReadTimeout() {
        return this.remoteBuildConfig.getHttpPostReadTimeout();
    }

    public int getPollInterval() {
        return this.remoteBuildConfig.getPollInterval(RemoteBuildStatus.RUNNING);
    }

    public boolean getBlockBuildUntilComplete() {
        return this.remoteBuildConfig.getBlockBuildUntilComplete();
    }

    public String getToken() {
        return this.remoteBuildConfig.getToken();
    }

    public JobParameters getParameters() {
        return this.remoteBuildConfig.getParameters2();
    }

    public boolean getEnhancedLogging() {
        return this.remoteBuildConfig.getEnhancedLogging();
    }

    public int getConnectionRetryLimit() {
        return this.remoteBuildConfig.getConnectionRetryLimit();
    }

    public boolean isUseCrumbCache() {
        return this.remoteBuildConfig.isUseCrumbCache();
    }

    public boolean isUseJobInfoCache() {
        return this.remoteBuildConfig.isUseJobInfoCache();
    }

    public boolean isAbortTriggeredJob() {
        return this.remoteBuildConfig.isAbortTriggeredJob();
    }

    public int getMaxConn() {
        return this.remoteBuildConfig.getMaxConn();
    }

    public Auth2 getAuth() {
        return this.remoteBuildConfig.getAuth2();
    }

    public boolean isDisabled() {
        return this.remoteBuildConfig.isDisabled();
    }

    public String getParameterFile() {
        return null;
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Handle> {
        private static final long serialVersionUID = 5339071667093320735L;
        private final RemoteBuildConfiguration remoteBuildConfig;

        Execution(StepContext context, RemoteBuildConfiguration remoteBuildConfig) {
            super(context);
            this.remoteBuildConfig = remoteBuildConfig;
        }

        protected Handle run() throws Exception {
            StepContext stepContext = this.getContext();
            Run build = (Run)stepContext.get(Run.class);
            FilePath workspace = (FilePath)stepContext.get(FilePath.class);
            TaskListener listener = (TaskListener)stepContext.get(TaskListener.class);
            RemoteJenkinsServer effectiveRemoteServer = this.remoteBuildConfig.evaluateEffectiveRemoteHost(new BasicBuildContext(build, workspace, listener));
            BuildContext context = new BuildContext(build, workspace, listener, listener.getLogger(), effectiveRemoteServer);
            Handle handle = null;
            try (AutoCloseable ignored = OtelUtils.isOpenTelemetryAvailable() ? OtelUtils.activeSpanIfAvailable(stepContext) : OtelUtils.noop();){
                if (!this.remoteBuildConfig.isStepDisabled(listener.getLogger())) {
                    handle = this.remoteBuildConfig.performTriggerAndGetQueueId(context);
                    if (this.remoteBuildConfig.getBlockBuildUntilComplete()) {
                        this.remoteBuildConfig.performWaitForBuild(context, handle);
                    }
                }
            }
            catch (InterruptedException e) {
                this.remoteBuildConfig.abortRemoteTask(effectiveRemoteServer, handle, context);
                throw e;
            }
            return handle;
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "triggerRemoteJob";
        }

        public String getDisplayName() {
            return "Trigger Remote Job";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet set = new HashSet();
            Collections.addAll(set, Run.class, TaskListener.class);
            return set;
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillRemoteJenkinsNameItems() {
            RemoteBuildConfiguration.DescriptorImpl descriptor = (RemoteBuildConfiguration.DescriptorImpl)Descriptor.findByDescribableClassName((Collection)ExtensionList.lookup(RemoteBuildConfiguration.DescriptorImpl.class), (String)RemoteBuildConfiguration.class.getName());
            if (descriptor == null) {
                throw new RuntimeException("Could not get descriptor for RemoteBuildConfiguration");
            }
            return descriptor.doFillRemoteJenkinsNameItems();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckJob(@QueryParameter(value="job") String value, @QueryParameter(value="remoteJenkinsUrl") String remoteJenkinsUrl, @QueryParameter(value="remoteJenkinsName") String remoteJenkinsName) {
            FormValidationUtils.RemoteURLCombinationsResult result = FormValidationUtils.checkRemoteURLCombinations(remoteJenkinsUrl, remoteJenkinsName, value);
            if (result.isAffected(FormValidationUtils.AffectedField.JOB_NAME_OR_URL)) {
                return result.formValidation;
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRemoteJenkinsUrl(@QueryParameter(value="remoteJenkinsUrl") String value, @QueryParameter(value="remoteJenkinsName") String remoteJenkinsName, @QueryParameter(value="job") String job) {
            FormValidationUtils.RemoteURLCombinationsResult result = FormValidationUtils.checkRemoteURLCombinations(value, remoteJenkinsName, job);
            if (result.isAffected(FormValidationUtils.AffectedField.REMOTE_JENKINS_URL)) {
                return result.formValidation;
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRemoteJenkinsName(@QueryParameter(value="remoteJenkinsName") String value, @QueryParameter(value="remoteJenkinsUrl") String remoteJenkinsUrl, @QueryParameter(value="job") String job) {
            FormValidationUtils.RemoteURLCombinationsResult result = FormValidationUtils.checkRemoteURLCombinations(remoteJenkinsUrl, value, job);
            if (result.isAffected(FormValidationUtils.AffectedField.REMOTE_JENKINS_NAME)) {
                return result.formValidation;
            }
            return FormValidation.ok();
        }

        public static List<Auth2.Auth2Descriptor> getAuth2Descriptors() {
            return Auth2.all();
        }

        public static List<JobParameters.ParametersDescriptor> getParametersDescriptors() {
            return JobParameters.all();
        }

        public static Auth2.Auth2Descriptor getDefaultAuth2Descriptor() {
            return NullAuth.DESCRIPTOR;
        }

        public static JobParameters.ParametersDescriptor getDefaultParametersDescriptor() {
            return MapParameters.DESCRIPTOR;
        }
    }
}

