/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.JobParameters;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FileParameters
extends JobParameters {
    private static final long serialVersionUID = 3614172320192170597L;
    @Extension(ordinal=0.0)
    public static final FileParametersDescriptor DESCRIPTOR = new FileParametersDescriptor();
    private String filePath;

    @DataBoundConstructor
    public FileParameters() {
        this.filePath = null;
    }

    public FileParameters(String filePath) {
        this.filePath = filePath;
    }

    @DataBoundSetter
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") " + this.filePath;
    }

    public FileParametersDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public Map<String, String> getParametersMap(BuildContext context) throws AbortException {
        String parametersAsString = this.readParametersFile(context);
        return JobParameters.parseStringParameters(parametersAsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readParametersFile(BuildContext context) throws AbortException {
        if (context.workspace == null) {
            throw new AbortException("Workspace is null but parameter file is used. Looks like this step was started with \"agent: none\"");
        }
        BufferedReader reader = null;
        try {
            FilePath absoluteFilePath = context.workspace.child(this.getFilePath());
            context.logger.printf("Loading parameters from file %s%n", absoluteFilePath.getRemote());
            reader = new BufferedReader(new InputStreamReader(absoluteFilePath.read(), StandardCharsets.UTF_8));
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException | InterruptedException e) {
            context.logger.printf("[WARNING] Failed loading parameters: %s%n", e.getMessage());
            String string = "";
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileParameters that = (FileParameters)o;
        return Objects.equals(this.filePath, that.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.filePath);
    }

    @Symbol(value={"FileParameters"})
    public static class FileParametersDescriptor
    extends JobParameters.ParametersDescriptor {
        @NonNull
        public String getDisplayName() {
            return "File parameters";
        }
    }
}

