/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2;

import hudson.Extension;
import hudson.model.Item;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URLConnection;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.Auth2;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BearerTokenAuth
extends Auth2 {
    private static final long serialVersionUID = 3614172320192170597L;
    @Extension
    public static final Auth2.Auth2Descriptor DESCRIPTOR = new BearerTokenAuthDescriptor();
    private Secret token = null;

    @DataBoundConstructor
    public BearerTokenAuth() {
    }

    @DataBoundSetter
    public void setToken(Secret token) {
        this.token = token;
    }

    public Secret getToken() {
        return this.token;
    }

    @Override
    public void setAuthorizationHeader(URLConnection connection, BuildContext context) throws IOException {
        connection.setRequestProperty("Authorization", "Bearer " + this.getToken().getPlainText());
    }

    @Override
    public String toString() {
        return "'" + this.getDescriptor().getDisplayName() + "'";
    }

    @Override
    public String toString(Item item) {
        return this.toString();
    }

    public Auth2.Auth2Descriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        BearerTokenAuth other = (BearerTokenAuth)obj;
        if (this.token == null) {
            return other.token == null;
        }
        return this.token.equals((Object)other.token);
    }

    @Symbol(value={"BearerTokenAuth"})
    public static class BearerTokenAuthDescriptor
    extends Auth2.Auth2Descriptor {
        public String getDisplayName() {
            return "Bearer Token Authentication";
        }
    }
}

