/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.Auth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.Auth2;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.NoneAuth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.NaiveTrustManager;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RemoteJenkinsServer
extends AbstractDescribableImpl<RemoteJenkinsServer>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -9211781849078964416L;
    private static final Auth2 DEFAULT_AUTH = NoneAuth.INSTANCE;
    @CheckForNull
    private transient List<Auth> auth;
    @CheckForNull
    private String displayName;
    private boolean hasBuildTokenRootSupport;
    private boolean trustAllCertificates;
    private boolean overrideTrustAllCertificates;
    @CheckForNull
    private Auth2 auth2;
    @CheckForNull
    private String address;
    private boolean useProxy;

    @DataBoundConstructor
    public RemoteJenkinsServer() {
    }

    protected Object readResolve() {
        if (this.auth2 == null) {
            this.auth2 = this.auth == null || this.auth.size() <= 0 ? DEFAULT_AUTH : Auth.authToAuth2(this.auth);
        }
        this.auth = null;
        return this;
    }

    @DataBoundSetter
    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    @DataBoundSetter
    public void setOverrideTrustAllCertificates(boolean overrideTrustAllCertificates) {
        this.overrideTrustAllCertificates = overrideTrustAllCertificates;
    }

    @DataBoundSetter
    public void setDisplayName(String displayName) {
        this.displayName = StringUtils.trimToEmpty((String)displayName);
    }

    @DataBoundSetter
    public void setHasBuildTokenRootSupport(boolean hasBuildTokenRootSupport) {
        this.hasBuildTokenRootSupport = hasBuildTokenRootSupport;
    }

    @DataBoundSetter
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @DataBoundSetter
    public void setAuth2(Auth2 auth2) {
        this.auth2 = auth2 != null ? auth2 : DEFAULT_AUTH;
    }

    @DataBoundSetter
    public void setAddress(String address) {
        this.address = address;
    }

    @CheckForNull
    public String getDisplayName() {
        String displayName = null;
        displayName = this.displayName == null || this.displayName.trim().equals("") ? (this.address != null ? this.address : null) : this.displayName;
        return displayName;
    }

    public boolean getHasBuildTokenRootSupport() {
        return this.hasBuildTokenRootSupport;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    @CheckForNull
    public Auth2 getAuth2() {
        return this.auth2 != null ? this.auth2 : NoneAuth.INSTANCE;
    }

    @CheckForNull
    public String getAddress() {
        return this.address;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean getTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public boolean getOverrideTrustAllCertificates() {
        return this.overrideTrustAllCertificates;
    }

    public RemoteJenkinsServer clone() throws CloneNotSupportedException {
        RemoteJenkinsServer clone = (RemoteJenkinsServer)super.clone();
        clone.auth2 = this.auth2 == null ? null : this.auth2.clone();
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.auth2 == null ? 0 : this.auth2.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.hasBuildTokenRootSupport ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteJenkinsServer)) {
            return false;
        }
        RemoteJenkinsServer other = (RemoteJenkinsServer)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.auth2 == null ? other.auth2 != null : !this.auth2.equals(other.auth2)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        return this.hasBuildTokenRootSupport == other.hasBuildTokenRootSupport;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RemoteJenkinsServer> {
        public String getDisplayName() {
            return "";
        }

        public void makeConnectionTrustAllCertificates(HttpsURLConnection conn, boolean trustAllCertificates) throws NoSuchAlgorithmException, KeyManagementException {
            if (trustAllCertificates) {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new NaiveTrustManager()}, new SecureRandom());
                conn.setSSLSocketFactory(ctx.getSocketFactory());
                HostnameVerifier allHostsValid = (hostname, session) -> true;
                conn.setHostnameVerifier(allHostsValid);
            }
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckAddress(@QueryParameter String address, @QueryParameter boolean trustAllCertificates) {
            URL host = null;
            if (address == null || address.trim().equals("")) {
                return FormValidation.warning((String)"The remote address can not be empty, or it must be overridden on the job configuration.");
            }
            if (address.endsWith("/")) {
                return FormValidation.warning((String)"The remote address is not expected to end with a slash (/).");
            }
            try {
                host = new URL(address);
                host.toURI();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Malformed address (" + address + "). Remember to indicate the protocol, i.e. http, https, etc."));
            }
            try {
                URLConnection conn = host.openConnection();
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection sslConn = (HttpsURLConnection)conn;
                    try {
                        this.makeConnectionTrustAllCertificates(sslConn, trustAllCertificates);
                    }
                    catch (KeyManagementException | NoSuchAlgorithmException e) {
                        return FormValidation.error((Throwable)e, (String)"A key management error occurred.");
                    }
                }
                conn.setConnectTimeout(5000);
                conn.connect();
                if (trustAllCertificates) {
                    return FormValidation.warning((String)"Connection established! Accepting all certificates is potentially unsafe.");
                }
            }
            catch (Exception e) {
                return FormValidation.warning((Throwable)e, (String)"Address looks good, but a connection could not be established.");
            }
            return FormValidation.ok((String)(String.valueOf(host) + " is reachable."));
        }

        public static List<Auth2.Auth2Descriptor> getAuth2Descriptors() {
            return Auth2.all();
        }

        public static Auth2.Auth2Descriptor getDefaultAuth2Descriptor() {
            return NoneAuth.DESCRIPTOR;
        }
    }
}

