/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.office365connector.model.FactDefinition;
import jenkins.plugins.office365connector.model.Macro;
import jenkins.plugins.office365connector.utils.FormUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class Webhook
extends AbstractDescribableImpl<Webhook> {
    public static final Integer DEFAULT_TIMEOUT = 30000;
    private String name;
    private String url;
    private boolean startNotification;
    private boolean notifySuccess;
    private boolean notifyAborted;
    private boolean notifyNotBuilt;
    private boolean notifyUnstable;
    private boolean notifyFailure;
    private boolean notifyBackToNormal;
    private boolean notifyRepeatedFailure;
    private boolean mentionOnFailure = true;
    private int timeout;
    private boolean adaptiveCards;
    private List<Macro> macros = Collections.emptyList();
    private List<FactDefinition> factDefinitions = Collections.emptyList();

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @DataBoundConstructor
    public Webhook(String url) {
        this.url = StringUtils.isEmpty((CharSequence)url) ? this.getDescriptor().getGlobalUrl() : url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return Util.fixEmptyAndTrim((String)(StringUtils.isEmpty((CharSequence)this.name) ? this.getDescriptor().getGlobalName() : this.name));
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = Util.fixEmptyAndTrim((String)name);
    }

    public boolean isNotifySuccess() {
        return this.notifySuccess;
    }

    @DataBoundSetter
    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    public boolean isStartNotification() {
        return this.startNotification;
    }

    @DataBoundSetter
    public void setStartNotification(boolean startNotification) {
        this.startNotification = startNotification;
    }

    public boolean isNotifyAborted() {
        return this.notifyAborted;
    }

    @DataBoundSetter
    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    public boolean isNotifyNotBuilt() {
        return this.notifyNotBuilt;
    }

    @DataBoundSetter
    public void setNotifyNotBuilt(boolean notifyNotBuilt) {
        this.notifyNotBuilt = notifyNotBuilt;
    }

    public boolean isNotifyUnstable() {
        return this.notifyUnstable;
    }

    @DataBoundSetter
    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    public boolean isNotifyFailure() {
        return this.notifyFailure;
    }

    @DataBoundSetter
    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    public boolean isNotifyBackToNormal() {
        return this.notifyBackToNormal;
    }

    @DataBoundSetter
    public void setNotifyBackToNormal(boolean notifyBackToNormal) {
        this.notifyBackToNormal = notifyBackToNormal;
    }

    public boolean isNotifyRepeatedFailure() {
        return this.notifyRepeatedFailure;
    }

    @DataBoundSetter
    public void setNotifyRepeatedFailure(boolean notifyRepeatedFailure) {
        this.notifyRepeatedFailure = notifyRepeatedFailure;
    }

    public int getTimeout() {
        return this.timeout == 0 ? DEFAULT_TIMEOUT : this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public List<Macro> getMacros() {
        return Util.fixNull(this.macros);
    }

    @DataBoundSetter
    public void setAdaptiveCards(boolean adaptiveCards) {
        this.adaptiveCards = adaptiveCards;
    }

    public boolean isAdaptiveCards() {
        return this.adaptiveCards;
    }

    @DataBoundSetter
    public void setMacros(List<Macro> macros) {
        this.macros = Util.fixNull(macros);
    }

    public List<FactDefinition> getFactDefinitions() {
        return Util.fixNull(this.factDefinitions);
    }

    @DataBoundSetter
    public void setFactDefinitions(List<FactDefinition> factDefinitions) {
        this.factDefinitions = Util.fixNull(factDefinitions);
    }

    public boolean isMentionOnFailure() {
        return this.mentionOnFailure;
    }

    @DataBoundSetter
    public void setMentionOnFailure(boolean mentionOnFailure) {
        this.mentionOnFailure = mentionOnFailure;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Webhook> {
        private String url;
        private String name;
        private String globalUrl;
        private String globalName;

        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Webhook";
        }

        public int getDefaultTimeout() {
            return DEFAULT_TIMEOUT;
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            return FormUtils.formValidateUrl(value);
        }

        public FormValidation doCheckGlobalUrl(@QueryParameter String value) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return FormUtils.formValidateUrl(value);
            }
            return FormValidation.ok();
        }

        public String getUrl() {
            return this.url;
        }

        @DataBoundSetter
        public void setUrl(String url) {
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        @DataBoundSetter
        public void setName(String name) {
            this.name = name;
        }

        public String getGlobalUrl() {
            return this.globalUrl;
        }

        @DataBoundSetter
        public void setGlobalUrl(String url) {
            this.globalUrl = url;
        }

        public String getGlobalName() {
            return this.globalName;
        }

        @DataBoundSetter
        public void setGlobalName(String name) {
            this.globalName = name;
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }
    }
}

