/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector;

import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.List;
import jenkins.plugins.office365connector.ActionableBuilder;
import jenkins.plugins.office365connector.FactsBuilder;
import jenkins.plugins.office365connector.model.Card;
import jenkins.plugins.office365connector.model.FactDefinition;
import jenkins.plugins.office365connector.model.Section;
import jenkins.plugins.office365connector.model.adaptivecard.AdaptiveCard;
import jenkins.plugins.office365connector.model.messagecard.MessageCard;
import jenkins.plugins.office365connector.workflow.StepParameters;

public class CardBuilder {
    private final Run run;
    private final FactsBuilder factsBuilder;
    private final ActionableBuilder potentialActionBuilder;
    private final boolean isAdaptiveCards;
    private final boolean mentionOnFailure;

    public CardBuilder(Run run, TaskListener taskListener, boolean isAdaptiveCards) {
        this(run, taskListener, isAdaptiveCards, true);
    }

    public CardBuilder(Run run, TaskListener taskListener, boolean isAdaptiveCards, boolean mentionOnFailure) {
        this.run = run;
        this.isAdaptiveCards = isAdaptiveCards;
        this.mentionOnFailure = mentionOnFailure;
        this.factsBuilder = new FactsBuilder(run, taskListener);
        this.potentialActionBuilder = new ActionableBuilder(run, this.factsBuilder, isAdaptiveCards);
    }

    public Card createStartedCard(List<FactDefinition> factDefinitions) {
        String statusName = "Started";
        this.factsBuilder.addStatus("Started");
        this.factsBuilder.addRemarks();
        this.factsBuilder.addCommitters();
        this.factsBuilder.addDevelopers();
        this.factsBuilder.addUserFacts(factDefinitions);
        Section section = this.buildSection("Started");
        String summary = this.getDisplayName() + ": Build " + this.getRunName();
        Card card = this.isAdaptiveCards ? new AdaptiveCard(summary, section, this.getCompletedResult(this.run)) : new MessageCard(summary, section);
        card.setAction(this.potentialActionBuilder.buildActionable());
        return card;
    }

    public Card createCompletedCard(List<FactDefinition> factDefinitions) {
        Run failingSinceBuild;
        Result lastResult = this.getCompletedResult(this.run);
        Run previousBuild = this.run.getPreviousBuild();
        Result previousResult = previousBuild != null ? previousBuild.getResult() : Result.SUCCESS;
        Run lastNotFailedBuild = this.run.getPreviousNotFailedBuild();
        boolean isRepeatedFailure = this.isRepeatedFailure(previousResult, lastNotFailedBuild);
        boolean shouldMention = (lastResult == Result.FAILURE || lastResult == Result.UNSTABLE) && this.mentionOnFailure;
        String summary = String.format("%s: Build %s %s", this.getDisplayName(), this.getRunName(), this.calculateSummary(lastResult, previousResult, isRepeatedFailure));
        String status = this.calculateStatus(lastResult, previousResult, isRepeatedFailure);
        if (lastResult == Result.FAILURE && (failingSinceBuild = this.getFailingSinceBuild(lastNotFailedBuild)) != null && previousResult == Result.FAILURE) {
            this.factsBuilder.addFailingSinceBuild(failingSinceBuild.getNumber());
        }
        this.factsBuilder.addStatus(status);
        this.factsBuilder.addRemarks();
        this.factsBuilder.addCommitters(shouldMention);
        this.factsBuilder.addDevelopers();
        this.factsBuilder.addUserFacts(factDefinitions);
        Section section = this.buildSection(status);
        Card card = this.isAdaptiveCards ? new AdaptiveCard(summary, section, this.getCompletedResult(this.run)) : new MessageCard(summary, section);
        card.setThemeColor(CardBuilder.getCardThemeColor(lastResult));
        if (this.run.getResult() != Result.SUCCESS) {
            card.setAction(this.potentialActionBuilder.buildActionable());
        }
        return card;
    }

    private static String getCardThemeColor(Result result) {
        if (result == Result.SUCCESS) {
            return "#00FF00";
        }
        return result.color.getHtmlBaseColor();
    }

    private Section buildSection(String status) {
        String activityTitle = "Notification from " + this.getEscapedDisplayName() + ": " + status;
        String activitySubtitle = "Latest status of build " + this.getRunName();
        return new Section(activityTitle, activitySubtitle, this.factsBuilder.collect());
    }

    private boolean isRepeatedFailure(Result previousResult, Run lastNotFailedBuild) {
        Run failingSinceRun = this.getFailingSinceBuild(lastNotFailedBuild);
        return failingSinceRun != null && previousResult == Result.FAILURE;
    }

    private Run getFailingSinceBuild(Run lastNotFailedBuild) {
        return lastNotFailedBuild != null ? lastNotFailedBuild.getNextBuild() : this.run.getParent().getFirstBuild();
    }

    String calculateStatus(Result lastResult, Result previousResult, boolean isRepeatedFailure) {
        if (lastResult == Result.SUCCESS) {
            if (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) {
                return "Back to Normal";
            }
            return "Build Success";
        }
        if (lastResult == Result.FAILURE) {
            if (isRepeatedFailure) {
                return "Repeated Failure";
            }
            return "Build Failed";
        }
        if (lastResult == Result.ABORTED) {
            return "Build Aborted";
        }
        if (lastResult == Result.UNSTABLE) {
            return "Build Unstable";
        }
        return lastResult.toString();
    }

    String calculateSummary(Result completedResult, Result previousResult, boolean isRepeatedFailure) {
        if (completedResult == Result.SUCCESS) {
            if (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) {
                return "Back to Normal";
            }
            return "Success";
        }
        if (completedResult == Result.FAILURE) {
            if (isRepeatedFailure) {
                return "Repeated Failure";
            }
            return "Failed";
        }
        if (completedResult == Result.ABORTED) {
            return "Aborted";
        }
        if (completedResult == Result.UNSTABLE) {
            return "Unstable";
        }
        return completedResult.toString();
    }

    private Result getCompletedResult(Run run) {
        return run.getResult() == null ? Result.SUCCESS : run.getResult();
    }

    public Card createBuildMessageCard(StepParameters stepParameters) {
        Card card;
        if (stepParameters.getStatus() != null) {
            this.factsBuilder.addStatus(stepParameters.getStatus());
        }
        this.factsBuilder.addUserFacts(stepParameters.getFactDefinitions());
        String activityTitle = "Notification from " + this.getEscapedDisplayName();
        Section section = new Section(activityTitle, stepParameters.getMessage(), this.factsBuilder.collect());
        String summary = this.getDisplayName() + ": Build " + this.getRunName();
        Card card2 = card = this.isAdaptiveCards ? new AdaptiveCard(summary, section, this.getCompletedResult(this.run)) : new MessageCard(summary, section);
        if (stepParameters.getColor() != null) {
            card.setThemeColor(stepParameters.getColor());
        }
        card.setAction(this.potentialActionBuilder.buildActionable());
        return card;
    }

    private String getEscapedDisplayName() {
        String displayName = this.getDisplayName();
        return displayName.replaceAll("([*_#-])", "\\\\$1");
    }

    private String getDisplayName() {
        return this.run.getParent().getFullDisplayName();
    }

    private String getRunName() {
        return this.run.hasCustomDisplayName() ? this.run.getDisplayName() : "#" + this.run.getNumber();
    }
}

