/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector.utils;

import hudson.model.User;
import hudson.tasks.Mailer;
import org.apache.commons.lang.StringUtils;

public final class TeamsMentionUtils {
    private TeamsMentionUtils() {
    }

    public static String mentionEmail(String email) {
        if (StringUtils.isBlank((String)email)) {
            return email;
        }
        return "<at>" + email + "</at>";
    }

    public static String mentionUserOrEmail(User user) {
        if (user == null) {
            return "Unknown user";
        }
        Mailer.UserProperty userProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        if (userProperty != null && StringUtils.isNotBlank((String)userProperty.getAddress())) {
            return TeamsMentionUtils.mentionEmail(userProperty.getAddress());
        }
        return user.getFullName();
    }
}

