/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import jenkins.plugins.office365connector.CardBuilder;
import jenkins.plugins.office365connector.DecisionMaker;
import jenkins.plugins.office365connector.HttpWorker;
import jenkins.plugins.office365connector.Webhook;
import jenkins.plugins.office365connector.WebhookJobProperty;
import jenkins.plugins.office365connector.model.Card;
import jenkins.plugins.office365connector.workflow.StepParameters;
import org.apache.commons.lang.StringUtils;

public class Office365ConnectorWebhookNotifier {
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setPrettyPrinting().create();
    private final DecisionMaker decisionMaker;
    private final Run run;
    private final Job job;
    private final TaskListener taskListener;

    public Office365ConnectorWebhookNotifier(Run run, TaskListener taskListener) {
        this.run = run;
        this.taskListener = taskListener;
        this.decisionMaker = new DecisionMaker(run, taskListener);
        this.job = run.getParent();
    }

    public void sendBuildStartedNotification(boolean isFromPreBuild) {
        boolean isBuild = this.run instanceof AbstractBuild;
        if (isBuild == isFromPreBuild) {
            List<Webhook> webhooks = Office365ConnectorWebhookNotifier.extractWebhooks(this.job);
            for (Webhook webhook : webhooks) {
                if (!this.decisionMaker.isAtLeastOneRuleMatched(webhook) || !webhook.isStartNotification()) continue;
                CardBuilder cardBuilder = new CardBuilder(this.run, this.taskListener, webhook.isAdaptiveCards());
                Card card = cardBuilder.createStartedCard(webhook.getFactDefinitions());
                this.executeWorker(webhook, card);
            }
        }
    }

    public void sendBuildCompletedNotification() {
        List<Webhook> webhooks = Office365ConnectorWebhookNotifier.extractWebhooks(this.job);
        for (Webhook webhook : webhooks) {
            if (!this.decisionMaker.isAtLeastOneRuleMatched(webhook) || !this.decisionMaker.isStatusMatched(webhook)) continue;
            CardBuilder cardBuilder = new CardBuilder(this.run, this.taskListener, webhook.isAdaptiveCards());
            Card card = cardBuilder.createCompletedCard(webhook.getFactDefinitions());
            this.executeWorker(webhook, card);
        }
    }

    private static List<Webhook> extractWebhooks(Job job) {
        WebhookJobProperty property = (WebhookJobProperty)job.getProperty(WebhookJobProperty.class);
        if (property != null && property.getWebhooks() != null) {
            return property.getWebhooks();
        }
        return Collections.emptyList();
    }

    public void sendBuildStepNotification(StepParameters stepParameters) {
        Webhook webhook = new Webhook(stepParameters.getWebhookUrl());
        CardBuilder cardBuilder = new CardBuilder(this.run, this.taskListener, stepParameters.isAdaptiveCards());
        Card card = StringUtils.isNotBlank((String)stepParameters.getMessage()) ? cardBuilder.createBuildMessageCard(stepParameters) : (StringUtils.equalsIgnoreCase((String)stepParameters.getStatus(), (String)"started") ? cardBuilder.createStartedCard(stepParameters.getFactDefinitions()) : cardBuilder.createCompletedCard(stepParameters.getFactDefinitions()));
        this.executeWorker(webhook, card);
    }

    private void executeWorker(Webhook webhook, Card card) {
        try {
            String url = this.run.getEnvironment(this.taskListener).expand(webhook.getUrl());
            String data = gson.toJson(card == null ? null : card.toPaylod());
            HttpWorker worker = new HttpWorker(url, data, webhook.getTimeout(), this.taskListener.getLogger());
            worker.submit();
        }
        catch (IOException | InterruptedException | RejectedExecutionException e) {
            this.log(String.format("Failed to notify webhook: %s", webhook.getName()));
            e.printStackTrace(this.taskListener.getLogger());
        }
    }

    private void log(String message) {
        this.taskListener.getLogger().println("[Office365connector] " + message);
    }
}

