/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector.workflow;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Set;
import jenkins.plugins.office365connector.model.FactDefinition;
import jenkins.plugins.office365connector.utils.FormUtils;
import jenkins.plugins.office365connector.workflow.Execution;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class Office365ConnectorSendStep
extends Step {
    private final String webhookUrl;
    private String message;
    private String status;
    private List<FactDefinition> factDefinitions;
    private String color;
    private boolean adaptiveCards;

    @DataBoundConstructor
    public Office365ConnectorSendStep(String webhookUrl) {
        this.webhookUrl = Util.fixEmptyAndTrim((String)webhookUrl);
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public String getMessage() {
        return this.message;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        this.message = Util.fixEmptyAndTrim((String)message);
    }

    public String getStatus() {
        return this.status;
    }

    @DataBoundSetter
    public void setStatus(String status) {
        this.status = Util.fixEmptyAndTrim((String)status);
    }

    public String getColor() {
        return this.color;
    }

    @DataBoundSetter
    public void setFactDefinitions(List<FactDefinition> factDefinitions) {
        this.factDefinitions = factDefinitions;
    }

    public List<FactDefinition> getFactDefinitions() {
        return this.factDefinitions;
    }

    @DataBoundSetter
    public void setColor(String color) {
        this.color = Util.fixEmptyAndTrim((String)color);
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    public boolean isAdaptiveCards() {
        return this.adaptiveCards;
    }

    @DataBoundSetter
    public void setAdaptiveCards(boolean adaptiveCards) {
        this.adaptiveCards = adaptiveCards;
    }

    @Extension
    @Symbol(value={"office365ConnectorSend"})
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "office365ConnectorSend";
        }

        @NonNull
        public String getDisplayName() {
            return "Send job status notifications to Office 365 (e.g. Microsoft Teams or Outlook)";
        }

        public FormValidation doCheckWebhookUrl(@QueryParameter String value) {
            return FormUtils.formValidateUrl(value);
        }
    }
}

