/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobPropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.office365connector.Webhook;
import jenkins.plugins.office365connector.WebhookJobProperty;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"office365ConnectorWebhooks"})
public final class WebhookJobPropertyDescriptor
extends JobPropertyDescriptor {
    private List<Webhook> webhooks = new ArrayList<Webhook>();

    public WebhookJobPropertyDescriptor() {
        super(WebhookJobProperty.class);
        this.load();
    }

    public boolean isEnabled() {
        return !this.webhooks.isEmpty();
    }

    public void setWebhooks(List<Webhook> webhooks) {
        this.webhooks = new ArrayList<Webhook>(webhooks);
    }

    public boolean isApplicable(Class<? extends Job> jobType) {
        return true;
    }

    public String getDisplayName() {
        return "Job Notification";
    }

    public WebhookJobProperty newInstance(StaplerRequest2 req, JSONObject formData) {
        JSON webhooksData;
        ArrayList<Webhook> webhooks = new ArrayList<Webhook>();
        if (formData != null && !formData.isNullObject() && (webhooksData = (JSON)formData.get("webhooks")) != null && !webhooksData.isEmpty()) {
            if (webhooksData.isArray()) {
                JSONArray webhooksArrayData = (JSONArray)webhooksData;
                webhooks.addAll(req.bindJSONToList(Webhook.class, (Object)webhooksArrayData));
            } else {
                JSONObject webhooksObjectData = (JSONObject)webhooksData;
                webhooks.add((Webhook)((Object)req.bindJSON(Webhook.class, webhooksObjectData)));
            }
        }
        return new WebhookJobProperty(webhooks);
    }

    public boolean configure(StaplerRequest2 req, JSONObject formData) {
        this.save();
        return true;
    }
}

