/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.plugins.office365connector.model.Fact;
import jenkins.plugins.office365connector.model.FactDefinition;
import jenkins.scm.RunWithSCM;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class FactsBuilder {
    public static final String NAME_STATUS = "Status";
    public static final String NAME_REMARKS = "Remarks";
    static final String COMMITTERS = "Committers";
    public static final String NAME_DEVELOPERS = "Developers";
    static final String NAME_FAILING_SINCE_BUILD = "Failing since";
    private final List<Fact> facts = new ArrayList<Fact>();
    private final Run run;
    private final TaskListener taskListener;

    public FactsBuilder(Run run, TaskListener listener) {
        this.run = run;
        this.taskListener = listener;
    }

    public void addStatus(String status) {
        this.addFact(NAME_STATUS, status);
    }

    public void addFailingSinceBuild(int buildNumber) {
        this.addFact(NAME_FAILING_SINCE_BUILD, "build #" + buildNumber);
    }

    public void addRemarks() {
        List causes = this.run.getCauses();
        String joinedCauses = causes.stream().map(cause -> cause.getShortDescription().concat(".")).collect(Collectors.joining(" "));
        this.addFact(NAME_REMARKS, joinedCauses);
    }

    public void addCommitters() {
        if (!(this.run instanceof RunWithSCM)) {
            return;
        }
        RunWithSCM runWithSCM = (RunWithSCM)this.run;
        Set authors = runWithSCM.getCulprits();
        String joinedCommitters = authors.stream().map(User::getFullName).collect(Collectors.joining(", "));
        this.addFact(COMMITTERS, joinedCommitters);
    }

    public void addDevelopers() {
        if (!(this.run instanceof RunWithSCM)) {
            return;
        }
        RunWithSCM runWithSCM = (RunWithSCM)this.run;
        List sets = runWithSCM.getChangeSets();
        HashSet<User> authors = new HashSet<User>();
        sets.stream().filter(set -> set instanceof ChangeLogSet).forEach(set -> set.forEach(entry -> authors.add(entry.getAuthor())));
        this.addFact(NAME_DEVELOPERS, StringUtils.join((Collection)this.sortUsers(authors), (String)", "));
    }

    private Collection sortUsers(Set<User> authors) {
        return authors.stream().sorted(Comparator.comparing(User::getFullName)).collect(Collectors.toList());
    }

    public void addUserFacts(List<FactDefinition> factDefinitions) {
        if (factDefinitions != null && !factDefinitions.isEmpty()) {
            for (FactDefinition factDefinition : factDefinitions) {
                this.addFact(factDefinition.getName(), this.evaluateMacro(factDefinition.getTemplate()));
            }
        }
    }

    private String evaluateMacro(String template) {
        try {
            File workspace = this.run.getRootDir();
            return TokenMacro.expandAll((Run)this.run, (FilePath)new FilePath(workspace), (TaskListener)this.taskListener, (String)template);
        }
        catch (IOException | InterruptedException | MacroEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void addFact(String name, String value) {
        this.addFact(new Fact(name, value));
    }

    private void addFact(Fact fact) {
        if (StringUtils.isBlank((String)fact.getName()) || StringUtils.isBlank((String)fact.getValue())) {
            return;
        }
        if (fact.getName().equals(NAME_STATUS)) {
            this.facts.add(0, fact);
        } else {
            this.facts.add(fact);
        }
    }

    public List<Fact> collect() {
        return this.facts;
    }
}

