/*
 * Decompiled with CFR 0.152.
 */
package com.github.farmgeek4life.jenkins.negotiatesso;

import com.github.farmgeek4life.jenkins.negotiatesso.NegSecFilter;
import com.github.farmgeek4life.jenkins.negotiatesso.NegSecUserSeedFilter;
import com.github.farmgeek4life.jenkins.negotiatesso.SecurityFilterConfig;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import hudson.util.PluginServletFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.util.SetContextClassLoader;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;
import waffle.servlet.spi.BasicSecurityFilterProvider;
import waffle.servlet.spi.NegotiateSecurityFilterProvider;
import waffle.util.cache.CacheSupplier;

@Extension
public final class NegotiateSSO
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(NegotiateSSO.class.getName());
    private boolean enabled = false;
    private boolean redirectEnabled = false;
    private String redirect = "yourdomain.com";
    private boolean allowLocalhost = true;
    private boolean allowImpersonate = false;
    private String principalFormat = "fqn";
    private String roleFormat = "fqn";
    private String protocols = "Negotiate NTLM";
    private String providers = NegotiateSecurityFilterProvider.class.getName() + " " + BasicSecurityFilterProvider.class.getName();
    private transient NegSecFilter filter;
    private transient NegSecUserSeedFilter userSeedFilter;

    public static NegotiateSSO getInstance() {
        Jenkins jenkins = Jenkins.get();
        return (NegotiateSSO)jenkins.getDescriptorByType(NegotiateSSO.class);
    }

    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public String getDisplayName() {
        return "NegotiateSSO";
    }

    public NegotiateSSO() {
        try {
            this.start();
        }
        catch (ServletException e) {
            LOGGER.log(Level.SEVERE, "Failed initialize plugin due to faulty config.", e);
            this.enabled = false;
        }
    }

    public void start() throws ServletException {
        this.load();
        try {
            if (this.enabled) {
                this.startFilter();
            }
        }
        catch (ServletException e) {
            LOGGER.log(Level.SEVERE, "Failed initialize plugin due to faulty config.", e);
            this.enabled = false;
            this.removeFilter();
        }
    }

    private void startFilter() throws ServletException {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            LOGGER.log(Level.SEVERE, "Not a Windows OS. NegotiateSSO will not work. Plugin Disabled.");
            this.enabled = false;
            return;
        }
        LOGGER.log(Level.INFO, "Starting Security Filter");
        this.filter = new NegSecFilter();
        this.filter.setImpersonate(this.allowImpersonate);
        this.filter.setPrincipalFormat(this.principalFormat);
        this.filter.setRoleFormat(this.roleFormat);
        this.filter.setAllowLocalhost(this.allowLocalhost);
        this.filter.setRedirect(this.redirectEnabled, this.redirect);
        SecurityFilterConfig config = new SecurityFilterConfig();
        config.setParameter("roleFormat", this.roleFormat);
        config.setParameter("principalFormat", this.principalFormat);
        config.setParameter("impersonate", String.valueOf(this.allowImpersonate));
        config.setParameter("allowGuestLogin", String.valueOf(Boolean.FALSE));
        config.setParameter("securityFilterProviders", this.providers);
        if (this.providers.contains("NegotiateSecurityFilterProvider")) {
            config.setParameter("waffle.servlet.spi.NegotiateSecurityFilterProvider/protocols", this.protocols);
        }
        try (SetContextClassLoader sccl = new SetContextClassLoader(CacheSupplier.class);){
            this.filter.init(config);
        }
        this.userSeedFilter = new NegSecUserSeedFilter();
        this.userSeedFilter.init(null);
        PluginServletFilter.addFilter((Filter)this.filter);
        PluginServletFilter.addFilter((Filter)this.userSeedFilter);
    }

    private void removeFilter() throws ServletException {
        if (this.filter != null) {
            PluginServletFilter.removeFilter((Filter)this.filter);
            this.filter.destroy();
            this.filter = null;
        }
        if (this.userSeedFilter != null) {
            PluginServletFilter.removeFilter((Filter)this.userSeedFilter);
            this.userSeedFilter.destroy();
            this.userSeedFilter = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
        try {
            if (!System.getProperty("os.name").toLowerCase().contains("win")) {
                LOGGER.log(Level.SEVERE, "Not a Windows OS. NegotiateSSO will not work. Plugin Disabled.");
                this.removeFilter();
                this.enabled = false;
            } else if (formData.has("enabled")) {
                JSONObject data = formData.getJSONObject("enabled");
                if (!(data.has("allowImpersonate") && data.has("roleFormat") && data.has("principalFormat") && data.has("protocols") && data.has("providers") && data.has("allowLocalhost"))) {
                    throw new Descriptor.FormException("Malformed form recieved. Try again.", "enabled");
                }
                if (data.has("redirectEnabled")) {
                    JSONObject rData = data.getJSONObject("redirectEnabled");
                    if (!rData.has("redirect")) throw new Descriptor.FormException("Malformed form recieved. Try again.", "redirect");
                    String domain = rData.getString("redirect");
                    if (domain.isEmpty()) throw new Descriptor.FormException("Cannot specify empty domain. Try again.", "redirect");
                    this.redirectEnabled = true;
                    this.redirect = rData.getString("redirect");
                } else {
                    this.redirectEnabled = false;
                }
                this.enabled = true;
                this.allowImpersonate = data.getBoolean("allowImpersonate");
                this.roleFormat = data.getString("roleFormat");
                this.principalFormat = data.getString("principalFormat");
                this.protocols = data.getString("protocols");
                this.providers = data.getString("providers");
                this.allowLocalhost = data.getBoolean("allowLocalhost");
                this.removeFilter();
                this.startFilter();
            } else {
                this.removeFilter();
                this.enabled = false;
            }
            this.save();
            return true;
        }
        catch (ServletException e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize plugin due to faulty config.", e);
            try {
                this.removeFilter();
            }
            catch (ServletException servletException) {
                // empty catch block
            }
            this.enabled = false;
            return false;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getRoleFormat() {
        return this.roleFormat;
    }

    public void setRoleFormat(String format) {
        this.roleFormat = format;
    }

    public String getPrincipalFormat() {
        return this.principalFormat;
    }

    public void setPrincipalFormat(String format) {
        this.principalFormat = format;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String protocol) {
        this.protocols = protocol;
    }

    public String getProviders() {
        return this.providers;
    }

    public void setProviders(String provider) {
        this.providers = provider;
    }

    public boolean isAllowImpersonate() {
        return this.allowImpersonate;
    }

    public boolean isAllowLocalhost() {
        return this.allowLocalhost;
    }

    public boolean isRedirectEnabled() {
        return this.redirectEnabled;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public ListBoxModel doFillRoleFormatItems() {
        ListBoxModel items = new ListBoxModel();
        items.add("Fully Qualified Name, fallback on SID", "fqn");
        items.add("SID", "sid");
        items.add("Both FQN and SID", "both");
        items.add("No Principal Name", "none");
        return items;
    }

    public ListBoxModel doFillPrincipalFormatItems() {
        ListBoxModel items = new ListBoxModel();
        items.add("Fully Qualified Name, fallback on SID", "fqn");
        items.add("SID", "sid");
        items.add("Both FQN and SID", "both");
        return items;
    }

    public ListBoxModel doFillProtocolsItems() {
        ListBoxModel items = new ListBoxModel();
        items.add("Negotiate, fallback on NTLM", "Negotiate NTLM");
        items.add("NTLM, fallback on Negotiate", "NTLM Negotiate");
        items.add("Negotiate only", "Negotiate");
        items.add("NTLM only", "NTLM");
        return items;
    }

    public ListBoxModel doFillProvidersItems() {
        ListBoxModel items = new ListBoxModel();
        items.add("Negotiate, then Basic", NegotiateSecurityFilterProvider.class.getName() + " " + BasicSecurityFilterProvider.class.getName());
        items.add("Negotiate only", NegotiateSecurityFilterProvider.class.getName());
        items.add("Basic (pop-up login) only", BasicSecurityFilterProvider.class.getName());
        return items;
    }
}

