/*
 * Decompiled with CFR 0.152.
 */
package com.github.farmgeek4life.jenkins.negotiatesso;

import hudson.model.User;
import hudson.security.ACL;
import hudson.security.SecurityRealm;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import jenkins.security.seed.UserSeedProperty;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import waffle.servlet.NegotiateRequestWrapper;
import waffle.servlet.WindowsPrincipal;

public class NegSecUserSeedFilter
implements Filter {
    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof NegotiateRequestWrapper) {
            NegotiateRequestWrapper nrw = (NegotiateRequestWrapper)request;
            WindowsPrincipal principal = (WindowsPrincipal)nrw.getUserPrincipal();
            this.authenticateJenkins(principal, (HttpServletRequest)request);
        }
        chain.doFilter(request, response);
    }

    private void authenticateJenkins(WindowsPrincipal principal, HttpServletRequest httpRequest) {
        String principalName = principal.getName();
        if (principalName.contains("@")) {
            principalName = principalName.substring(0, principalName.indexOf("@"));
        }
        if (principalName.contains("\\")) {
            principalName = principalName.substring(principalName.indexOf("\\") + 1);
        }
        Jenkins jenkins = Jenkins.get();
        SecurityRealm realm = jenkins.getSecurityRealm();
        UserDetails userDetails = realm.loadUserByUsername2(principalName);
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails.getUsername(), (Object)userDetails.getPassword(), userDetails.getAuthorities());
        ACL.as2((Authentication)authToken);
        this.populateUserSeed(httpRequest, userDetails.getUsername());
        SecurityListener.fireLoggedIn((String)userDetails.getUsername());
    }

    @SuppressRestrictedWarnings(value={UserSeedProperty.class})
    private void populateUserSeed(HttpServletRequest httpRequest, String username) {
        if (!UserSeedProperty.DISABLE_USER_SEED) {
            User user = User.getById((String)username, (boolean)true);
            HttpSession newSession = httpRequest.getSession();
            UserSeedProperty userSeed = (UserSeedProperty)user.getProperty(UserSeedProperty.class);
            String sessionSeed = userSeed.getSeed();
            newSession.setAttribute("_JENKINS_SESSION_SEED", (Object)sessionSeed);
        }
    }

    public void destroy() {
    }
}

