/*
 * Decompiled with CFR 0.152.
 */
package com.github.farmgeek4life.jenkins.negotiatesso;

import com.github.farmgeek4life.jenkins.negotiatesso.NegotiateSSO;
import com.google.common.annotations.VisibleForTesting;
import hudson.Functions;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.springframework.security.core.context.SecurityContextHolder;
import waffle.servlet.NegotiateSecurityFilter;

public final class NegSecFilter
extends NegotiateSecurityFilter {
    private static final Logger LOGGER = Logger.getLogger(NegotiateSSO.class.getName());
    public static final String BYPASS_HEADER = "Bypass_Kerberos";
    private boolean redirectEnabled = false;
    private String redirect = "yourdomain.com";
    private boolean allowLocalhost = true;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse) || NegSecFilter.containsBypassHeader(request)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestUri = httpRequest.getRequestURI();
        if (!NegSecFilter.shouldAttemptAuthentication(Jenkins.get(), (ServletRequest)httpRequest, requestUri)) {
            LOGGER.log(Level.FINEST, "Bypassing authentication for {0}", requestUri);
            chain.doFilter(request, response);
            return;
        }
        if (this.allowLocalhost && httpRequest.getLocalAddr().equals(httpRequest.getRemoteAddr())) {
            LOGGER.log(Level.FINEST, "Bypassing authentication for localhost to {0}", requestUri);
            chain.doFilter(request, response);
            return;
        }
        if (this.redirectEnabled && !httpRequest.getLocalAddr().equals(httpRequest.getRemoteAddr())) {
            try {
                String requestedURL = httpRequest.getRequestURL().toString();
                String requestedDomain = new URL(requestedURL).getHost();
                if (!requestedDomain.toLowerCase().contains(this.redirect.toLowerCase())) {
                    String redirectURL = requestedURL.replaceFirst(requestedDomain, requestedDomain + "." + this.redirect);
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    LOGGER.log(Level.FINEST, "Sending redirect for access to {0}", requestUri);
                    httpResponse.sendRedirect(redirectURL);
                    return;
                }
            }
            catch (MalformedURLException e) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.sendError(404, "ERROR: Requested URL \"" + httpRequest.getRequestURL().toString() + "\" does not exist on this server.");
                LOGGER.log(Level.FINE, "Received malformed request \"{0}\" from host {1} (IP {2})", new Object[]{httpRequest.getRequestURL().toString(), httpRequest.getRemoteHost(), httpRequest.getRemoteAddr()});
                return;
            }
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null || !SecurityContextHolder.getContext().getAuthentication().isAuthenticated() || Functions.isAnonymous()) {
            Functions.advertiseHeaders((HttpServletResponse)((HttpServletResponse)response));
            LOGGER.log(Level.FINER, "Filtering request: " + requestUri);
            super.doFilter(request, response, chain);
        } else {
            LOGGER.log(Level.FINEST, "Bypassing filter - already authenticated: " + requestUri);
            chain.doFilter(request, response);
        }
    }

    @VisibleForTesting
    static String cleanRequest(String requestURI) {
        return requestURI.replaceAll("^https?://[^/]+/", "/").replaceAll("\\?.*$", "");
    }

    @VisibleForTesting
    static boolean shouldAttemptAuthentication(Jenkins jenkins, ServletRequest request, String requestURI) {
        String rest = NegSecFilter.cleanRequest(requestURI);
        if (NegSecFilter.isAgentJnlpPath(rest, "jenkins") || NegSecFilter.isAgentJnlpPath(rest, "slave")) {
            if ("true".equals(request.getParameter("encrypt"))) {
                LOGGER.log(Level.FINEST, "NoAuthRequired: Jenkins agent jnlp: " + rest);
                return false;
            }
            LOGGER.log(Level.FINEST, "AuthRequired: Jenkins agent jnlp: " + rest);
            return true;
        }
        return Jenkins.get().isSubjectToMandatoryReadPermissionCheck(rest);
    }

    private static boolean isAgentJnlpPath(String restOfPath, String prefix) {
        return restOfPath.matches("(/manage)?/computer/[^/]+/" + prefix + "-agent[.]jnlp");
    }

    private static boolean containsBypassHeader(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return false;
        }
        return ((HttpServletRequest)request).getHeader(BYPASS_HEADER) != null;
    }

    public void setRedirect(boolean doEnable, String redirectTo) {
        this.redirectEnabled = doEnable;
        this.redirect = redirectTo;
    }

    public void setAllowLocalhost(boolean allow) {
        this.allowLocalhost = allow;
    }
}

